using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Windows.Forms;

using System.Net;
using System.Net.Mail;
using System.Globalization;
using System.Xml;

using TvLibrary.Log;
using TvControl;
using SetupTv;
using TvEngine;
using TvEngine.Events;
using TvLibrary.Interfaces;
using TvLibrary.Implementations;
using TvDatabase;
using TvEngine.PowerScheduler.Interfaces;

using MyTVMail;
using MediaPortal.Plugins;

using Microsoft.Win32;

//using System.Threading;


namespace TvEngine
{
    /// <summary>
    /// base class for tv-server plugins
    /// </summary>
    /// 

    /*
     * Version 1.0.6. 0
     * added support for MP1.1RC2
     * version 1.0.5. 0
     * fixed exception for IOs by including power scheduler events
     * added extended tv wishlist commands
     * fixed conflict checking by adding TvWishlist method
     * improved installer with silent install uninstall for MPEI2
     * map.ReferencedChannelGroup() - could cause exception before (joit debug from TvWishList)
     * Version 1.0.4. 3
     * basic provider checking in email Class
     * TvWishList keyword support ADDTV,EDITTV,DELETETV,LISTTV with keywords ACTIVE, SEARCHFOR, MATCHTYPE, GROUP, RECORDTYPE, ACTION, EXCLUDE
     * added user definition for MAX_EMAILS, MAX_EPG, MAXWAIT
     * Version 1.0.4. 2
     * Email address of the SMTP server can be separately specified if it is not identical to the user name
     * tvserver does not start receiving email immediately but first time after the checking interval
     * if the mail server is sending both html and plain textmail only one is being processed
     * version 1.0.4. 1
     * fixed installer bug for uninstalling plugin
     * added autoinstaller support for Windows 7 and 64 bit versions
     * added support for different smtp/pop3 server authorization with username and password
     * changed TV_PROGRAM_FOLDER\EmailScheduler  to TV_USER_FOLDER\EmailScheduler
     * fixed bug for Processing ongoing wait for completion in case of error state
     * 
     * version 1.0.4. 0
     * fixed bug in installer for uninstalling EmailSCheduler.dll (Directory.Delete caused exception)
     * 
     * version 1.0.3. 1
     * new keyword UseSchedulename=true for renaming recorded file, xmlfile and updating recording entry
     * minutes for next email check can be reduced down to 1 minute
     * server mail processing accelerated by less wait states (more effective reading of emails)
     * 10 minute timeout for initial BUSY state waiting
     * improved warning and error messages
     * added keyword AddSchedule again
     * fixed bug with incorrect end time parsing in autocompletion
     * 
     * Version 1.0.3. 0
     * minutes for next email check, minimum interval is 5 minutes              
     * partial names for program names when using PARTIALPROGRAM=<string>       
     * schedule allpartial program names using ALLPARTIALPROGRAMS               
     * help=epg return email with filtered epg data max number is 1000          
     * reply .response files for run command                                    
     * prevent standby during receiving emails                                  
     * groupnames for channels                                                  
     * groupnames for help channels in group                                    
     * list available drive space for help schedules                            
     * remove seconds in all date time formats                                  
     * max number of emails to be processed: 100
     * max wait time for run scripts 5 minutes
     * 
     * Version 0.0.0.2
     * faster server communication
     * delete mail from server after processing
     * run user scripts
     * help schedules command
     * help channels command
     * bug fixes
     * improved encoding (=3D issue of urev)
     * support for html mails
     * 
     * Version 0.0.0.1
     * initial release
    */
    [CLSCompliant(false)]
    public class EmailScheduler : ITvServerPlugin
    {
   
        #region Members
        public const byte NO_SSL = 0;
        public const byte SSL_PORT = 1;
        public const byte STLS = 2;
        

        
        //static System.Timers.Timer m_timer;
        MailClass m_mc = new MailClass(); // our class with the comm-parts
        ITvServerEvent events = null;
        
        IPowerController powerinstance = null;

        System.Threading.Thread receivethread = null;
 
        static DateTime _NextEmailTime = System.DateTime.Now;
        bool runpolling = true;
        bool recording = false;
        //bool powerschedulerstandby = false;
        bool DEBUG = false;
        string TV_USER_FOLDER="NOTFOUND";
        string FileRenameXML = "FileRenameXML.xml"; //global file containing all file renaming jobs

        #endregion Members


        #region properties
        /// <summary>
        /// returns the name of the plugin
        /// </summary>
        public string Name
        {
            get { return "EmailScheduler"; }
        }

        /// <summary>
        /// returns the version of the plugin
        /// </summary>
        public string Version { get { return "1.0.6.1"; } }

        /// <summary>
        /// returns the author of the plugin
        /// </summary>
        public string Author { get { return "huha"; } }

        /// <summary>
        /// returns if the plugin should only run on the master server
        /// or also on slave servers
        /// </summary>
        public bool MasterOnly { get { return false; } }

      
        #endregion

        #region Methods
        /// <summary>
        /// Starts the plugin
        /// </summary>
        [CLSCompliant(false)]
        public void Start(IController controller)
        {
            

            Log.Info("Email Scheduler started");
            SystemEvents.PowerModeChanged += new PowerModeChangedEventHandler(SystemEvents_PowerModeChanged);


            System.Threading.Thread th = new System.Threading.Thread(starterthread);
            th.IsBackground = true;
            th.Start();
            Logdebug("strater thread started");
            
            

            
        }

        public void starterthread()
        {
            TvBusinessLayer layer = new TvBusinessLayer();
            Setting setting = null;

            try  //get power scheduler instance and enable events
            {
                powerinstance = RemotePowerControl.Instance;

                //enable events
                events = GlobalServiceProvider.Instance.Get<ITvServerEvent>();
                events.OnTvServerEvent += new TvServerEventHandler(events_OnTvServerEvent);

                setting = layer.GetSetting("pluginPower Scheduler", "false");
                Log.Debug("pluginPower Scheduler = "+setting.Value);



                /*
                bool found = false;
                if (setting.Value == "true")
                {
                    for (int i = 0; i < 100; i++) //100s maximum
                    {
                        System.Threading.Thread.Sleep(1000); //wait 1s
                        if (GlobalServiceProvider.Instance.IsRegistered<IPowerScheduler>())
                        {
                            Log.Debug("EmailScheduler: Power Scheduler <IPowerScheduler> is registered");
                            GlobalServiceProvider.Instance.Get<IPowerScheduler>().OnPowerSchedulerEvent += new PowerSchedulerEventHandler(EmailScheduler_OnPowerSchedulerEvent);
                            Logdebug("GlobalServiceProvider.Instance.Get<IPowerScheduler>().OnPowerSchedulerEvent activated");
                            found = true;
                            break;
                        }
                        
                        
                    }
                }

                if (found == false)
                {
                    Log.Debug("EmailScheduler: Power Scheduler <IPowerScheduler> not registered");
                    
                }*/

            }
            catch (Exception exc)
            {

                Log.Error("Error: Could not get power scheduler instance or register events");
                Log.Error("Exception message is " + exc.Message);
            }



            try
            {
                
                setting = layer.GetSetting("EmailScheduler_Debug", "false");
                if (Convert.ToBoolean(setting.Value) == true)
                {
                    DEBUG = true;
                }
                else
                {
                    DEBUG = false;
                }

                TV_USER_FOLDER = layer.GetSetting("EmailScheduler_TV_USER_FOLDER", "NOT_FOUND").Value;
                if ((File.Exists(TV_USER_FOLDER + @"\TvService.exe") == true) || (Directory.Exists(TV_USER_FOLDER) == false))
                {
                    //autodetect paths
                    InstallPaths instpaths = new InstallPaths();  //define new instance for folder detection
                    instpaths.GetInstallPaths();
                    TV_USER_FOLDER = instpaths.TV_USER_FOLDER;
                    Logdebug("TV server user folder detected at " + TV_USER_FOLDER);

                    if ((File.Exists(TV_USER_FOLDER + @"\TvService.exe") == true) || (Directory.Exists(TV_USER_FOLDER) == false))// error checking for existing directory
                    {
                        Log.Error(@" TV server user folder does not exist - using C:\MediaPortal\EmailScheduler");
                        Logdebug(@" TV server user folder does not exist - using C:\MediaPortal\EmailScheduler");
                        TV_USER_FOLDER = @"C:\MediaPortal";
                        if (Directory.Exists(TV_USER_FOLDER) == false)
                            Directory.CreateDirectory(TV_USER_FOLDER + @"\EmailScheduler");
                    }
                }

                //check email at the next checkinginterval after tv service has been started
                //double values j is number of hours and minutes
                double j = 0;

                setting = layer.GetSetting("EmailScheduler_CheckEmail", "1");
                try
                {
                    j = Convert.ToDouble(setting.Value);
                }
                catch
                {
                    Logdebug("Checking interval set to 1 minutes because of error in converting data base value");
                    j = 1.0 / 60.0;// set to 1 minutes
                }
                if (j < 1.0 / 60.0)
                {
                    j = 1.0 / 60.0;// set to 1 minutes
                    Logdebug("Checking interval set to 1 minutes");
                }
                if (j > 1000)
                {
                    j = 24.0;
                    Logdebug("Error: Checking interval set to 24 hours because range was exceeded");
                }


                //set next time for receive mail
                _NextEmailTime = DateTime.Now;
                _NextEmailTime = _NextEmailTime.AddHours(j);


                //save settings for display in TV server configuration
                setting = layer.GetSetting("EmailScheduler_NextEmailDate");
                setting.Value = _NextEmailTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                setting.Persist();
                Logdebug("Next receive date set to " + _NextEmailTime.ToString());



            }
            catch (Exception ex)
            {
                Log.Debug("Error in starting Email Scheduler: Exception message was " + ex.Message);
                return;

            }

            string emailtransactionbusyfile = TV_USER_FOLDER + @"\EmailScheduler\EmailTransactionBusy.txt";
            if (File.Exists(emailtransactionbusyfile) == true)
            {
                File.Delete(emailtransactionbusyfile);
                Logdebug("Deleted EmailTransactionBusyFile " + emailtransactionbusyfile);
            }


            MailClass m_mc = new MailClass(); // our class with the comm-parts

            if (m_mc == null)
            {
                Logdebug("MailClass could not be initiated - aborting operation");
                Log.Error("MailClass could not be initiated - aborting operation");
                return;
            }
            else
            {
                m_mc.Debug = DEBUG;
            }

            //start pollingthread
            runpolling = true;
            System.Threading.Thread th = new System.Threading.Thread(startpolling);
            th.IsBackground = true;
            th.Start();
            
        }

        


        /// <summary>
        /// Stops the plugin
        /// </summary>
        public void Stop()
        {
            runpolling = false;  //terminate polling loop
            SystemEvents.PowerModeChanged -= new PowerModeChangedEventHandler(SystemEvents_PowerModeChanged);
            //ITvServerEvent events = GlobalServiceProvider.Instance.Get<ITvServerEvent>();
            events.OnTvServerEvent -= new TvServerEventHandler(events_OnTvServerEvent);

            /*  using windows event SystemEvents_PowerModeChanged
            if (GlobalServiceProvider.Instance.IsRegistered<IPowerScheduler>())
            {
                GlobalServiceProvider.Instance.Get<IPowerScheduler>().OnPowerSchedulerEvent -= new PowerSchedulerEventHandler(EmailScheduler_OnPowerSchedulerEvent);
                Logdebug("GlobalServiceProvider.Instance.Get<IPowerScheduler>().OnPowerSchedulerEvent deactivated");
            }*/
            Log.Info("Email Scheduler stopped");
        }

        /// <summary>
        /// returns the setup sections for display in SetupTv
        /// </summary>
        [CLSCompliant(false)]
        public SetupTv.SectionSettings Setup
        {
            get { return new SetupTv.Sections.EmailSchedulerSetup(); }
        }
        #endregion


        #region Implementation


        void startpolling()
        {
            Logdebug("Polling thread started");
            while (runpolling == true)
            {
                System.Threading.Thread.Sleep(60000); //sleep 60s
                //Logdebug("Polling Thread Sleeping");
                if ((DateTime.Now > _NextEmailTime) && (recording == false) )
                {
                    SetStandbyAllowed(false);
                    receivethread = new System.Threading.Thread(receiveemail);
                    receivethread.IsBackground = true;
                    receivethread.Start();
                    Logdebug("receive thread started");
                    while (receivethread.ThreadState == System.Threading.ThreadState.Running)
                    {
                        System.Threading.Thread.Sleep(1000); //sleep 1s
                    }
                    receivethread = null;
                    SetStandbyAllowed(true);


                }
            }
            Logdebug("Polling thread stopped");

        }

        public void receiveemail()
        {
            Logdebug("receiveemail started");
            


            //get new updated value for next email check
            TvBusinessLayer layer = new TvBusinessLayer();
            Setting setting = null;
            //double values j is number of hours and minutes
            double j = 0;
            
            setting = layer.GetSetting("EmailScheduler_CheckEmail", "1");
            try
            {
                j = Convert.ToDouble(setting.Value);
            }
            catch
            {
                Logdebug("Checking interval set to 1 minutes because of error in converting data base value");
                j = 1.0 / 60.0;// set to 1 minutes
            }
            if (j < 1.0/60.0)
            {
                j = 1.0/60.0;// set to 1 minutes
                Logdebug("Checking interval set to 1 minutes");
            }
            if (j > 1000)
            {
                j = 24.0;
                Logdebug("Error: Checking interval set to 24 hours because range was exceeded");
            }

            //Logdebug("j[hours]="+j.ToString());
            //set next time for receive mail
            _NextEmailTime = DateTime.Now;
            _NextEmailTime = _NextEmailTime.AddHours(j);  //caused exception
            
            Logdebug("Next receive date set to " + _NextEmailTime.ToString());

            //save settings for display in TV server configuration
            setting = layer.GetSetting("EmailScheduler_NextEmailDate");
            setting.Value = _NextEmailTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
            setting.Persist();

            // get DEBUG
            setting = layer.GetSetting("EmailScheduler_Debug", "false");
            if (Convert.ToBoolean(setting.Value) == true)
            {
                m_mc.Debug = true;
                DEBUG = true;
            }
            else
            {
                m_mc.Debug = false;
                DEBUG = false;
            }


            //load last settings and store it in providerstring [0]
            setting = layer.GetSetting("EmailScheduler_Providers_0", "_Last Setting;;0;False;False;;0;False");
            string[] array = setting.Value.Split(";".ToCharArray());
            if (array.Length != 8)
            {
                Log.Error("EmailScheduler Error: Invalid provider string: " + setting.Value + "\n Count is " + array.Length);
                return;
            }

            string ServerAddress = array[1];

            if (ServerAddress == "")
            {
                Log.Error("Server address not specified - aborting email check");
                return;
            }

            //wait for internet connection
            bool InternetConnected = false;
            for (int i = 1; i < 30; i++) //wait up to 300s and check every 10s
            {
                System.Threading.Thread.Sleep(10000); //sleep 10s to wait for internet connection after standby
                //check for existing ip address

                try
                {
                    IPHostEntry hostIP = Dns.GetHostEntry(ServerAddress);
                    IPAddress[] addr = hostIP.AddressList;
                    Logdebug("POP3 Server exists");
                    InternetConnected = true;
                    break;
                }
                catch
                {//continue loop
                    Logdebug("Waiting for internet connection in iteration " + i.ToString());
                }


            }
            if (InternetConnected == false)
            {
                Logdebug("Failed to get internet connection");
                return;
            }

            try
            {
                m_mc.ReadMailBoxController(); //read emails and parse
            }
            catch (Exception ee)
            {
                Log.Error("Reading Emails failed with exception message:");
                Log.Error(ee.Message);
                Log.Debug("Reading Emails failed with exception message:");
                Log.Debug(ee.Message);


                // Delete busy file after email exception
                string emailtransactionbusyfile = m_mc.emailtransactionbusyfile;
                if (File.Exists(emailtransactionbusyfile) == true)
                {
                    File.Delete(emailtransactionbusyfile);
                }
            }


            //evaluate testing from MESSAGE


            if (m_mc.MailError != 0)
            {
                Logdebug("Email Server Error=" + m_mc.MailError);
                Logdebug("Email Server LastAction=" + m_mc.LastAction);
            }


            

        }

        private void ProcessFileRenaming()
        {
            

            string filename = TV_USER_FOLDER + @"\EmailScheduler\" + FileRenameXML;
            Logdebug("Starting ProcessFileRenaming - file=" + filename);
            //process file renaming from xml file
            if (File.Exists(filename) == false)
            {
                Logdebug("Could not find" + filename);
                return;
            }
            //read xml file
            XmlDocument renamexmldoc = new XmlDocument();
            try
            {
                renamexmldoc.Load(filename);
                XmlNode root = renamexmldoc.DocumentElement;
                XmlNodeList nodealljobs = renamexmldoc.SelectNodes("/AllJobs/Job");
                

#if(MP100)
            IList allrecordings = Recording.ListAll();
#elif(MP101)
            IList<Recording> allrecordings = Recording.ListAll();
#elif(MP11 || MP12)
                IList<Recording> allrecordings = Recording.ListAll();
#endif
                foreach (XmlNode nodejob in nodealljobs)
                {
                    //get xml node
                    string programname = nodejob.Attributes["ScheduleName"].Value;                   
                    DateTime startTime = DateTime.ParseExact(nodejob.Attributes["Start"].Value, "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                    Logdebug("startTime =" + startTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture));
                    DateTime endTime = DateTime.ParseExact(nodejob.Attributes["End"].Value, "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                    Logdebug("endTime =" + endTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture));
                    int channelid=Convert.ToInt32(nodejob.Attributes["idChannel"].Value);
                    Logdebug("channelid =" + channelid.ToString());

                    if (DateTime.Now > endTime)
                    {
                        root.RemoveChild(nodejob);
                        
                        Logdebug("Removing childnode");
                    }

                    //search all my recordings for match
                    foreach (Recording myrecording in allrecordings)
                    {

                        string myrecording_startstring = myrecording.StartTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                        DateTime myrecording_start = DateTime.ParseExact(myrecording_startstring, "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                        //Logdebug("myrecording_startTime =" + myrecording_start.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture));

                        string myrecording_endstring = myrecording.EndTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                        DateTime myrecording_end = DateTime.ParseExact(myrecording_endstring, "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                        //Logdebug("myrecording_endTime =" + myrecording_end.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture));

                        if ((startTime == myrecording_start) && (endTime == myrecording_end) && (channelid == myrecording.IdChannel) && (File.Exists(myrecording.FileName) == true))
                        { //xml list entry has been recorded and matches start, end time and channel id
                            Logdebug("Schedule matched for "+programname);
                            
                            //rename filename
                            
                            string directory = System.IO.Path.GetDirectoryName(myrecording.FileName);

                            string newname = directory + @"\"+programname+".ts";

                            if (File.Exists(newname) == false)
                            {
                                File.Move(myrecording.FileName, newname);
                                Logdebug("Moving " + myrecording.FileName + " to " + newname);
                                String xmlfilename = myrecording.FileName.Substring(0, myrecording.FileName.Length - 2) + "xml";  //substitute .ts by .xml

                                if (File.Exists(xmlfilename) == true)
                                {
                                    String newxmlfilename = directory + @"\" + programname + ".xml";
                                    File.Move(xmlfilename, newxmlfilename);
                                    Logdebug("Moving " + xmlfilename + " to " + newxmlfilename);

                                    //update name in xml file
                                    try
                                    {
                                        XmlDocument xmlfile = new XmlDocument();
                                        xmlfile.Load(newxmlfilename);
                                        XmlNodeList nodes = xmlfile.SelectNodes("/tags/tag/SimpleTag");
                                        XmlNode firstnode = nodes[0];
                                        firstnode["value"].InnerText = programname;
                                        xmlfile.Save(newxmlfilename);
                                    }
                                    catch (Exception ee)
                                    {
                                        Log.Error("xmlfile update ended with exception message:");
                                        Log.Error(ee.Message);
                                        Log.Debug("xmlfile update ended with exception message:");
                                        Log.Debug(ee.Message);
                                    }
                                }

                                //update recording file name
                                myrecording.FileName = newname;
                                
                            }
                            
                            break;
                        }

                    }

                    
                }
                
                renamexmldoc.Save(filename);

                if (root.HasChildNodes == false)
                {
                    File.Delete(filename);
                    Log.Debug("Deleting xml file as there are no entries");
                }
                

            }
            catch (Exception ee)
            {
                Log.Error("ProcessFileRenaming failed with exception message:");
                Log.Error(ee.Message);
                Log.Debug("ProcessFileRenaming failed with exception message:");
                Log.Debug(ee.Message);
            }
            Log.Debug("ProcessFileRenaming completed");

        }
        

        private void SetStandbyAllowed(bool allowed)
        {
            //use IEPG handler to prevent shutdown
            if (GlobalServiceProvider.Instance.IsRegistered<IEpgHandler>())
            {

                GlobalServiceProvider.Instance.Get<IEpgHandler>().SetStandbyAllowed(this, allowed, 1800);//30 minutes timeout           
                Logdebug("Telling PowerScheduler standby is: "+allowed.ToString()+", timeout is 30 minutes");
            }
        }

        void Logdebug(String text)
        {
            if (DEBUG==true)
                Log.Debug("EmailScheduler TvServer: "+ text);
        }


        /*  using windows event PowerModeChangedEventArgs
        public void EmailScheduler_OnPowerSchedulerEvent(PowerSchedulerEventArgs args)
        {

            Logdebug("powerscheduler args=" + args.EventType.ToString());
            if (args.EventType == PowerSchedulerEventType.ResumedFromStandby)
            {
                powerschedulerstandby = false;
                Log.Debug("Powerscheduler resumed from standby !!!!!!!!!!!!!!!!!!!!"); 
            }
            if (args.EventType == PowerSchedulerEventType.EnteringStandby)
            {
                powerschedulerstandby = true;
                Log.Debug("Powerscheduler going into standby !!!!!!!!!!!!!!!!!!!!");
            }
        }*/



        void events_OnTvServerEvent(object sender, EventArgs eventArgs)
        {
            TvServerEventArgs tvEvent = (TvServerEventArgs)eventArgs;
            switch (tvEvent.EventType)
            {
                ///StartZapChannel is called just before the server is going to change channels

                ///StartRecording is called just before the server is going to start recording
                case TvServerEventType.StartRecording:
                    recording = true;
                    Logdebug("Recording flag set to true - start recording");
                    break;
                ///RecordingStarted is called when the recording is started
                case TvServerEventType.RecordingStarted:
                    recording = true;
                    Logdebug("Recording flag set to true- recording started");
                    break;
                ///RecordingEnded is called when the recording has been stopped
                case TvServerEventType.RecordingEnded:
                    recording = false;
                    Logdebug("Recording flag set to false - recording ended");
                    //check for filerenaming
                    ProcessFileRenaming();
                    break;
                ///Timeshifting started
                case TvServerEventType.StartTimeShifting:
                    recording = true;
                    Logdebug("Recording flag set to true -start timeshifting");
                    break;
                ///Timeshifting ended
                case TvServerEventType.EndTimeShifting:
                    recording = false;
                    Logdebug("Recording flag set to false -stop timeshifting");
                    break;
            }
        }

       

        private void SystemEvents_PowerModeChanged(object sender, PowerModeChangedEventArgs e)
        {
            Logdebug("SystemEvents_PowerModeChanged ="+e.Mode.ToString() );
            if( e.Mode == PowerModes.Suspend )
            {
                Logdebug("SystemEvents Suspend");
                if (receivethread != null)
                {
                    Logdebug("Aborting receive thread because of system standby event");
                    Log.Error("Aborting receive thread because of system standby event");
                    receivethread.Abort();
                }
            }
            else if (e.Mode == PowerModes.Resume)
            {
                Logdebug("SystemEvents Resume");
            }
            else if (e.Mode == PowerModes.StatusChange)
            {
                Logdebug("SystemEvents Status Change");
            }
        }
        #endregion
    }
}
