using System;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;

using System.Collections;

using System.Net;
using System.Net.Sockets;
using System.Net.Security;
using System.Security.Cryptography.X509Certificates;
using System.Security.Cryptography;
using System.Net.Mail;


using TvControl;
using SetupTv;
using TvEngine;
using TvEngine.Events;
using TvLibrary;
using TvLibrary.Log;
using TvLibrary.Interfaces;
using TvLibrary.Implementations;
using TvDatabase;
using Gentle.Common;
using Gentle.Framework;

using MyTVMail;
using MediaPortal.Plugins;


namespace SetupTv.Sections
{
    [CLSCompliant(false)]
    public partial class EmailSchedulerSetup : SetupTv.SectionSettings
    {
        int ProviderLength = 200;  //max number of provider settings
        string[] providers = new string[20];
        string TV_USER_FOLDER = "NOT_FOUND";
        bool DEBUG = false;
        MailClass m_mc = new MailClass(); // our class with the comm-parts
        //System.Windows.Forms.Timer msgtimer = new System.Windows.Forms.Timer();
        

        public const byte NO_SSL = 0;
        public const byte SSL_PORT = 1;
        public const byte STLS = 2;
        public bool BUSY = false;

        enum LogSetting
        {
            DEBUG=1,
            ERROR,
            ERRORONLY,
            INFO,
            MESSAGE,
            ADDRESPONSE
        }

        InstallPaths instpaths = new InstallPaths();  //define new instance for folder detection
        

        #region Constructor
        public EmailSchedulerSetup()
        {
            InitializeComponent();
        }
        #endregion Constructor

        #region SetupTv.SectionSettings

        public override void OnSectionActivated()
        {
            Log.Info("EmailScheduler: Configuration activated");
            try
            {
                LoadSettings();
            }
            catch (Exception ex)
            {
                LogDebug("Fatal Error: Failed to load settings - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
                LogDebug("Trying to resave settings to data base", (int)LogSetting.ERROR);
                try
                {
                    SaveSettings();
                    LogDebug("Saving settings succeeded", (int)LogSetting.ERROR);
                }
                catch
                {
                    LogDebug("Fatal Error: Faileed to save settings", (int)LogSetting.ERROR);
                }
            }
            base.OnSectionActivated();
            if (m_mc != null)
            {
                m_mc.newlabelmessage += new setuplabelmessage(labelupdate);
            }
        }
        public override void OnSectionDeActivated()
        {
            Log.Info("EmailScheduler: Configuration deactivated");
            try
            {
                SaveSettings();
            }
            catch (Exception ex)
            {
                LogDebug("Fatal Error: Failed to save settings - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
            }

            if (m_mc != null)
            {
                m_mc.newlabelmessage -= new setuplabelmessage(labelupdate);
            }

            /* not needed
            if (BUSY == true)
            {
                Log.Debug("BackupSettingsSetup: Kill SetupTv process");
                Process[] processes = Process.GetProcessesByName("SetupTv");
                MessageBox.Show("Tv Server Configuration will be terminated because you exited EmailScheduler before finishing your last operation", "User Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                //killing setuptv because threads are still running 
                foreach (Process process in processes)
                {
                    process.Kill();
                }
            }*/

        }
        #endregion SetupTv.SectionSettings

        private void EmailSenderListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                TextBoxEditEmailSender.Text = (string)ListBoxEmailSender.SelectedItem;
            }
            catch
            {
                // ignore errors in list box selection
            }
        }


        private void ButtonAdd_Click_1(object sender, EventArgs e)
        {
            ListBoxEmailSender.Items.Add(TextBoxEditEmailSender.Text);
        }

        private void ButtonDelete_Click(object sender, EventArgs e)
        {
            try
            {
                string tmp = (string)ListBoxEmailSender.SelectedItem;
                ListBoxEmailSender.Items.Remove(tmp);
            }
            catch
            {
                // ignore errors in list box selection
            }
        }

        private void EditButton_Click(object sender, EventArgs e)
        {
            try
            {
                TextBoxEditEmailSender.Text = (string)ListBoxEmailSender.SelectedItem;
            }
            catch
            {
                // ignore errors in list box selection
            }
        }

        private void ResetCounterButton_Click(object sender, EventArgs e)
        {
            LabelRecordingHours.Text = "0";
        }

        private void DeleteTanButton_Click(object sender, EventArgs e)
        {
            try
            {
                string tmp = (string)ListBoxTAN.SelectedItem;
                ListBoxTAN.Items.Remove(tmp);
            }
            catch
            {
                // ignore errors in list box selection
            }
        }

        private void TANListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                TextBoxEditTan.Text = (string)ListBoxTAN.SelectedItem;
            }
            catch
            {
                // ignore errors in list box selection
            }
        }

        private void EditTanButton_Click(object sender, EventArgs e)
        {
            try
            {
                TextBoxEditTan.Text = (string)ListBoxTAN.SelectedItem;
            }
            catch
            {
                // ignore errors in list box selection
            }
        }

        private void AddTanButton_Click(object sender, EventArgs e)
        {
            try
            {
                RemoveLargerSmaller(TextBoxEditTan, "TAN");
                string tmp = trimstring(TextBoxEditTan.Text);
                if (tmp.Length > 0)
                {
                    ListBoxTAN.Items.Add(tmp);
                    TextBoxEditTan.Text = tmp;
                }
            }
            catch
            {
                // ignore errors in list box selection
            }
        }


        public string trimstring(string substring)
        {
            /* 
             * remove character 13 at end (line return)
             * remove leading and trailing tabs and spaces
            */
            if (substring.Length < 1)
                return substring;

            if (Convert.ToInt16(substring[substring.Length - 1]) == 13)
            {
                substring = substring.Substring(0, substring.Length - 1);
            }

            //remove leading spaces and tabs
            while ((substring.StartsWith(" ")) || (substring.StartsWith("\t")))
            {
                substring = substring.Substring(1, substring.Length - 1);
            }

            //remove trailing spaces and tabs
            while ((substring.EndsWith(" ")) || (substring.EndsWith("\t")))
            {
                substring = substring.Substring(0, substring.Length - 1);
            }
            return substring;



        }

        private void ButtonTestReceive_Click(object sender, EventArgs e)
        {
            if (BUSY == true)
            {
                MessageBox.Show("Processing ongoing - please wait for completion", "Warning");
                return;
            }
            BUSY = true;
            System.Threading.Thread th = new System.Threading.Thread(TestReceive);
            th.Start();
                   
        }
   
        private void TestReceive()
        {

            try
            {
                SaveSettings();
            }
            catch (Exception ex)
            {
                LogDebug("Fatal Error: Failed to save settings - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
                BUSY = false;
                return;
            }

            try
            {
                LoadSettings();
            }
            catch (Exception ex)
            {
                LogDebug("Fatal Error: Failed to load settings - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
                BUSY = false;
                return;
      
            }
            
            if (TextBoxPop3Server.Text == "")
            {
                LogDebug("No POP3 Provider specified", (int)LogSetting.ERROR);
                MessageBox.Show("No POP3 Provider specified", "Error");
                BUSY = false;
                return;

            }
            if (TextBoxUserName.Text == "")
            {
                LogDebug("No Pop3 User Name specified", (int)LogSetting.ERROR);
                MessageBox.Show("No Pop3 User Name specified", "Error");
                BUSY = false;
                return;

            }
            


            if (TextBoxPassword.Text == "")
            {
                LogDebug("No Server Pop3 Password specified", (int)LogSetting.ERROR);
                MessageBox.Show("No Server Pop3 Password specified", "Error");
                BUSY = false;
                return;

            }

            if (TextBoxEmailSubject.Text == "")
            {
                LogDebug("No Subject specified", (int)LogSetting.ERROR);
                MessageBox.Show("No Subject specified", "Error");
                BUSY = false;
                return;

            }

            if (numericUpDownPop3Port.Value == 0)
            {
                LogDebug("Serverport not defined", (int)LogSetting.ERROR);
                MessageBox.Show("Serverport not defined", "Error");
                BUSY = false;
                return;
            }

            
            


            
            if (m_mc != null)
            {
                m_mc.Debug = DEBUG;
            }
            else
            {
                LogDebug("MailClass could not be initiated - aborting operation", (int)LogSetting.ERROR);
                MessageBox.Show("MailClass could not be initiated - aborting operation", "Error");
                BUSY = false;
                return;
            }



            
            labelstatusline.Text = "Status: Receiving Emails";
            labelstatusline.Update();



            try
            {
                m_mc.ReadMailBoxController();
            }
            catch (Exception ee)
            {
                LogDebug("Reading Emails failed with exception message:", (int)LogSetting.ERROR);
                LogDebug(ee.Message, (int)LogSetting.ERROR);

                // Delete busy file after email exception

                string emailtransactionbusyfile = m_mc.emailtransactionbusyfile;
                if (File.Exists(emailtransactionbusyfile)==true)
                {
                    File.Delete(emailtransactionbusyfile);
                }
                
            }
            
            labelstatusline.Text = "Status: Ready";
            labelstatusline.Update();
                
            //evaluate testing from ServerSuccess and socket error message

            if (m_mc.ServerSuccess == 0)
            {
                if (m_mc.MailError == 6) //porterror
                {
                    MessageBox.Show("Could not connect to Server\nSuspect incorrect port number", "Receive Email Error");
                }
                else if (m_mc.MailError == 7) //ssl error
                {
                    MessageBox.Show("Could not connect to Server\nSuspect incorrect SSL/TSL flag", "Receive Email Error");
                }
                else if (m_mc.MailError == 8) //pop3 server name does not exist
                {
                    MessageBox.Show("Could not connect to Server\nIncorrect POP3 server name or no internet conection", "Receive Email Error");
                }
                else
                {
                    MessageBox.Show("Could not connect to Server", "Receive Email Error");
                }
            }
            else if (m_mc.ServerSuccess == 1)
            {
                MessageBox.Show("Incorrect user name", "Receive Email Error");
            }
            else if (m_mc.ServerSuccess == 2)
            {
                MessageBox.Show("Incorrect user or password name", "Receive Email Error");
            }
            else
            {
                MessageBox.Show("Successful connection to email server", "Receive Email Success");
            }




            if (DEBUG == true)
            {
                if (m_mc.MailError != 0)
                {
                    LogDebug("Email Server Error=" + m_mc.MailError, (int)LogSetting.ERROR);
                    LogDebug("Email Server LastAction=" + m_mc.LastAction, (int)LogSetting.ERROR);
                    MessageBox.Show("Email Server Error=" + m_mc.MailError + "\n LastAction=" + m_mc.LastAction);
                }
                //MessageBox.Show(m_mc.Message, "Result of Testing POP3 Server:");
            }









            try
            {
                LoadSettings();
            }
            catch (Exception ex)
            {
                LogDebug("Fatal Error: Failed to load settings - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
                LogDebug("Trying to resave settings to data base", (int)LogSetting.ERROR);
                try
                {
                    SaveSettings();
                }
                catch
                {
                    LogDebug("Fatal Error: Faileed to save settings", (int)LogSetting.ERROR);
                    BUSY = false;
                    return;
                }
            }
            BUSY = false;

		//register Server Finished Event
        }

        
        private void labelupdate(string message)
        {
            labelstatusline.Text = message;
            labelstatusline.Update();
            
        }

        private void buttonTestSend_Click(object sender, EventArgs e)
        {
            if (BUSY == true)
            {
                MessageBox.Show("Processing ongoing - please wait for completion", "Warning");
                return;
            }
            BUSY = true;
            System.Threading.Thread th = new System.Threading.Thread(TestSend);
            th.Start();
        }

        private void TestSend()
        {
            
            string testreceiver = TextBoxTestReceiver.Text;
            try
            {
                SaveSettings();
            }
            catch (Exception ex)
            {
                LogDebug("Fatal Error: Failed to save settings - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
                BUSY = false;
                return;
            }

            try
            {
                LoadSettings();
            }
            catch (Exception ex)
            {
                LogDebug("Fatal Error: Failed to load settings - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
                BUSY = false;
                return;

            }

            if (TextBoxSmtpServer.Text == "")
            {
                LogDebug("No Smtp Provider specified", (int)LogSetting.ERROR);
                MessageBox.Show("No Smtp Provider specified", "Error");
                BUSY = false;
                return;
            }
            if (TextBoxUserName.Text == "")
            {
                LogDebug("No User Name specified", (int)LogSetting.ERROR);
                MessageBox.Show("No User Name specified", "Error");
                BUSY = false;
                return;
            }
            if (testreceiver == "")
            {
                LogDebug("No receiver for testing specified", (int)LogSetting.ERROR);
                MessageBox.Show("No receiver for testing specified", "Error");
                BUSY = false;
                return;
            }

            if (numericUpDownSmtpPort.Value == 0)
            {
                LogDebug("Serverport not defined", (int)LogSetting.ERROR);
                MessageBox.Show("Serverport not defined", "Error");
                BUSY = false;
                return;
            }

            try
            {
                IPHostEntry hostIP = Dns.GetHostEntry(TextBoxSmtpServer.Text);
                IPAddress[] addr = hostIP.AddressList;
                LogDebug("SMTP Server exists", (int)LogSetting.DEBUG);
            }
            catch
            {
                LogDebug("SMTP Server does not exist - check the SMTP server name and your internet connection", (int)LogSetting.ERROR);

                MessageBox.Show("Pop3 Server does not exist - check the POP3 server name and your internet connection", "Error");
                BUSY = false;
                return;
            }


            // build the email message
            labelstatusline.Text = "Status: Sending Email";
            labelstatusline.Update();

                                                                                                             
            SendTvServerEmail sendobject = new SendTvServerEmail(TextBoxSmtpServer.Text, Convert.ToInt32(numericUpDownSmtpPort.Value), checkBoxSSL.Checked, TextBoxUserName.Text, TextBoxPassword.Text, textBoxSmtpEmailAdress.Text);
            sendobject.Debug = DEBUG;


            bool ok = sendobject.SendNewEmail(testreceiver, "Testmail from TvServer", "Test Send Mail Button was pressed on "+DateTime.Now.ToString());

            if (ok)
                MessageBox.Show("Email was successfully sent to \n" + testreceiver + "\nCheck your email account", "Success");
            else if ((sendobject.ErrorMessage=="TIMEOUT")&&(sendobject.Error==true))
            {
                MessageBox.Show("Incorrect Portnumber","Email Send Failed");
            }
            else
            {
                MessageBox.Show("Check your username, password or email address\n Server Error was:\n"+sendobject.ErrorMessage, "Email Send Failed with Errormessage:");
            }
            labelstatusline.Text = "Status: Ready";
            labelstatusline.Update();
            BUSY = false;

        }

        
        public override void SaveSettings()
        {
            TvBusinessLayer layer = new TvBusinessLayer();
            Setting setting;

            //TV User Folder
            setting = layer.GetSetting("EmailScheduler_TV_USER_FOLDER", "NOT_FOUND");
            setting.Value = TV_USER_FOLDER;
            setting.Persist();
	        //checkboxes



            setting = layer.GetSetting("EmailScheduler_Debug", "false");
            if (checkBoxDebug.Checked == true)
                setting.Value = "true";
            else
                setting.Value = "false";
            setting.Persist();

            setting = layer.GetSetting("EmailScheduler_AcceptEmail", "false");
            if (checkBoxAcceptEmail.Checked == true)
        	        setting.Value = "true";
            else
        	        setting.Value = "false";
	        setting.Persist();

	        setting = layer.GetSetting("EmailScheduler_EmailPassword", "false");
            if (checkBoxUseSchedulerPassword.Checked == true)
                        setting.Value = "true";
            else
                        setting.Value = "false";
		    setting.Persist();


	        setting = layer.GetSetting("EmailScheduler_UseTAN", "false");
            if (checkBoxUseTAN.Checked == true)
        	        setting.Value = "true";
            else
        	        setting.Value = "false";
		    setting.Persist();


	        setting = layer.GetSetting("EmailScheduler_UseRecordingHourLimit", "false");
            if (checkBoxUseRecordingHourLimit.Checked == true)
       		        setting.Value = "true";
            else
        	        setting.Value = "false";
		    setting.Persist();


	        setting = layer.GetSetting("EmailScheduler_AllowDelete", "true");
            if (checkBoxAllowDelete.Checked == true)
        	        setting.Value = "true";
            else
        	        setting.Value = "false";
		    setting.Persist();


	        setting = layer.GetSetting("EmailScheduler_AllowRecord", "true");
            if (checkBoxAllowRecord.Checked == true)
        	        setting.Value = "true";
            else
        	        setting.Value = "false";
		    setting.Persist();


	        setting = layer.GetSetting("EmailScheduler_ReplyToEmails", "true");
            if (checkBoxReplyToEmails.Checked == true)
        	        setting.Value = "true";
            else
        	        setting.Value = "false";
		    setting.Persist();

            setting = layer.GetSetting("EmailScheduler_AllowSeriesSchedules", "false");
            if (checkBoxAllowSeriesSchedules.Checked == true)
                setting.Value = "true";
            else
                setting.Value = "false";
            setting.Persist();

            setting = layer.GetSetting("EmailScheduler_AllowHelpChannel", "false");
            if (checkBoxAllowHelpChannel.Checked == true)
                setting.Value = "true";
            else
                setting.Value = "false";
            setting.Persist();

            setting = layer.GetSetting("EmailScheduler_AllowRunScripts", "false");
            if (checkBoxAllowRunScripts.Checked == true)
                setting.Value = "true";
            else
                setting.Value = "false";
            setting.Persist();

            setting = layer.GetSetting("EmailScheduler_AllowHelpSchedule", "false");
            if (checkBoxAllowHelpSchedule.Checked == true)
                setting.Value = "true";
            else
                setting.Value = "false";
            setting.Persist();

            setting = layer.GetSetting("EmailScheduler_AllowHelpEPG", "false");
            if (checkBoxAllowEPGHelp.Checked == true)
                setting.Value = "true";
            else
                setting.Value = "false";
            setting.Persist();

            setting = layer.GetSetting("EmailScheduler_AllowTvWishList", "false");
            if (checkBoxTvwishlist.Checked == true)
                setting.Value = "true";
            else
                setting.Value = "false";
            setting.Persist();
                                        
            setting = layer.GetSetting("EmailScheduler_DeleteMailFromServer", "false");
            if (checkBoxdeletefromserver.Checked == true)
                setting.Value = "true";
            else
                setting.Value = "false";
            setting.Persist();

            


            //labels
	        setting = layer.GetSetting("EmailScheduler_RecordingHours", "0");
            setting.Value = LabelRecordingHours.Text;
		    setting.Persist();
            


            //textboxes
            
            RemoveLargerSmaller(TextBoxEmailSubject,"Subject");
	        setting = layer.GetSetting("EmailScheduler_EmailSubject", "");         
	        setting.Value = trimstring(TextBoxEmailSubject.Text);
		    setting.Persist();

	        setting = layer.GetSetting("EmailScheduler_UserName", "");
            setting.Value = trimstring(TextBoxUserName.Text);
		    setting.Persist();

		    if (TextBoxPassword.Text !=TextBoxPassword2.Text)
		    {
			    MessageBox.Show("Error: Your Pop3 password does not match and is reset - please enter password again","Error: Passwords Do Not Match");
			    TextBoxPassword.Text="";
			    TextBoxPassword2.Text="";
		    }

	        setting = layer.GetSetting("EmailScheduler_Password", "");
            setting.Value = trimstring(TextBoxPassword.Text);
		    setting.Persist();

            if (textBoxSmtpEmailAdress.Text == "")
            {
                textBoxSmtpEmailAdress.Text = TextBoxUserName.Text;
            }

            setting = layer.GetSetting("EmailScheduler_SmtpEmailAddress", "");
            setting.Value = trimstring(textBoxSmtpEmailAdress.Text);
            setting.Persist();
            
            RemoveLargerSmaller(TextBoxSchedulerPassword, "Password");
	        setting = layer.GetSetting("EmailScheduler_SchedulerPassword", "");
            setting.Value = trimstring(TextBoxSchedulerPassword.Text);
		    setting.Persist();

	        setting = layer.GetSetting("EmailScheduler_TestReceiver", "");
            setting.Value = trimstring(TextBoxTestReceiver.Text);
		    setting.Persist();

	        setting = layer.GetSetting("EmailScheduler_EditEmailSender", "");
            setting.Value = trimstring(TextBoxEditEmailSender.Text);
		    setting.Persist();

	        setting = layer.GetSetting("EmailScheduler_EditTan", "");
            setting.Value = trimstring(TextBoxEditTan.Text);
		    setting.Persist();

            //arrays
        	

            try
            {
	   	        setting = layer.GetSetting("EmailScheduler_EmailSender", "");
                string temp = "";
                for (int i = 0; i < ListBoxEmailSender.Items.Count; i++)
                {
                      temp += ListBoxEmailSender.Items[i] + "\n";
                }
                //remove last character
                if (temp.Length > 0)
                      temp = temp.Substring(0, temp.Length - 1);

		        setting.Value = temp;
                setting.Persist();

            }
            catch (Exception ex)
            {
                LogDebug("Failed to write Email Sender ListBox to data base - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
            }
            try
            {


		        setting = layer.GetSetting("EmailScheduler_TAN", "");
                string temp = "";
                for (int i = 0; i < ListBoxTAN.Items.Count; i++)
                {
                     temp += ListBoxTAN.Items[i] + "\n";
                }
                //remove last comma
                if (temp.Length > 0)
                      temp = temp.Substring(0, temp.Length - 1);

		        setting.Value = temp;
                        setting.Persist();

            }
            catch (Exception ex)
            {
                LogDebug("Failed to write TAN ListBox to data base - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
            }


            try
            {
                try
                {
                    providerupdate(0);  //store last settings as first provider defaults
                }
                catch 
                {//ignore errors
			        LogDebug("Last user settings could not be stored", (int)LogSetting.ERROR);
                }
                for (int i=0; i< listBoxProvider2.Items.Count; i++)  //last settings are stored at position 0 for custom provider
	            {
                    setting = layer.GetSetting("EmailScheduler_Providers_"+i.ToString(), ";;;;;;;");
                    //LogDebug("provider_"+i.ToString()+" = "+providers[i]);
                    setting.Value = providers[i];
                    if (setting.Value == null)
                    {
                        setting.Value = ";;;;;;;";
                        
                    }
		            setting.Persist();
	            }
                
	        }
            catch (Exception ex)
            {
                LogDebug("Failed to write Provider ListBox to data base - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
            }
            
	        //float number
            //double time = Convert.ToDouble(numericUpDownCheckEmail.Value)+Convert.ToDouble(comboBoxminutes.Text)/60.0;
            double time = Convert.ToDouble(comboBoxhours.Text) + Convert.ToDouble(comboBoxminutes.Text) / 60.0;

            // get old time
            setting = layer.GetSetting("EmailScheduler_CheckEmail", "24");
            double oldtime = Convert.ToDouble(setting.Value);

            //LogDebug("saving time=" + time.ToString(), (int)LogSetting.DEBUG);
            if (time < 1.0/60.0) // less than 1 minutes
            {
                MessageBox.Show("Email checking time must be larger or equal than 1 minutes\nMore than 15 minutes are recommended to avoid access errors with many freemail providers","Error");
                time = 1.0 / 60.0;
                comboBoxminutes.Text = "01";
                comboBoxhours.Text = "00";
            }
            if (time > 1000)
            {
                time = 24.0;
                LogDebug("Error: Checking interval set to 24 hours because range was exceeded", (int)LogSetting.ERROR);
            }
            //LogDebug("time=" + time.ToString(), (int)LogSetting.DEBUG);
	        setting = layer.GetSetting("EmailScheduler_CheckEmail", "24");
            setting.Value = time.ToString();
		    setting.Persist();

            //restart tv service if a new value is set
            if ((Math.Round(time - oldtime, 3) > 0.0001) || (Math.Round(time - oldtime, 3) < -0.0001))
            {
                MessageBox.Show("Restarting TV Service to update new email check time","Info");
                LogDebug("Restarting TV service due to new emailcheckdate", (int)LogSetting.DEBUG);
                LogDebug("Time="+time.ToString(), (int)LogSetting.DEBUG);
                LogDebug("OldTime=" + time.ToString(), (int)LogSetting.DEBUG);
                //Stopping tv service 
                labelstatusline.Text = "Stopping TV Service";
                labelstatusline.Update();
                Process proc = new Process();
                ProcessStartInfo startinfo = new ProcessStartInfo();
                startinfo.FileName = "cmd.exe";
                startinfo.WorkingDirectory = "";
                startinfo.Arguments = @"/c net stop tvservice";
                startinfo.UseShellExecute = false;
                startinfo.CreateNoWindow = true;
                startinfo.RedirectStandardError = true;
                startinfo.RedirectStandardInput = true;
                startinfo.RedirectStandardOutput = true;
                proc.StartInfo = startinfo;
                proc.EnableRaisingEvents = false;

                try
                {
                    proc.Start();
                }
                catch (Exception exc)
                {
                    LogDebug("Error: Could not execute command \n" + startinfo.FileName + " " + startinfo.Arguments, (int)LogSetting.ERROR);
                    LogDebug("Exception message was:\n" + exc.Message + "\n", (int)LogSetting.ERROR);
                    return;
                }
                proc.WaitForExit(1000 * 60 * 3); //wait 3 minutes maximum
                if (proc.HasExited == true)
                {
                    if (proc.ExitCode != 0)
                    {
                        labelstatusline.Text = "Tv Service stop error - restart Tv server manually";
                        labelstatusline.Update();
                        LogDebug("Tv Service error: Stopping Tv service caused an error code - restart Tv server manually" + proc.ExitCode, (int)LogSetting.ERROR);
                        return;
                    }
                }
                else
                {
                    labelstatusline.Text = "Tv Service stop timeout error - restart Tv server manually";
                    labelstatusline.Update();
                    LogDebug("Tv Service timeout error: Could not stop Tv service within time limit - restart Tv server manually", (int)LogSetting.ERROR);
                    return;
                }

                //Starting tv service 
                labelstatusline.Text = "Starting TV Service";
                labelstatusline.Update();

                Process proc2 = new Process();
                ProcessStartInfo startinfo2 = new ProcessStartInfo();
                startinfo2.FileName = "cmd.exe";
                startinfo2.WorkingDirectory = "";
                startinfo2.Arguments = @"/c net start tvservice";
                startinfo2.WindowStyle = ProcessWindowStyle.Hidden;
                startinfo2.UseShellExecute = false;
                startinfo2.CreateNoWindow = true;
                startinfo2.RedirectStandardError = true;
                startinfo2.RedirectStandardInput = true;
                startinfo2.RedirectStandardOutput = true;
                proc2.StartInfo = startinfo2;
                proc2.EnableRaisingEvents = false;

                try
                {
                    proc2.Start();
                }
                catch (Exception exc)
                {
                    LogDebug("Error: Could not execute command \n" + startinfo2.FileName + " " + startinfo2.Arguments, (int)LogSetting.ERROR);
                    LogDebug("Exception message was:\n" + exc.Message + "\n", (int)LogSetting.ERROR);
                    return;
                }
                proc2.WaitForExit(1000 * 60 * 3); //wait 3 minutes maximum
                if (proc2.HasExited == true)
                {
                    if (proc2.ExitCode != 0)
                    {
                        labelstatusline.Text = "Tv Service start error - restart Tv server manually";
                        labelstatusline.Update();
                        LogDebug("Tv Service error: Starting Tv service caused an error code - restart Tv server manually" + proc2.ExitCode, (int)LogSetting.ERROR);
                        return;
                    }
                    else //TV service started again
                    {
                        labelstatusline.Text = "Status: Ready";
                        labelstatusline.Update();
                    }
                }
                else
                {
                    labelstatusline.Text = "Tv Service start timeout error - restart Tv server manually";
                    labelstatusline.Update();
                    LogDebug("Tv Service timeout error: Could not start Tv service within time limit - restart Tv server manually", (int)LogSetting.ERROR);
                    return;
                }

            }    


            //integer values
	        setting = layer.GetSetting("EmailScheduler_RecordingHoursLimit", "0");
            setting.Value = numericUpDownMaxRecordingHours.Value.ToString();  
		    setting.Persist();
         
	        setting = layer.GetSetting("EmailScheduler_ProviderSelected", "0");
            int j = listBoxProvider2.SelectedIndex;
            setting.Value = j.ToString();   //select actual item in listbox
		    setting.Persist();

            setting = layer.GetSetting("EmailScheduler_MaxEmails", "100");
            setting.Value = numericUpDownMaxEmail.Value.ToString();
            setting.Persist();

            setting = layer.GetSetting("EmailScheduler_MaxEpg", "500");
            setting.Value = numericUpDownMaxEpg.Value.ToString();
            setting.Persist();

            setting = layer.GetSetting("EmailScheduler_MaxWait", "5");
            setting.Value = numericUpDownMaxWait.Value.ToString();
            setting.Persist();
            
            //
            setting = layer.GetSetting("EmailScheduler_NextEmailDate", DateTime.Now.ToString("yyyy-MM-dd_HH:mm", System.Globalization.CultureInfo.InvariantCulture));
            DateTime NextEmailDate = DateTime.ParseExact(setting.Value, "yyyy-MM-dd_HH:mm", System.Globalization.CultureInfo.InvariantCulture);
            LogDebug("NextEmailDate=" + NextEmailDate.ToString(), (int)LogSetting.DEBUG);



            /*
            DateTime NextDate = DateTime.Now;
            NextDate = NextDate.AddHours(Convert.ToDouble(comboBoxhours.Text));
            NextDate = NextDate.AddHours(1.0); //add 1 hours interval for restart tv service
            
            if (NextEmailDate > NextDate)
            {
                
                MessageBox.Show("Next TV server email checking date is on \n" + NextEmailDate.ToString("yyyy-MM-dd",CultureInfo.InvariantCulture) + " at " + NextEmailDate.ToString("HH:mm:ss",CultureInfo.InvariantCulture) + "\nRestart TV service manually if you want an immediate update", "Warning");
                //msgtimer.Tick -= new EventHandler(msgtimer_elapsed);
            }*/

        }

        public void RemoveLargerSmaller(TextBox mybox,string name)
        {
            string text = mybox.Text;
            string newline = "";
            bool has_changed = false;
            for (int i = 0; i < text.Length; i++)
            {
                if ((text[i] == '<')||(text[i] == '>'))
                {                   
                    has_changed = true;
                }
                else
                {
                    newline += text[i];
                }
            }
            if (has_changed == true)
            {
                MessageBox.Show("The characters \"<\" and \">\" are not allowed and have been removed", name+" Warning");
                mybox.Text = newline;
                mybox.Update();
            }

        }

        public override void LoadSettings()
        {
            
            TvBusinessLayer layer = new TvBusinessLayer();
            Setting setting;




		//check for installation folders
		    setting = layer.GetSetting("EmailScheduler_TV_USER_FOLDER", "NOT_FOUND");
            TV_USER_FOLDER = setting.Value;
            if ((File.Exists(TV_USER_FOLDER + @"\TvService.exe") == true)||(Directory.Exists(TV_USER_FOLDER)==false))
            {
                //autodetect paths
                instpaths.GetInstallPaths();
                TV_USER_FOLDER = instpaths.ask_TV_USER();
                LogDebug("TV server uuser folder detected at " + TV_USER_FOLDER, (int)LogSetting.DEBUG);

                if ((File.Exists(TV_USER_FOLDER + @"\TvService.exe") == true) || (Directory.Exists(TV_USER_FOLDER) == false))
                {
                    LogDebug(@" TV server user folder does not exist - using C:\MediaPortal", (int)LogSetting.ERROR);
			        TV_USER_FOLDER=@"C:\MediaPortal";
                    if (Directory.Exists(TV_USER_FOLDER) == false)
                        Directory.CreateDirectory(TV_USER_FOLDER+@"\EmailScheduler");			
                }
            }

            

	        //checkboxes
            setting = layer.GetSetting("EmailScheduler_Debug", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                checkBoxDebug.Checked = true;
            else
                checkBoxDebug.Checked = false;

            DEBUG = checkBoxDebug.Checked;

	        setting = layer.GetSetting("EmailScheduler_AcceptEmail", "false");
            if (Convert.ToBoolean(setting.Value) == true)
        	        checkBoxAcceptEmail.Checked = true;
            else
        	        checkBoxAcceptEmail.Checked = false;


	        setting = layer.GetSetting("EmailScheduler_EmailPassword", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                        checkBoxUseSchedulerPassword.Checked = true;
            else
                        checkBoxUseSchedulerPassword.Checked = false;


	        setting = layer.GetSetting("EmailScheduler_UseTAN", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                        checkBoxUseTAN.Checked = true;
            else
                        checkBoxUseTAN.Checked = false;

	        setting = layer.GetSetting("EmailScheduler_UseRecordingHourLimit", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                        checkBoxUseRecordingHourLimit.Checked = true;
            else
                        checkBoxUseRecordingHourLimit.Checked = false;

	        setting = layer.GetSetting("EmailScheduler_AllowDelete", "true");
            if (Convert.ToBoolean(setting.Value) == true)
                        checkBoxAllowDelete.Checked = true;
            else
                        checkBoxAllowDelete.Checked = false;

	        setting = layer.GetSetting("EmailScheduler_AllowRecord", "true");
            if (Convert.ToBoolean(setting.Value) == true)
                        checkBoxAllowRecord.Checked = true;
            else
                        checkBoxAllowRecord.Checked = false;

	        setting = layer.GetSetting("EmailScheduler_ReplyToEmails", "true");
            if (Convert.ToBoolean(setting.Value) == true)
                        checkBoxReplyToEmails.Checked = true;
            else
                        checkBoxReplyToEmails.Checked = false;

            setting = layer.GetSetting("EmailScheduler_AllowSeriesSchedules", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                checkBoxAllowSeriesSchedules.Checked = true;
            else
                checkBoxAllowSeriesSchedules.Checked = false;

            setting = layer.GetSetting("EmailScheduler_AllowHelpChannel", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                checkBoxAllowHelpChannel.Checked = true;
            else
                checkBoxAllowHelpChannel.Checked = false;

            setting = layer.GetSetting("EmailScheduler_AllowRunScripts", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                checkBoxAllowRunScripts.Checked = true;
            else
                checkBoxAllowRunScripts.Checked = false;

            setting = layer.GetSetting("EmailScheduler_AllowHelpSchedule", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                checkBoxAllowHelpSchedule.Checked = true;
            else
                checkBoxAllowHelpSchedule.Checked = false;

            setting = layer.GetSetting("EmailScheduler_AllowHelpEPG", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                checkBoxAllowEPGHelp.Checked = true;
            else
                checkBoxAllowEPGHelp.Checked = false;

            setting = layer.GetSetting("EmailScheduler_AllowTvWishList", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                checkBoxTvwishlist.Checked = true;
            else
                checkBoxTvwishlist.Checked = false;

            setting = layer.GetSetting("EmailScheduler_DeleteMailFromServer", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                checkBoxdeletefromserver.Checked = true;
            else
                checkBoxdeletefromserver.Checked = false;

            


	        //labels
	        setting = layer.GetSetting("EmailScheduler_RecordingHours", "0");
            LabelRecordingHours.Text = setting.Value;


            DateTime NextEmailDate = DateTime.Now;
            setting = layer.GetSetting("EmailScheduler_NextEmailDate", DateTime.Now.ToString("yyyy-MM-dd_HH:mm", System.Globalization.CultureInfo.InvariantCulture));
            try
            {
                NextEmailDate = DateTime.ParseExact(setting.Value, "yyyy-MM-dd_HH:mm", System.Globalization.CultureInfo.InvariantCulture);
            }
            catch
            {

            }
            
            labelCheckingdate.Text = NextEmailDate.ToString("yyyy-MM-dd",System.Globalization.CultureInfo.InvariantCulture);
            labelcheckinghour.Text = NextEmailDate.ToString("HH:mm", System.Globalization.CultureInfo.InvariantCulture);
            

            
	        //textboxes

	        setting = layer.GetSetting("EmailScheduler_EmailSubject", "");
            TextBoxEmailSubject.Text = setting.Value;

	        setting = layer.GetSetting("EmailScheduler_UserName", "");
            TextBoxUserName.Text = setting.Value;

	        setting = layer.GetSetting("EmailScheduler_Password", "");
            TextBoxPassword.Text = setting.Value;
		    TextBoxPassword2.Text = setting.Value;

            setting = layer.GetSetting("EmailScheduler_SmtpEmailAddress", "");
            textBoxSmtpEmailAdress.Text = setting.Value;

            if (textBoxSmtpEmailAdress.Text == "")
            {
                textBoxSmtpEmailAdress.Text = TextBoxUserName.Text;
            }
            
	        setting = layer.GetSetting("EmailScheduler_SchedulerPassword", "");
            TextBoxSchedulerPassword.Text = setting.Value;
		
	        setting = layer.GetSetting("EmailScheduler_TestReceiver", "");
            TextBoxTestReceiver.Text = setting.Value;

	        setting = layer.GetSetting("EmailScheduler_EditEmailSender", "");
            TextBoxEditEmailSender.Text = setting.Value;

	        setting = layer.GetSetting("EmailScheduler_EditTan", "");
            TextBoxEditTan.Text = setting.Value;
            try
            {
                    string[] array = layer.GetSetting("EmailScheduler_EmailSender", "").Value.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
                    ListBoxEmailSender.Items.Clear();
                    foreach (string emailitem in array)
                    {
                        ListBoxEmailSender.Items.Add(emailitem);
                    }
            }
            catch (Exception ex)
            {
                    LogDebug("Failed to read Email Sender ListBox from data base - exception message is" + ex.Message, (int)LogSetting.ERROR);
            }

	        try
            {
                    string[] array = layer.GetSetting("EmailScheduler_TAN", "").Value.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
                    ListBoxTAN.Items.Clear();
                    foreach (string tanitem in array)
                    {
                        ListBoxTAN.Items.Add(tanitem);
                    }
            }
            catch (Exception ex)
            {
                LogDebug("Failed to read TAN ListBox from data base - exception message is" + ex.Message, (int)LogSetting.ERROR);
            }




            //load providervalues
            setdefaultproviders(false);

            //load last settings and store it in providerstring [0]
            setting = layer.GetSetting("EmailScheduler_Providers_0", "_Last Setting;;0;False;False;;0;False");
            providers[0] = setting.Value;
            //LogDebug("Load settings: provider_0=" + providers[0]);

            try
            {
                translateprovider(providers[0]);  //restore last user settings providers[0]
            }
            catch
            {
                LogDebug("translateprovider(providers[0]= " + providers[0] + " failed", (int)LogSetting.DEBUG);
            }

            
                
            
	        //double values
            double checktime = 0;
	        setting = layer.GetSetting("EmailScheduler_CheckEmail", "24");
            checktime = Convert.ToDouble(setting.Value);
            //LogDebug("checktime=" + checktime.ToString(), (int)LogSetting.DEBUG);
            if (checktime < 1.0 / 60.0) //1 minutes
            {
                MessageBox.Show("Email checking time must be larger or equal than 1 minute\nMore than 15 minutes are recommended to avoid access errors with many freemail providers", "Error");
                checktime = 1.0 / 60.0;
            }
            if (checktime > 1000)
            {
                checktime = 24.0;
                LogDebug("Error: Checking interval set to 24 hours because range was exceeded", (int)LogSetting.ERROR);
            }
            //LogDebug("checktime=" + checktime.ToString(), (int)LogSetting.DEBUG);
            double checkhours = Math.Truncate(checktime);
            double checkminutes = Math.Round((checktime - checkhours) * 60.0,0);
            //LogDebug("minutes=" + checkminutes.ToString(), (int)LogSetting.DEBUG);
       
            
            if (checkhours < 0)
            {
                LogDebug(" hours=" + checkhours.ToString()+" - settings hours to 0", (int)LogSetting.ERROR);
                checkhours = 0;
            }

            comboBoxhours.Text = checkhours.ToString("00");
            
            if (checkminutes < 0)
            {
                LogDebug(" minutes=" + checkminutes.ToString() + " - settings minutes to 1", (int)LogSetting.ERROR);
                checkminutes = 1;

            }
            comboBoxminutes.Text = checkminutes.ToString("00");


            //integer values
	        setting = layer.GetSetting("EmailScheduler_RecordingHoursLimit", "10");
            int j = Convert.ToInt32(setting.Value);
            if (j < 0)
            {
                j = 0;
            }
            numericUpDownMaxRecordingHours.Value = j;
            
            setting = layer.GetSetting("EmailScheduler_ProviderSelected", "0");            
            j = Convert.ToInt32(setting.Value);
            if ((j < 0)||(j>listBoxProvider2.Items.Count))
            {
                j = 0;
            }
            listBoxProvider2.SetSelected(0,true);   //select custom item in listbox


            setting = layer.GetSetting("EmailScheduler_MaxEmails", "100");
            numericUpDownMaxEmail.Value = Convert.ToInt32(setting.Value);

            setting = layer.GetSetting("EmailScheduler_MaxEpg", "500");
            numericUpDownMaxEpg.Value = Convert.ToInt32(setting.Value);

            setting = layer.GetSetting("EmailScheduler_MaxWait", "5");
            numericUpDownMaxWait.Value = Convert.ToInt32(setting.Value);


            
            
        }

        private void buttonDefault_Click(object sender, EventArgs e)
        {
            //default values are stored here
            checkBoxAllowRecord.Checked = true;
            checkBoxAllowDelete.Checked = true;
            checkBoxReplyToEmails.Checked = true;
            checkBoxDebug.Checked = false;
            checkBoxAllowHelpChannel.Checked = false;
            checkBoxAllowEPGHelp.Checked = false;
            checkBoxAllowRunScripts.Checked = false;
            checkBoxAllowHelpSchedule.Checked = false;
            checkBoxAllowSeriesSchedules.Checked = false;
            checkBoxdeletefromserver.Checked = false;
            checkBoxTvwishlist.Checked = false;
        }


        public void translateprovider(string providerstring)
        {
            TextBoxPop3Server.Text="";
	        numericUpDownPop3Port.Value=0;
	        checkBoxImpliciteSSL.Checked=false;
	        checkBoxExpliciteSSL.Checked=false;
	        TextBoxSmtpServer.Text="";
	        numericUpDownSmtpPort.Value=0;
	        checkBoxSSL.Checked=false;

            string[] array = providerstring.Split(";".ToCharArray());	        
            if (array.Length != 8)
	        {
                LogDebug("Invalid provider string: " + providerstring + "\n Count is " + array.Length, (int)LogSetting.ERROR);               
                MessageBox.Show("Invalid provider string: " + providerstring + "\n Count is " + array.Length,", EmailScheduler Error");
                return;
	        }
      
	        TextBoxPop3Server.Text=array[1];
            numericUpDownPop3Port.Value = Convert.ToInt32(array[2].ToString());
            numericUpDownPop3Port.Update();
            checkBoxImpliciteSSL.Checked = Convert.ToBoolean(array[3].ToString());
            checkBoxImpliciteSSL.Update();
            checkBoxExpliciteSSL.Checked = Convert.ToBoolean(array[4].ToString());
            checkBoxExpliciteSSL.Update();
            TextBoxSmtpServer.Text = array[5].ToString();
            TextBoxSmtpServer.Update();
            numericUpDownSmtpPort.Value = Convert.ToInt32(array[6].ToString());
            numericUpDownSmtpPort.Update();
            checkBoxSSL.Checked = Convert.ToBoolean(array[7].ToString());
            checkBoxSSL.Update();
        }


        public void providerupdate(int selected)
        {
	        if (selected < providers.Length)
	        {
                providers[selected] = listBoxProvider2.Items[selected] + ";" + TextBoxPop3Server.Text + ";" + numericUpDownPop3Port.Value.ToString() + ";" + checkBoxImpliciteSSL.Checked.ToString() + ";" + checkBoxExpliciteSSL.Checked.ToString() + ";" + TextBoxSmtpServer.Text + ";" + numericUpDownSmtpPort.Value.ToString() + ";" + checkBoxSSL.Checked.ToString();
                //LogDebug("Provider [i=" + selected + "] updated to " + providers[selected].ToString(), (int)LogSetting.DEBUG);
	        }
	        else
	        {
		        LogDebug("Invalid provider string select index: " + selected + "\n Maximum count is " + providers.Length, (int)LogSetting.ERROR);
            }

        }


        public void setdefaultproviders(bool silent)
        {
            
            //providers[0] reserved for last settings
            providers[0] = "_Last Setting;;0;False;False;;0;False"; //custom stores always the last settings
            providers[1] = "1und1;pop.1und1.de;995;True;False;smtp.1und1.de;25;True"; //1und1
            providers[2] = "gmx(free);pop.gmx.net;110;False;False;mail.gmx.net;25;False"; //hotmail
            providers[3] = "google(free);pop.googlemail.com;995;True;False;smtp.googlemail.com;587;True"; //google
            providers[4] = "hotmail(free);pop3.live.com;995;True;False;smtp.live.com;25;True"; //hotmail           
            providers[5] = "web.de(free);pop3.web.de;995;True;False;smtp.web.de;25;True"; //web.de
	        ProviderLength=6; // is= array number+1
            
            listBoxProvider2.Items.Clear();
            for (int i = 0; i < ProviderLength; i++)
            {
                string[] array = providers[i].Split(";".ToCharArray());
                listBoxProvider2.Items.Add(array[0]);
            }


            //LogDebug("EmailScheduler Info: Provider settings set back to defaults", (int)LogSetting.DEBUG);
            
        }

        
        
        private void listBoxProvider2_SelectedIndexChanged(object sender, EventArgs e)
        {
            int j = listBoxProvider2.SelectedIndex;
            //LogDebug("listBoxProvider2_SelectedIndexChanged =" + providers[j]);
            translateprovider(providers[j]);
        }
        
       

        private void buttonhelp_Click(object sender, EventArgs e)
        { 
            Process proc = new Process();
            ProcessStartInfo procstartinfo = new ProcessStartInfo();
            procstartinfo.FileName = "EmailScheduler.pdf";
            procstartinfo.WorkingDirectory = TV_USER_FOLDER + @"\EmailScheduler";
            proc.StartInfo = procstartinfo;
            try
            {
                proc.Start();
            }
            catch
            {
                MessageBox.Show("Could not open " + procstartinfo.WorkingDirectory + "\\" + procstartinfo.FileName, "Error");
            }
        }


        public void LogDebug(string text, int field)
        {

            if (field == (int)LogSetting.INFO)
            {
                Log.Debug("EmailScheduler Setup: " + text);
                //textoutput(text, field);
            }
            else if (field == (int)LogSetting.ADDRESPONSE)
            {
                Log.Debug("EmailScheduler Setup: " + text);
                //textoutput(text, field);
            }
            else if ((field == (int)LogSetting.DEBUG) && (DEBUG == true))
            {
                if (DEBUG == true)
                {
                    Log.Debug("EmailScheduler Setup: " + text);
                    //textoutput(text, field);
                }
            }
            else if (field == (int)LogSetting.ERROR)
            {
                Log.Error("EmailScheduler Setup: " + text);
                Log.Debug("EmailScheduler Setup: " + text);
                //textoutput(text, field);
                
            }
            else if (field == (int)LogSetting.ERRORONLY)
            {
                Log.Error("EmailScheduler Setup: " + text);
                //textoutput(text, field);
            }
            else if (field == (int)LogSetting.MESSAGE)
            {
                Log.Debug("EmailScheduler Setup: " + text);
                //textoutput(text, field);
            }
            else
            {
                //textoutput("Error EmailSchedulerSetup: Unknown message Code "+field.ToString(),(int)LogSetting.ERROR);
            }

            

        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Process.Start("http://forum.team-mediaportal.com/tv-server-plugins-294/new-plugin-tv-server-email-scheduler-59528/");
            }
            catch (Exception exc)
            {
                LogDebug("Link failed with exception: " + exc.Message, (int)LogSetting.ERROR);
            }
            
        }

        

        private void textBoxSmtpEmailAdress_TextChanged(object sender, EventArgs e)
        {

        }

        private void checkBoxTvwishlist_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBoxTvwishlist.Checked == true)
            {
                string plugversion = detectplugin("TvWishList");
                if (plugversion == "NOT_FOUND")
                {
                    LogDebug("TvWishList plugin not installed\n Open the MediaPortal MPI installer and install the plugin first before enabling it in EmailScheduler", (int)LogSetting.INFO);
                    MessageBox.Show("TvWishList plugin not installed\n Open the MediaPortal MPI installer and install the plugin first before enabling it in EmailScheduler","Error");
                    checkBoxTvwishlist.Checked = false;
                }


            }
        }


        private string detectplugin(string pluginname)
        {
            PluginLoader mypluginloader = new PluginLoader();
            mypluginloader.Load();
            foreach (ITvServerPlugin plug in mypluginloader.Plugins)
            {
                if (plug.Name == pluginname)
                {
                    return plug.Version;
                }
            }
            return "NOT_FOUND";
        }



        

        

        
        

        
        

        


        /*
        private void textoutput(string textlines, int field)
        {

            int linewidth = 70;
            int lineheight = 15;

            string text = "";

            if (listBox1 != null)
            {
                char[] splitterchars = { '\n' };  //split lines with \n
                string[] lines = textlines.Split(splitterchars);
                foreach (string line in lines)
                {
                    text = line;
                    while (text.Length > linewidth)   //split long lines
                    {
                        int linelength = linewidth;
                        for (int i = linewidth-1; i >= 4; i--)
                        {
                            if (text[i] == ' ')
                            {
                                linelength = i;
                                break;
                            }
                        }
                        string pretext = text.Substring(0, linelength);

                        listBox1.Items.Add(pretext);

                        text = "+  " + text.Substring(linelength, text.Length - linelength);

                    }

                    listBox1.Items.Add(text);
                    if (listBox1.Items.Count > lineheight)
                        listBox1.TopIndex = listBox1.Items.Count - lineheight +1;

                    listBox1.Update();
                }
            }
        }

        private void clearbutton_Click(object sender, EventArgs e)
        {

            m_mc.newmessage -= new textlogmessage(textoutput);
            listBox1.Items.Clear();
            m_mc.newmessage += new textlogmessage(textoutput);


        }
        */
        

        

        

        
        

        

        
    }
}
