﻿/* 
 *	Copyright (C) 2005-2009 Team MediaPortal
 *	http://www.team-mediaportal.com
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */



using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Globalization;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using Microsoft.Win32;




namespace MediaPortal.Plugins
{
    //[CLSCompliant(false)]
    public delegate void textmessage(string text);
    public class InstallPaths
    {

        #region Properties


        //Main installation folders
        public string MP_PROGRAM_FOLDER = "NOT_DEFINED";
        public string MP_USER_FOLDER = "NOT_DEFINED";
        public string TV_PROGRAM_FOLDER = "NOT_DEFINED";
        public string TV_USER_FOLDER = "NOT_DEFINED";

        //All paths from MediaPortalDirs.xml
        public string DIR_Config = "NOT_DEFINED";
        public string DIR_Plugins = "NOT_DEFINED";
        public string DIR_Log = "NOT_DEFINED";
        public string DIR_CustomInputDevice = "NOT_DEFINED";
        public string DIR_CustomInputDefault = "NOT_DEFINED";
        public string DIR_Skin = "NOT_DEFINED";
        public string DIR_Language = "NOT_DEFINED";
        public string DIR_Database = "NOT_DEFINED";
        public string DIR_Thumbs = "NOT_DEFINED";
        public string DIR_Weather = "NOT_DEFINED";
        public string DIR_Cache = "NOT_DEFINED";
        public string DIR_BurnerSupport = "NOT_DEFINED";
        public string DIR_MediaPortalDirs = "NOT_DEFINED";
               
        // other properties
        public bool USERPROFILE_EXISTS = false;
        public bool DEBUG = false;
        public string STARTSWITH = "";
        public string LOG = "";


        public event textmessage newmessage; 
        #endregion Properties


        #region Methods


        public void GetInstallPaths()
        {
            // searches for MediaPortal and Tv server installation paths 
            // tries to autodetect the following folder
            //      string MP_PROGRAM_FOLDER  (MediaPortal Program Base)
            //      string MP_USER_FOLDER     (MediaPortal Configuration)    
            //      string TV_PROGRAM_FOLDER  (TV Server Program Base)
            //      string TV_USER_FOLDER      TV Server Configuration)
            // autodetection supports only English or German XP or Vista version 
            // if no valid folder is found the variable contains the value "NOT_DEFINED"
            //
            // autodetect uses the MediaPortal paths from MediaPortalDirs.xml
            // supports reading of MediaPortalDirs.xml from Userprofile Windows path and 
            // sets the variable USERPROFILE_EXISTS to true if such a file exists within the Userprofile
            // The following paths are set from the info of the MediaPortalDirs.xml file
            // If no file MediaPortalDirs.xml is found the paths are set to "NOT_DEFINED"
            //      string DIR_Config
            //      string DIR_Plugins
            //      string DIR_Log
            //      string DIR_CustomInputDevice
            //      string DIR_CustomInputDefault
            //      string DIR_Skin
            //      string DIR_Language
            //      string DIR_Database
            //      string DIR_Thumbs
            //      string DIR_Weather
            //      string DIR_BurnerSupport
            //      string DIR_MediaPortalDirs
            //
            // Other properties:
            //      string USERPROFILE_EXISTS
            //      string DEBUG
            //      string STARTSWITH
            //      string LOG
            // 
            //
            // 
            //




            //************************************
            //try autodetect MediaPortal.exe
            //************************************
            try
            {

                //start with current directory
                string thisdir=System.IO.Directory.GetCurrentDirectory();

                //try to find "Team MediaPortal" folder - get MP_PROGRAM_FOLDER
                string testpath="NOT_DEFINED";
                string testfile = "NOT_DEFINED";
                int pos = 0;
                if (thisdir.Contains(@"\Team MediaPortal\")==true)
                {
                    //try to find "MediaPortal\MediaPortal.exe" - get MP_PROGRAM_FOLDER
                    pos = thisdir.IndexOf(@"\Team MediaPortal\");
                    testpath = thisdir.Substring(0,pos)+@"\Team MediaPortal\MediaPortal";
                    testfile = thisdir.Substring(0, pos) + @"\Team MediaPortal\MediaPortal\MediaPortal.exe";
                }
                 
                if (File.Exists(testfile)==true)
                {
                    if (testpath.StartsWith(STARTSWITH) == true)
                    {
                        MP_PROGRAM_FOLDER = testpath;
                        if (DEBUG == true)
                        {
                                textoutput( "New thisdir path " + MP_PROGRAM_FOLDER + " found for MP_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }    
                //try to find "%PROGRAMFILES%" - get MP_PROGRAM_FOLDER
                else if (File.Exists(Environment.GetEnvironmentVariable("PROGRAMFILES") + @"\Team MediaPortal\MediaPortal\MediaPortal.exe") == true)
                {
                    string path = Environment.GetEnvironmentVariable("PROGRAMFILES") + @"\Team MediaPortal\MediaPortal";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        MP_PROGRAM_FOLDER = path;
                        if (DEBUG == true)
                        {
                            textoutput( "New %PROGRAMFILES% path " + MP_PROGRAM_FOLDER + " found for MP_PROGRAM_FOLDER" + "\n");
                        }                 
                    }                    
                }
                //try to find "%PROGRAMFILES% (x86)" - get MP_PROGRAM_FOLDER
                else if (File.Exists(Environment.GetEnvironmentVariable("PROGRAMFILES") + @" (x86)\Team MediaPortal\MediaPortal\MediaPortal.exe") == true)
                {
                    string path = Environment.GetEnvironmentVariable("PROGRAMFILES") + @" (x86)\Team MediaPortal\MediaPortal";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        MP_PROGRAM_FOLDER = path;
                        if (DEBUG == true)
                        {
                            textoutput("New %PROGRAMFILES%  (x86) path " + MP_PROGRAM_FOLDER + " found for MP_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }
                //try to find "C:\Program Files" - get MP_PROGRAM_FOLDER
                else if (File.Exists(@"C:\Program Files\Team MediaPortal\MediaPortal\MediaPortal.exe") == true)
                {
                    string path = @"C:\Program Files\Team MediaPortal\MediaPortal";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        MP_PROGRAM_FOLDER = path;
                        if (DEBUG == true)
                        {
                            textoutput( @"New C:\Program Files path " + MP_PROGRAM_FOLDER + " found for MP_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }
                //try to find "C:\Program Files (x86)" - get MP_PROGRAM_FOLDER
                else if (File.Exists(@"C:\Program Files (x86)\Team MediaPortal\MediaPortal\MediaPortal.exe") == true)
                {
                    string path = @"C:\Program Files (x86)\Team MediaPortal\MediaPortal";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        MP_PROGRAM_FOLDER = path;
                        if (DEBUG == true)
                        {
                            textoutput(@"New C:\Program Files (x86) path " + MP_PROGRAM_FOLDER + " found for MP_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }
                //try to find "C:\Programme" - get MP_PROGRAM_FOLDER
                else if (File.Exists(@"C:\Programme\Team MediaPortal\MediaPortal\MediaPortal.exe") == true)
                {
                    string path = @"C:\Programme\Team MediaPortal\MediaPortal";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            MP_PROGRAM_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( @"New C:\Programme path " + MP_PROGRAM_FOLDER + " found for MP_PROGRAM_FOLDER" + "\n");
                            }
                        }
                    }
                }
                else 
                {
                    //registry
                    try
                    {
                        RegistryKey regkey = Registry.LocalMachine;
                        RegistryKey subkey = regkey.OpenSubKey(@"Software\Team MediaPortal\MediaPortal");
                        string path = subkey.GetValue("ApplicationDir").ToString();
                        regkey.Close();
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            if (path.StartsWith(STARTSWITH) == true)
                            {
                                MP_PROGRAM_FOLDER = path;
                                if (DEBUG == true)
                                {
                                    textoutput( @"New registry path " + MP_PROGRAM_FOLDER + " found for MP_PROGRAM_FOLDER" + "\n");
                                }
                            }
                        }
                    }
                    catch (Exception ee)
                    {
                        textoutput( "Failed reading registry key ApplicationDir - Exception message is \n" + ee.Message + "\n");
                    }
                }


                if ((DEBUG == true) && (MP_PROGRAM_FOLDER == "NOT_DEFINED"))
                {
                    textoutput( "MP_PROGRAM_FOLDER was not found" + "\n");
                }

                
            }
            catch (Exception ee)
            {
                textoutput( "Failed to autodetect MP_PROGRAM_FOLDER - Exception message is \n" + ee.Message + "\n");
            }



            //************************************
            //try autodetect TvService.exe
            //************************************
            try
            {

                //start with current directory
                string thisdir = System.IO.Directory.GetCurrentDirectory();

                //try to find "Team MediaPortal" folder - get MP_PROGRAM_FOLDER
                string testpath = "NOT_DEFINED";
                string testfile = "NOT_DEFINED";
                string mediaportaltestpath = "NOT_DEFINED";
                string mediaportaltestfile = "NOT_DEFINED";

                int pos = 0;
                if (thisdir.Contains(@"\Team MediaPortal\") == true)
                {
                    //try to find "MediaPortal TV server\TvService.exe" - get TV_PROGRAM_FOLDER
                    pos = thisdir.IndexOf(@"\Team MediaPortal\");
                    testpath = thisdir.Substring(0, pos) + @"\Team MediaPortal\MediaPortal TV Server";
                    testfile = thisdir.Substring(0, pos) + @"\Team MediaPortal\MediaPortal TV Server\TvService.exe";
                }
                if (MP_PROGRAM_FOLDER != "NOT_DEFINED")
                {
                    mediaportaltestpath = MP_PROGRAM_FOLDER + @" TV Server";
                    mediaportaltestfile = MP_PROGRAM_FOLDER + @" TV Server\TvService.exe";
                }

                if (File.Exists(testfile) == true)
                {
                    if (testpath.StartsWith(STARTSWITH) == true)
                    {
                        TV_PROGRAM_FOLDER = testpath;
                        if (DEBUG == true)
                        {
                            textoutput( "New thisdir path " + TV_PROGRAM_FOLDER + " found for TV_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }
                else if (File.Exists(mediaportaltestfile)==true)
                {
                    if (testpath.StartsWith(STARTSWITH) == true)
                    {
                        TV_PROGRAM_FOLDER = mediaportaltestpath;
                        if (DEBUG == true)
                        {
                            textoutput( "New mediaportal tv path " + TV_PROGRAM_FOLDER + " found for TV_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }
                //try to find "%PROGRAMFILES%" - get TV_PROGRAM_FOLDER
                else if (File.Exists(Environment.GetEnvironmentVariable("PROGRAMFILES") + @"\Team MediaPortal\MediaPortal TV server\TvService.exe") == true)
                {
                    string path = Environment.GetEnvironmentVariable("PROGRAMFILES") + @"\Team MediaPortal\MediaPortal TV server";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        TV_PROGRAM_FOLDER = path;
                        if (DEBUG == true)
                        {
                            textoutput( "New %PROGRAMFILES% path " + TV_PROGRAM_FOLDER + " found for TV_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }
                //try to find "%PROGRAMFILES% (x86)" - get TV_PROGRAM_FOLDER
                else if (File.Exists(Environment.GetEnvironmentVariable("PROGRAMFILES") + @" (x86)\Team MediaPortal\MediaPortal TV server\TvService.exe") == true)
                {
                    string path = Environment.GetEnvironmentVariable("PROGRAMFILES") + @" (x86)\Team MediaPortal\MediaPortal TV server";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        TV_PROGRAM_FOLDER = path;
                        if (DEBUG == true)
                        {
                            textoutput("New %PROGRAMFILES% (x86) path " + TV_PROGRAM_FOLDER + " found for TV_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }
                //try to find "C:\Program Files" - get TV_PROGRAM_FOLDER
                else if (File.Exists(@"C:\Program Files\Team MediaPortal\MediaPortal TV server\TvService.exe") == true)
                {
                    string path = @"C:\Program Files\Team MediaPortal\MediaPortal TV server";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        TV_PROGRAM_FOLDER = path;
                        if (DEBUG == true)
                        {
                            textoutput( @"New C:\Program Files path " + TV_PROGRAM_FOLDER + " found for TV_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }
                //try to find "C:\Program Files (x86)" - get TV_PROGRAM_FOLDER
                else if (File.Exists(@"C:\Program Files (x86)\Team MediaPortal\MediaPortal TV server\TvService.exe") == true)
                {
                    string path = @"C:\Program Files (x86)\Team MediaPortal\MediaPortal TV server";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        TV_PROGRAM_FOLDER = path;
                        if (DEBUG == true)
                        {
                            textoutput(@"New C:\Program Files (x86) path " + TV_PROGRAM_FOLDER + " found for TV_PROGRAM_FOLDER" + "\n");
                        }
                    }
                }
                //try to find "C:\Programme" - get TV_PROGRAM_FOLDER
                else if (File.Exists(@"C:\Programme\Team MediaPortal\MediaPortal TV server\TvService.exe") == true)
                {
                    string path = @"C:\Programme\Team MediaPortal\MediaPortal TV server";
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_PROGRAM_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( @"New C:\Programme path " + TV_PROGRAM_FOLDER + " found for TV_PROGRAM_FOLDER" + "\n");
                            }
                        }
                    }
                }

                if ((DEBUG == true) && (TV_PROGRAM_FOLDER == "NOT_DEFINED"))
                {
                    textoutput( "TV_PROGRAM_FOLDER was not found" + "\n");
                }

            }
            catch (Exception ee)
            {
                textoutput( "Failed to autodetect TV_PROGRAM_FOLDER - Exception message is \n" + ee.Message + "\n");
            }



            //*********************************************
            //try autodetect MediaPortal Application data
            //*********************************************
            try
            {
                //get environment variables
                string ALLUSERSPROFILE = Environment.GetEnvironmentVariable("ALLUSERSPROFILE");
                string PROGRAMDATA = Environment.GetEnvironmentVariable("PROGRAMDATA");
                string APPDATA = Environment.GetEnvironmentVariable("APPDATA");
                string[] array = APPDATA.Split('\\');
                string XP_PROGRAMDATA = ALLUSERSPROFILE + "\\" + array[array.Length-1];

                //try to find "%ALLUSERSPROFILE%" for VISTA - get MP_USER_FOLDER
                if (Directory.Exists(ALLUSERSPROFILE + @"\Team MediaPortal\MediaPortal") == true)
                {
                    if (File.Exists(ALLUSERSPROFILE + @"\Team MediaPortal\MediaPortal\MediaPortal.exe") == false)
                    {
                        string path = ALLUSERSPROFILE + @"\Team MediaPortal\MediaPortal";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            MP_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( "New %ALLUSERSPROFILE% path " + MP_USER_FOLDER + " found for MP_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find "%ALLUSERSPROFILE%\Anwendungsdaten" for XP German - get MP_USER_FOLDER
                else if (Directory.Exists(ALLUSERSPROFILE + @"\Anwendungsdaten\Team MediaPortal\MediaPortal") == true)
                {
                    if (File.Exists(ALLUSERSPROFILE + @"\Anwendungsdaten\Team MediaPortal\MediaPortal\MediaPortal.exe") == false)
                    {
                        string path = ALLUSERSPROFILE + @"\Anwendungsdaten\Team MediaPortal\MediaPortal";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            MP_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( @"New %ALLUSERSPROFILE%\Anwendungsdaten path " + MP_USER_FOLDER + " found for MP_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find "%ALLUSERSPROFILE%\Application Data" for XP English - get MP_USER_FOLDER
                else if (Directory.Exists(ALLUSERSPROFILE + @"\Application Data\Team MediaPortal\MediaPortal") == true)
                {
                    if (File.Exists(ALLUSERSPROFILE + @"\Application Data\Team MediaPortal\MediaPortal\MediaPortal.exe") == false)
                    {
                        string path = ALLUSERSPROFILE + @"\Application Data\Team MediaPortal\MediaPortal";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            MP_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( @"New %ALLUSERSPROFILE%\Application Data path " + MP_USER_FOLDER + " found for MP_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find "%APPDATA%" for XP - get MP_USER_FOLDER
                else if (Directory.Exists(APPDATA + @"\Team MediaPortal\MediaPortal") == true)
                {
                    if (File.Exists(APPDATA + @"\Team MediaPortal\MediaPortal\MediaPortal.exe") == false)
                    {
                        string path = APPDATA + @"\Team MediaPortal\MediaPortal";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            MP_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput("New %APPDATA% path " + MP_USER_FOLDER + " found for MP_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find "%XP_PROGRAMDATA%" for XP - get MP_USER_FOLDER
                else if (Directory.Exists(XP_PROGRAMDATA + @"\Team MediaPortal\MediaPortal") == true)
                {
                    if (File.Exists(XP_PROGRAMDATA + @"\Team MediaPortal\MediaPortal\MediaPortal.exe") == false)
                    {
                        string path = XP_PROGRAMDATA + @"\Team MediaPortal\MediaPortal";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            MP_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput("New %XP_PROGRAMDATA% path " + MP_USER_FOLDER + " found for MP_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find "%PROGRAMDATA%" for VISTA - get MP_USER_FOLDER
                else if (Directory.Exists(PROGRAMDATA + @"\Team MediaPortal\MediaPortal") == true)
                {
                    if (File.Exists(PROGRAMDATA + @"\Team MediaPortal\MediaPortal\MediaPortal.exe") == false)
                    {
                        string path = PROGRAMDATA + @"\Team MediaPortal\MediaPortal";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            MP_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput("New %PROGRAMDATA% path " + MP_USER_FOLDER + " found for MP_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                else 
                {

                    //try registry
                    try
                    {
                        RegistryKey regkey = Registry.LocalMachine;
                        RegistryKey subkey = regkey.OpenSubKey(@"Software\Team MediaPortal\MediaPortal");
                        string path = subkey.GetValue("ConfigDir").ToString();
                        regkey.Close();
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            if (path.StartsWith(STARTSWITH) == true)
                            {
                                MP_USER_FOLDER = path;
                                if (DEBUG == true)
                                {
                                    textoutput( @"New registry path " + MP_USER_FOLDER + " found for MP_USER_FOLDER" + "\n");
                                }
                            }
                        }
                    }
                    catch (Exception ee)
                    {
                        textoutput( "Failed reading registry key ConfigDir - Exception message is \n" + ee.Message + "\n");
                    }
                }
                
                
                


                //get install paths from "MediaPortalDirs.xml" - got all absolute DIR_...
                GetMediaPortalDirs();

                //if MP_USER is not defined and a defined path exists from DIR_Config then use this path for MP_USER_FOLDER
                if ((DIR_Config != MP_USER_FOLDER) && (MP_USER_FOLDER != "NOT_DEFINED"))
                {
                    string path = DIR_Config;
                    if (path.StartsWith(STARTSWITH) == true)
                    {
                        MP_USER_FOLDER = path;
                        if (DEBUG == true)
                        {
                            textoutput( @"New DIR_Config Data path " + MP_USER_FOLDER + " found for MP_USER_FOLDER" + "\n");
                        }
                    }

                }
                


                if ((DEBUG == true) && (MP_USER_FOLDER == "NOT_DEFINED"))
                {
                        textoutput( "MP_USER_FOLDER was not found" + "\n");
                }
                
                

            }
            catch (Exception ee)
            {
                textoutput( "Failed to autodetect MP_USER_FOLDER - Exception message is \n" + ee.Message + "\n");
            }






            //*********************************************
            //try autodetect TV Server Application data
            //*********************************************

            try
            {

                //get environment variables
                string ALLUSERSPROFILE = Environment.GetEnvironmentVariable("ALLUSERSPROFILE");
                string PROGRAMDATA = Environment.GetEnvironmentVariable("PROGRAMDATA");
                string APPDATA = Environment.GetEnvironmentVariable("APPDATA");
                string[] array = APPDATA.Split('\\');
                string XP_PROGRAMDATA = ALLUSERSPROFILE + "\\" + array[array.Length-1];
                


                //try to find "%ALLUSERSPROFILE%" for VISTA - get TV_USER_FOLDER
                if (Directory.Exists(ALLUSERSPROFILE + @"\Team MediaPortal\MediaPortal TV server") == true)
                {
                    if (File.Exists(ALLUSERSPROFILE + @"\Team MediaPortal\MediaPortal TV server\TvService.exe") == false)// check for avoiding program directory
                    {
                        string path = ALLUSERSPROFILE + @"\Team MediaPortal\MediaPortal TV server";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( "New %ALLUSERSPROFILE% path " + TV_USER_FOLDER + " found for TV_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find "%ALLUSERSPROFILE%\Anwendungsdaten" for XP German - get TV_USER_FOLDER
                else if (Directory.Exists(ALLUSERSPROFILE + @"\Anwendungsdaten\Team MediaPortal\MediaPortal TV server") == true)
                {
                    if (File.Exists(ALLUSERSPROFILE + @"\Anwendungsdaten\Team MediaPortal\MediaPortal TV server\TvService.exe") == false)
                    {
                        string path = ALLUSERSPROFILE + @"\Anwendungsdaten\Team MediaPortal\MediaPortal TV server";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( @"New %ALLUSERSPROFILE%\Anwendungsdaten path " + TV_USER_FOLDER + " found for TV_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find "%ALLUSERSPROFILE%\Application Data" for XP English - get TV_USER_FOLDER
                else if (Directory.Exists(ALLUSERSPROFILE + @"\Application Data\Team MediaPortal\MediaPortal TV server") == true)
                {
                    if (File.Exists(ALLUSERSPROFILE + @"\Application Data\Team MediaPortal\MediaPortal TV server\TvService.exe") == false)
                    {
                        string path = ALLUSERSPROFILE + @"\Application Data\Team MediaPortal\MediaPortal TV server";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( @"New %ALLUSERSPROFILE%\Application Data path " + TV_USER_FOLDER + " found for TV_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find  "%APPDATA%" for XP - get TV_USER_FOLDER
                else if (Directory.Exists(APPDATA + @"\Team MediaPortal\MediaPortal TV server") == true)
                {
                    if (File.Exists(APPDATA + @"\Team MediaPortal\MediaPortal TV server\TvService.exe") == false)
                    {
                        string path = APPDATA + @"\Team MediaPortal\MediaPortal TV server";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput("New %APPDATA% path " + TV_USER_FOLDER + " found for TV_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find  "%XP_PROGRAMDATA%" for XP - get TV_USER_FOLDER
                else if (Directory.Exists(XP_PROGRAMDATA + @"\Team MediaPortal\MediaPortal TV server") == true)
                {
                    if (File.Exists(XP_PROGRAMDATA + @"\Team MediaPortal\MediaPortal TV server\TvService.exe") == false)
                    {
                        string path = XP_PROGRAMDATA + @"\Team MediaPortal\MediaPortal TV server";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput("New %XP_PROGRAMDATA% path " + TV_USER_FOLDER + " found for TV_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }
                //try to find  "%PROGRAMDATA%" for VISTA - get TV_USER_FOLDER
                else if (Directory.Exists(PROGRAMDATA + @"\Team MediaPortal\MediaPortal TV server") == true)
                {
                    if (File.Exists(PROGRAMDATA + @"\Team MediaPortal\MediaPortal TV server\TvService.exe") == false)
                    {
                        string path = PROGRAMDATA + @"\Team MediaPortal\MediaPortal TV server";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput("New %PROGRAMDATA% path " + TV_USER_FOLDER + " found for TV_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }

                //try to find folder by derivation of MediaPortal User folder
                else if (Directory.Exists(MP_USER_FOLDER + @" TV server") == true)
                {
                    if (File.Exists(MP_USER_FOLDER + @" TV server\TvService.exe") == false)
                    {
                        string path = MP_USER_FOLDER + @" TV server";
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( @"New derivative MP config Data path " + TV_USER_FOLDER + " found for TV_USER_FOLDER" + "\n");
                            }
                        }
                    }
                }


                if ((DEBUG == true) && (TV_USER_FOLDER == "NOT_DEFINED"))
                {
                    textoutput( "TV_USER_FOLDER was not found" + "\n");
                }
            }
            catch (Exception ee)
            {
                textoutput( "Failed to autodetect MP_USER_FOLDER - Exception message is \n" + ee.Message + "\n");
            }

        }        

        public string ask_MP_PROGRAM()
        {

            if (MP_PROGRAM_FOLDER == "NOT_DEFINED")
                GetInstallPaths();

            if (MP_PROGRAM_FOLDER == "NOT_DEFINED")
            {
                FolderBrowserDialog folderDialog = new FolderBrowserDialog();
                folderDialog.Description = "Select MediaPortal Program Folder (Contains MediaPortal.exe)";
                folderDialog.ShowNewFolderButton = false;
                if (folderDialog.ShowDialog() == DialogResult.OK)
                {
                    if (File.Exists(folderDialog.SelectedPath + @"\MediaPortal.exe") == true)
                    {
                        string path = folderDialog.SelectedPath;
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            MP_PROGRAM_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( "New user defined path \n" + MP_PROGRAM_FOLDER + " \n found for MP_PROGRAM_FOLDER" + "\n");
                            }
                        }
                        else if (DEBUG == true)
                        {
                            textoutput( "Selected folder\n" + path + "  \n does not start with" + STARTSWITH + "\n");
                        }
                    }
                    else if (DEBUG == true)
                    {
                        textoutput( "MediaPortal.exe does not exist in selected folder\n" +folderDialog.SelectedPath+ "\n");
                    }
                }
                else
                {
                    textoutput( "user selected invalid MP_PROGRAM_FOLDER or aborted" + "\n");
                }
                
            }
            return MP_PROGRAM_FOLDER;
        }

        public string ask_MP_USER()
        {
            if (MP_USER_FOLDER == "NOT_DEFINED")
                GetInstallPaths();

            if (MP_USER_FOLDER == "NOT_DEFINED")
            {
                FolderBrowserDialog folderDialog = new FolderBrowserDialog();
                folderDialog.Description = "Select MediaPortal Configuration Folder (Contains the log folder)";
                folderDialog.ShowNewFolderButton = false;
                if (folderDialog.ShowDialog() == DialogResult.OK)
                {
                    if (File.Exists(folderDialog.SelectedPath + @"\MediaPortal.exe") == false)
                    {
                        string path = folderDialog.SelectedPath;
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            MP_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( "New user defined path\n " + MP_USER_FOLDER + " \n found for MP_USER_FOLDER" + "\n");
                            }
                        }
                        else if (DEBUG == true)
                        {
                            textoutput( "Selected folder\n" + path + "  \n does not start with" + STARTSWITH + "\n");
                        }
                    }
                }
                else
                {
                    textoutput( "user selected invalid MP_USER_FOLDER or aborted" + "\n");
                }

            }
            return MP_USER_FOLDER;
        }

        public string ask_TV_PROGRAM()
        {
            if (TV_PROGRAM_FOLDER == "NOT_DEFINED")
                GetInstallPaths();
            
            if (TV_PROGRAM_FOLDER == "NOT_DEFINED")
            {
                FolderBrowserDialog folderDialog = new FolderBrowserDialog();
                folderDialog.Description = "Select TvService Program Folder (Contains TvService.exe)";
                folderDialog.ShowNewFolderButton = false;
                if (folderDialog.ShowDialog() == DialogResult.OK)
                {
                    if (File.Exists(folderDialog.SelectedPath + @"\TvService.exe") == true)
                    {
                        string path = folderDialog.SelectedPath;
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_PROGRAM_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( "New user defined path \n" + TV_PROGRAM_FOLDER + "\n found for TV_PROGRAM_FOLDER" + "\n");
                            }
                        }
                        else if (DEBUG == true)
                        {
                            textoutput( "Selected folder\n" + path + " \n does not start with" + STARTSWITH + "\n");
                        }
                    }
                    else if (DEBUG == true)
                    {
                        textoutput( "TvService.exe does not exist in selected folder\n" + folderDialog.SelectedPath + "\n");
                    }
                }
                else
                {
                    textoutput( "user selected invalid TV_PROGRAM_FOLDER or aborted" + "\n");
                }

            }
            return TV_PROGRAM_FOLDER;
        }

        public string ask_TV_USER()
        {
            if (TV_USER_FOLDER == "NOT_DEFINED")
                GetInstallPaths();

            if (TV_USER_FOLDER == "NOT_DEFINED")
            {
                FolderBrowserDialog folderDialog = new FolderBrowserDialog();
                folderDialog.Description = "Select TvService Program Folder (Contains the log folder and Config.xml)";
                folderDialog.ShowNewFolderButton = false;
                if (folderDialog.ShowDialog() == DialogResult.OK)
                {
                    if (File.Exists(folderDialog.SelectedPath + @"\TvService.exe") == false)
                    {
                        string path = folderDialog.SelectedPath;
                        if (path.StartsWith(STARTSWITH) == true)
                        {
                            TV_USER_FOLDER = path;
                            if (DEBUG == true)
                            {
                                textoutput( "New user defined path \n" + TV_USER_FOLDER + "\n found for TV_USER_FOLDER" + "\n");
                            }
                        }
                        else if (DEBUG == true)
                        {
                            textoutput( "Selected folder \n"+path+" \n does not start with" + STARTSWITH + "\n");
                        }
                    }
                }
                else
                {
                    textoutput( "user selected invalid TV_USER_FOLDER or aborted" + "\n");
                }

            }
            return TV_USER_FOLDER;
        }

        public void GetMediaPortalDirs()
        {
            
            //get default values for MediaPortalDirs.xml
            DIR_Config = MP_USER_FOLDER;
            DIR_Plugins = MP_PROGRAM_FOLDER+@"\plugins";
            DIR_Log = MP_USER_FOLDER+@"\log";
            DIR_CustomInputDevice = MP_USER_FOLDER+@"\InputDeviceMappings";
            DIR_CustomInputDefault = MP_PROGRAM_FOLDER+@"\InputDeviceMappings\defaults";
            DIR_Skin = MP_PROGRAM_FOLDER + @"\skin";
            DIR_Language = MP_PROGRAM_FOLDER + @"\language";
            DIR_Database = MP_USER_FOLDER + @"\database";
            DIR_Thumbs = MP_USER_FOLDER + @"\thumbs";
            DIR_Weather = MP_PROGRAM_FOLDER + @"\weather";
            DIR_Cache = MP_USER_FOLDER + @"\cache";
            DIR_BurnerSupport = MP_PROGRAM_FOLDER + @"\Burner";
            DIR_MediaPortalDirs = MP_PROGRAM_FOLDER + @"\MediaPortalDirs.xml";


            // read MediaPortalDirs.xml in User document directory
            if (File.Exists(Environment.GetEnvironmentVariable("APPDATA") + @"\Team MediaPortal\MediaPortalDirs.xml") == true)
            {
                DIR_MediaPortalDirs = Environment.GetEnvironmentVariable("APPDATA") + @"\Team MediaPortal\MediaPortalDirs.xml";
                USERPROFILE_EXISTS = true;
            }
            else if (File.Exists(Environment.GetEnvironmentVariable("USERPROFILE") + @"\Team MediaPortal\MediaPortalDirs.xml") == true)
            {
                DIR_MediaPortalDirs = Environment.GetEnvironmentVariable("USERPROFILE") + @"\Team MediaPortal\MediaPortalDirs.xml";
                USERPROFILE_EXISTS = true;
            }
            // read MediaPortalDirs.xml in MediaPortal program document directory


            if (File.Exists(DIR_MediaPortalDirs) == true)
            {
                try
                {
                    StreamReader sfile = File.OpenText(MP_PROGRAM_FOLDER + @"\MediaPortalDirs.xml");
                    String textline = null;

                    while ((textline = sfile.ReadLine()) != null)
                    {
                        InstallPathParser(ref DIR_Config,"  <Dir id = \"Config\">",sfile,textline);

                        InstallPathParser(ref DIR_Plugins,"  <Dir id = \"Plugins\">",sfile,textline);
                        if (DIR_Plugins.ToLower() == MP_PROGRAM_FOLDER.ToLower() + @"\plugins")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_Plugins=MP_PROGRAM_FOLDER+ @"\plugins";
                        }

                        InstallPathParser(ref DIR_Log,"  <Dir id = \"Log\">",sfile,textline);
                        if (DIR_Log.ToLower() == MP_USER_FOLDER.ToLower() + @"\log")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_Log = MP_USER_FOLDER + @"\log";
                        }

                        InstallPathParser(ref DIR_CustomInputDevice,"  <Dir id = \"CustomInputDevice\">",sfile,textline);
                        if (DIR_CustomInputDevice.ToLower() == MP_USER_FOLDER.ToLower() + @"\inputdevicemappings")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_CustomInputDevice = MP_USER_FOLDER + @"\InputDeviceMappings";
                        }

                        InstallPathParser(ref DIR_CustomInputDefault,"  <Dir id = \"CustomInputDefault\">",sfile,textline);
                        if (DIR_CustomInputDefault.ToLower() == MP_PROGRAM_FOLDER.ToLower() + @"\inputdevicemappings\defaults")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_CustomInputDefault = MP_PROGRAM_FOLDER + @"\InputDeviceMappings\defaults";
                        }
                        
                        InstallPathParser(ref DIR_Skin,"  <Dir id = \"Skin\">",sfile,textline);
                        if (DIR_Skin.ToLower() == MP_PROGRAM_FOLDER.ToLower() + @"\skin")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_Skin = MP_PROGRAM_FOLDER + @"\skin";
                        }

                        InstallPathParser(ref DIR_Language,"  <Dir id = \"Language\">",sfile,textline);
                        if (DIR_Language.ToLower() == MP_PROGRAM_FOLDER.ToLower() + @"\language")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_Language = MP_PROGRAM_FOLDER + @"\language";
                        }

                        InstallPathParser(ref DIR_Database,"  <Dir id = \"Database\">",sfile,textline);
                        if (DIR_Database.ToLower() == MP_USER_FOLDER.ToLower() + @"\database")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_Database = MP_USER_FOLDER + @"\database";
                        }

                        InstallPathParser(ref DIR_Thumbs,"  <Dir id = \"Thumbs\">",sfile,textline);
                        if (DIR_Thumbs.ToLower() == MP_USER_FOLDER.ToLower() + @"\thumbs")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_Thumbs = MP_USER_FOLDER + @"\thumbs";
                        }

                        InstallPathParser(ref DIR_Weather,"  <Dir id = \"Weather\">",sfile,textline);
                        if (DIR_Weather.ToLower() == MP_PROGRAM_FOLDER.ToLower() + @"\weather")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_Weather = MP_PROGRAM_FOLDER + @"\weather";
                        }

                        InstallPathParser(ref DIR_Cache,"  <Dir id = \"Cache\">",sfile,textline);
                        if (DIR_Cache.ToLower() == MP_USER_FOLDER.ToLower() + @"\cache")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_Cache = MP_USER_FOLDER + @"\cache";
                        }

                        InstallPathParser(ref DIR_BurnerSupport,"  <Dir id = \"BurnerSupport\">",sfile,textline);
                        if (DIR_BurnerSupport.ToLower() == MP_PROGRAM_FOLDER.ToLower() + @"\burner")  //special treatment of case sensitivity for standard installation
                        {
                            DIR_BurnerSupport = MP_PROGRAM_FOLDER + @"\Burner";
                        }
                        
                    }
                    sfile.Close();
                }
                catch (Exception ee)
                {
                    textoutput("Error in parsing file  " + MP_PROGRAM_FOLDER + @"\MediaPortalDirs.xml");
                    if (DEBUG == true)
                        textoutput("Exception message is " + ee.Message);
                }

            }
            else
            {
                Console.WriteLine("BackupSettings: Error: " + MP_PROGRAM_FOLDER + @"\MediaPortalDirs.xml does not exist");
            }
        }

        private void InstallPathParser(ref string folder, string searchstring, StreamReader sfile, string textline)
        {
            if (textline == searchstring)
            {
                textline = sfile.ReadLine();
                folder = textline.Substring(10, textline.Length - 11 - 7);
                //substitute environment variables
                string[] array= folder.Split('\\');
                string newfolder = "";
                for (int i = 0; i < array.Length; i++)
                {
                    if (array[i].Length > 2)
                    {
                        if (array[i].ToUpper() == "%PROGRAMDATA%")
                        {
                            array[i] = MP_USER_FOLDER.Replace(@"\Team MediaPortal\MediaPortal", "");
                        }



                        /*  system variabes are not supported
                        //textoutput("1 "+array[i]);
                        if ((array[i].StartsWith("%") == true) && (array[i].EndsWith("%") == true))  //check for system variable
                        {
                            //textoutput("2 " + array[i]);
                            string variable = array[i].Substring(1, array[i].Length - 2);  //change %variable% to variable
                            string token = Environment.GetEnvironmentVariable(variable);   // get variable value
                            if (variable.ToUpper() == "PROGRAMDATA")
                            {
                                
                                
                                //textoutput("3 " + array[i]);
                            }
                            else if (token != null)
                            {
                                array[i] = token;
                                //textoutput("4 " + array[i]);
                            }
                            
                        }
                         */
                        
                    }
                    newfolder += array[i] + "\\";
                    //textoutput(newfolder);
                }

                //complete path in case of relative names
                if (newfolder.Length<3)
                { 
                    //relative path - avoid exception later on
                    newfolder=MP_PROGRAM_FOLDER+@"\"+newfolder;
                }
                else if ((newfolder[0] == '\\') && (newfolder[1] == '\\'))
                {
                    // path starts with server name use absolute filename
                }
                else if ((newfolder[1] == ':') && (newfolder[2] == '\\'))
                {
                    // path starts with drive letter use absolute file name
                }
                else
                {
                    //relative path
                    newfolder=MP_PROGRAM_FOLDER+@"\"+newfolder;
                }
                folder = newfolder;

                //remove subsequent \
                if (folder.EndsWith("\\")==true)
                    folder=folder.Substring(0,folder.Length-1);

                if (DEBUG == true)
                {
                    string token = searchstring.Substring(13, searchstring.Length - 13 - 2);
                    textoutput(token + "=" + folder);
                }
            }
        }

        public void textoutput(string text)
        {
            
            LOG+=("InstallPaths:"+ text+"\n");
            if (newmessage != null)
            {
                newmessage("InstallPaths:" + text + "\n");
            }
        }


        #endregion Methods
      
    }   
}


