#region Copyright (C) 2005-2008 Team MediaPortal

/* 
 *	Copyright (C) 2005-2008 Team MediaPortal
 *	http://www.team-mediaportal.com
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

#endregion

// reusing email pop3 class with modifications from Media Portal Plugin MyMail from _Agree_ downloaded at
// http://mp-plugins.svn.sourceforge.net/viewvc/mp-plugins/trunk/plugins/MyMail/


using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Globalization;
using System.Net.Sockets;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using System.ComponentModel;
using System.Net.Security;
using System.Security.Cryptography.X509Certificates;
using System.Security.Cryptography;
using System.Net.Mail;
using System.Windows.Forms;
using System.Xml;
using similaritymetrics;

using TvLibrary.Log;
using TvControl;
using SetupTv;
using TvEngine;
using TvEngine.Events;
using TvLibrary.Interfaces;
using TvLibrary.Implementations;
using TvDatabase;
using MediaPortal.Plugins;
using TvEngine.PowerScheduler.Interfaces;

namespace MyTVMail
{
  /// <summary>
  /// this a mail-client in a class
  /// to read a mailbox 
  /// </summary>
    public delegate void textlogmessage(string text, int number);
    public delegate void setuplabelmessage(string text);

    public class MailClass
    {
        //Global variables
        string FileRenameXML="FileRenameXML.xml"; //global file containing all file renaming jobs

        const int m_buffSize = 2048; // buffer for rec. data
        const string _CRLF_ = "\r\n";
        const System.Net.Sockets.SocketFlags noFlags = System.Net.Sockets.SocketFlags.None;

        bool DEBUG = true;
	    bool BUSY = false;
        string MESSAGE = "";            //server protocol
        string LASTACTION = "";         //lastaction sent to email server
        string RESPONSE = "";           //replying email
        int MAX_EMAIL_PROCESSING = 100;  // maximum numbers of emails to be processed
        int MAX_EPG_OUTPUT = 1000;   // maximum number of EPG programs to be reported
        int MAX_SCRIPT_WAIT_MINUTES = 5; //maximum number of minutes to wait for completion of a user script file from a run command

        
        bool UseScheduleName = false; //if true the schedule name will be used as a folder name for the recording

        
        
        
        int my_mailaction = (int)MailAction.MAIL_SEND_STAT;
        int my_mailnumber = 0;
        int serversuccess = 0;
        bool ssl_error = false;
        DateTime comparetimestamp = new DateTime();
        
        bool OLD_MAIL_REACHED = false;
        bool DELETE_EMAIL = true;
        int OLD_SERVER_MESSAGE_ERROR = 0;
        int DEFAULT_POSTRECORD = 0;
        int DEFAULT_PRERECORD = 0;
        public string emailtransactionbusyfile = "NOTFOUND";   //file is also used in setup!!!

        IList s_text = new ArrayList();
        IList s_subject = new ArrayList();
        IList s_receiver = new ArrayList();

        IList EmailHeaders = new ArrayList();
        IList EmailBodies = new ArrayList();

#if(MP100)
        IList matchingprograms = new List<Program>();//ilist with all programs found in EPG data matching schedule information from email
#elif(MP101)
        IList<Program> matchingprograms = new List<Program>();//ilist with all programs found in EPG data matching schedule information from email
#elif(MP11  || MP12)
        IList<Program> matchingprograms = new List<Program>();//ilist with all programs found in EPG data matching schedule information from email
#endif
        
        string LastProcessedEmail = "";     // latest retrieved email on server, which is not deleted
        int LastProcessedEmailNumber = 0;   // message number on server of latest retrieved email
        string BackupLastProcessedEmail = "";     // DEL backup of latest retrieved email on server, which is not deleted 
        int BackupLastProcessedEmailNumber = 0;   // DEL backuop of message number on server of latest retrieved email
        string OldProcessedEmail = "";      // last retrieved email on server not deleted

        //public event textlogmessage newmessage;
        public event setuplabelmessage newlabelmessage;

        bool _checkBoxAcceptEmail = false;
        bool _checkBoxUseSchedulerPassword = false;
        bool _checkBoxUseTAN = false;
        bool _checkBoxUseRecordingHourLimit = false;
        bool _checkBoxAllowDelete = false;
        bool _checkBoxAllowRecord = false;
        bool _checkBoxReplyToEmails = false;
        bool _checkBoxAllowHelpChannel = true;
        bool _checkBoxAllowRunScripts = false;
        bool _checkBoxAllowHelpSchedule = false;
        bool _checkBoxAllowHelpEPG = false;
        bool _checkBoxAllowTvWishList = false;
        bool _checkBoxAllowSeriesSchedules = false;
        bool _checkBoxdeletefromserver = false;

        double _LabelRecordingHours = 0;
        string _TextBoxEmailSubject = "";
        string _TextBoxUserName = "";
        string _TextBoxPassword = "";
        string _TextBoxSmtpEmailAddress = "";
        
        string _TextBoxSchedulerPassword = "";
        string _TextBoxEditEmailSender = "";
        string _TextBoxEditTan = "";
        double _numericUpDownCheckEmail = 0;
        int _numericUpDownMaxRecordingHours = 0;
        
        char TV_WISH_COLUMN_SEPARATOR = ';';

        string _lastprovider = ";;;;;;;";

        string _TextBoxPop3Server = "";
        int _numericUpDownPop3Port = 0;
        bool _checkBoxImpliciteSSL = false;
        bool _checkBoxExpliciteSSL = false;
        string _TextBoxSmtpServer = "";
        int _numericUpDownSmtpPort = 0;
        bool _checkBoxSSL = false;
        string _ListBoxEmailSender = "";
        string _ListBoxTAN = "";
        

        string TV_USER_FOLDER = "NOTFOUND";
        
	

        MailBox m_mb;
        IPEndPoint m_endPoint;
        Socket m_mailSocket;//
        NetworkStream m_mailSocketStream;
        SslStream m_mailTLSStream;

        static string m_emptyBuffer = new string((char)0, 2048);// 2kbyte socket buffer
        //System.Net.Sockets.TcpClient m_mailReciever=new TcpClient(); 

        int m_imailCount;
        int m_currAction = -1; //
        int m_mailAction;
        int m_mailNumber;
        int m_ierrorNumber;
        string m_mailFolder;
        string m_attachmentFolder;
        string m_errorMessage;
        int m_mailNumberSize;
        string m_recMailData;
        //System.Windows.Forms.Timer m_timeOutTimer = new System.Windows.Forms.Timer();
        ArrayList m_knownMails = new ArrayList();
        System.Security.Cryptography.MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
        byte[] m_mailBuffer = new Byte[m_buffSize];
        Byte m_TLSSecured = MailBox.NO_SSL; //NO_SSL: user/password combination won't be encrypted, STLS: use explicit SSL, SSL_PORT: use implicit SSL; The authentication method is chosen during mailbox configuration
        Boolean m_TLS_OK = false; //Are we actually protected under a SSL layer?
        public const Boolean UntrustedRootOK = true; //Accept that the server to securely connect to has produced its own certificate
        public const Boolean CertNameMistmatchOK = false; //Accept that the server name (domain name) to securely connect to may mismatch the one provided in the certificate
        public const Boolean CertRevokedOK = true; //Allow expired certificates to be used by the server

        
        public struct MailAttachment
        {
            public string attPath;
            public string attFileName;
            public int attKind; // 1 - image, 2 - audio, 3 - application rel.
        }
        // 
        enum SocketError
        {
            ERROR_NO_ERROR = 0,
            ERROR_TIMEOUT,
            ERROR_NO_DATA,
            ERROR_CONNECTION_ERR,
            ERROR_WRONG_DATA,
            ERROR_SERVER_NOT_READY,
            ERROR_PORT,
            ERROR_SSL,
            ERROR_POP3_IP,
            ERROR_EXCEPTION,
            ERROR_TOO_MANY_MAILS,
            ERROR_UNKNOWN_MSG_FROM_SERVER = 999
        }

        enum MailAction
        {
            MAIL_MB_CONNECTED = 1,
            MAIL_SEND_CAPABILITIES,
            MAIL_SEND_STARTTLS,
            MAIL_ACTION_WAIT_SERVER_CERTIFICATE,
            MAIL_SEND_USER,
            MAIL_SEND_PASS,
            MAIL_SEND_STAT,
            MAIL_SEND_RETR,
            MAIL_SEND_QUIT,
            MAIL_SEND_LIST,
            MAIL_SEND_DELE,
            MAIL_SEND_RETR_LIST,
            MAIL_SEND_PERFORM,
            MAIL_ACTION_INVALID,
            MAIL_ACTION_READ_ON,
            MAIL_ACTION_READ_LIST

        }

        enum InformNumber
        {
            INFORM_CONNECTED = 8030,
            INFORM_GETTING_MAIL,
            INFORM_LOGOUT,
            INFORM_GETTING_MAIL_PROGRESS
        }

        enum LogSetting
        {
            DEBUG=1,
            ERROR,
            ERRORONLY,
            INFO,
            MESSAGE,
            ADDRESPONSE
        }

        enum Scheduleoperation
        {
            NONE=0,
            ADD,
            PARTIAL,
            ALLPARTIAL,
            DELETE,
            HELP,
            RUN,
            TVWISH_ADD,
            TVWISH_EDIT,
            TVWISH_DELETE,
            TVWISH_LIST,
        }

        public bool Debug
        {
            get { return DEBUG; }
            set { DEBUG = value; }
        }
        
        public string Message
        {
            get { return MESSAGE; }
        }
        public string LastAction
        {
            get { return LASTACTION; }
        }
        public int MailError
        {
            get { return m_ierrorNumber; }
        }
        public int ServerSuccess
        {
            get { return serversuccess; }
        }
        

        // our events
        // an event to set diverse data 
        // public delegate void InformEventHandler(int informNumber, object informObject);
        //public static event InformEventHandler InformUser;
        //
        // timout handler
        //public delegate void GotMailDataEventHandler(object mailObject, string mailData, int mailAction);
        //public event GotMailDataEventHandler GotMailData;
        //
        // get mail known state
        //
        public MailClass()
        {
            
        }
        ~MailClass()
        {
            //m_timeOutTimer.Tick-=new EventHandler(TimeOut);
            //m_portTimeOutTimer.Tick -= new EventHandler(PortTimeOut);
        }


        // This routine controls the asynchronuous receive mail box communication and handles the 
        public void ReadMailBoxController()
        {

            

            LogDebug("ReadMailBoxController started", (int)LogSetting.DEBUG);

            //activate timers
            //m_timeOutTimer.Tick += new EventHandler(TimeOut);

            if (newlabelmessage != null)
                newlabelmessage("Wait For Server");

            OLD_MAIL_REACHED = false;

            // load actual server settings
            try
            {
                bool OK = LoadSettings();//must be before read_marked_emails
                if (OK == false)
                    return;
            }
            catch (Exception ex)
            {
                LogDebug("Fatal Error: Failed to load settings - exception message is\n" + ex.Message, (int)LogSetting.ERROR);
                LogDebug("Processing aborted\n", (int)LogSetting.ERROR);
                return;
            }


            //basic checking before mailbox creation
            if (_TextBoxPop3Server == "")
            {
                LogDebug("Server address not specified - aborting email check", (int)LogSetting.ERROR);
                m_ierrorNumber = (int)SocketError.ERROR_POP3_IP;
                return;
            }

            emailtransactionbusyfile = TV_USER_FOLDER + @"\EmailScheduler\EmailTransactionBusy.txt";             
            LogDebug("emailtransactionbusyfile=" + emailtransactionbusyfile, (int)LogSetting.DEBUG);


            MailBox tmpBox = null; // our actual mail box
            byte security = 0;
            if (_checkBoxImpliciteSSL == true)
                security = 1;
            if (_checkBoxExpliciteSSL == true)
                security = 2;



            tmpBox = new MailBox("mailbox", _TextBoxUserName, _TextBoxPassword, _TextBoxPop3Server, Convert.ToInt32(_numericUpDownPop3Port), security, TV_USER_FOLDER + @"\EmailScheduler", TV_USER_FOLDER + @"\EmailScheduler");
            tmpBox.Debug = DEBUG;
            //System.IO.FileInfo[] theMails = null;

            //check for server existence
            if (tmpBox != null)
            {
                try
                {
                    IPHostEntry hostIP = Dns.GetHostEntry(tmpBox.ServerAddress);
                    IPAddress[] addr = hostIP.AddressList;
                    LogDebug("POP3 Server exists", (int)LogSetting.DEBUG);
                }
                catch
                {
                    LogDebug("Pop3 Server does not exist - check the POP3 server name and your internet connection", (int)LogSetting.DEBUG);
                    m_ierrorNumber = (int)SocketError.ERROR_POP3_IP;
                    //MessageBox.Show("Pop3 Server does not exist - check the POP3 server name", "Error");
                    ReadMailBoxControllerExitHandling(false);
                    return;
                }

            }
            else //tmpbox=null
            {
                LogDebug("Mailbox could not be created", (int)LogSetting.ERROR);
                ReadMailBoxControllerExitHandling(false);
                return;
            }

            try
            {
                //Email server busy - wait
                int busycounter = 0;
                while (File.Exists(emailtransactionbusyfile) == true)  //error!!!change with exit condition
                {
                    System.Threading.Thread.Sleep(5000);
                    LogDebug("Email Server busy before MAIL_SEND_STAT", (int)LogSetting.DEBUG);
                    busycounter++;
                    if (busycounter > 120)// 10 minutes exceeded - busy state takes too long - abort receiving email
                    {
                        LogDebug("Error: Busy state before MAIL_SEND_STAT exceeded time limit", (int)LogSetting.ERROR);
                        //ReadMailBoxControllerExitHandling(false); changed in 1.0.4.1 because processing has not started yet
                        return;
                    }
                }
                LogDebug("Email Server available", (int)LogSetting.DEBUG);

                //write busy file
                try
                {
                    byte[] buffer = Encoding.ASCII.GetBytes(DateTime.Now.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture));
                    System.IO.FileStream fs = new System.IO.FileStream(emailtransactionbusyfile, System.IO.FileMode.Create);
                    fs.Write(buffer, 0, buffer.Length);
                    fs.WriteByte(13);
                    fs.WriteByte(10);
                    fs.Close();
                }
                catch (Exception ee)
                {
                    LogDebug("Error in writing file  " + emailtransactionbusyfile, (int)LogSetting.ERROR);
                    LogDebug("Exception message is " + ee.Message, (int)LogSetting.ERROR);
                    //ReadMailBoxControllerExitHandling(false);changed in 1.0.4.1 because processing has not started yet
                    return;
                }


                //read old processed emails and initialize last processed email after busy file is written
                LogDebug("Reading last processed email", (int)LogSetting.DEBUG);
                read_marked_emails();


                //initialize message parser
                EmailBodies.Clear();
                EmailHeaders.Clear();

                //initialize sendmails
                s_receiver.Clear();
                s_subject.Clear();
                s_text.Clear();

                //initialize last processed email
                LastProcessedEmail = "";
                LastProcessedEmailNumber = 0;
                BackupLastProcessedEmail = "";
                BackupLastProcessedEmailNumber = 0;


                //send statistic first
                BUSY = true;
                if (newlabelmessage != null)
                    newlabelmessage("Get Message Summary");
                my_mailaction = (int)MailAction.MAIL_SEND_STAT;
                LogDebug("*****************************", (int)LogSetting.DEBUG);
                LogDebug("Connecting to email server", (int)LogSetting.INFO);
                LogDebug("*****************************", (int)LogSetting.DEBUG);
                //int MailCount = GetEMailList(tmpBox.MailboxFolder, ref theMails);

                

                ReadMailBox(ref tmpBox);

            }
            catch (Exception ex)
            {
                LogDebug("Receive Mail failed \nException message is " + ex.Message, (int)LogSetting.ERROR);
                ReadMailBoxControllerExitHandling(false);
                return;

            }

            //wait for completion of receiving messages

            LogDebug("Waiting for completion of EmailServer", (int)LogSetting.DEBUG);


            //wait for mailserver to complete or timeout

            while (BUSY == true)
            {
                System.Threading.Thread.Sleep(500);//wait 0.5s
            }



            //evaluate testing from SEND_STAT
            if (m_ierrorNumber != 0)
            {
                LogDebug("Email Server Error=" + m_ierrorNumber, (int)LogSetting.ERROR);
                LogDebug("Email Server LastAction=" + LASTACTION, (int)LogSetting.ERROR);
                OLD_SERVER_MESSAGE_ERROR = 999; //set old server error to maximum value

                ReadMailBoxControllerExitHandling(true);
                return;
                //MessageBox.Show("Email Server Error=" + m_mc.MailError + "\n LastAction=" + m_mc.LastAction);
            }

            int totalmailnumber = m_imailCount;
            if (newlabelmessage != null)
                newlabelmessage(totalmailnumber + " Mails On Server");

            LogDebug("Result of Testing POP3 Server:", (int)LogSetting.DEBUG);
            LogDebug("\n\n" + MESSAGE, (int)LogSetting.DEBUG);


            // retrieve emails from box
            int mailretrievectr = 0;
            for (int i = totalmailnumber; i >= 1; i--)
            {
                MESSAGE = "";  // initialize MESSAGE

                if ((OLD_MAIL_REACHED == false) || (i <= OLD_SERVER_MESSAGE_ERROR))
                {
                    if (i == OLD_SERVER_MESSAGE_ERROR)
                        OLD_SERVER_MESSAGE_ERROR--; //try again to retrieve message and reduce error counter





                    //Retrieve Email number i
                    BUSY = true;

                    if (newlabelmessage != null)
                        newlabelmessage("Retrieve " + i + " of " + totalmailnumber);

                    LogDebug("*******************************", (int)LogSetting.DEBUG);
                    LogDebug("Retrieve message number " + i.ToString(), (int)LogSetting.INFO);
                    LogDebug("*******************************", (int)LogSetting.DEBUG);

                    /*
                    my_mailaction = (int)MailAction.MAIL_SEND_RETR; //MAIL_SEND_RETR
                    my_mailnumber = i;
                    ReadMailBox(ref tmpBox);
                    */

                    //send direct message to server without login
                    m_mailNumber = i;
                    m_mailAction = (int)MailAction.MAIL_SEND_RETR;
                    InteractServer((int)MailAction.MAIL_SEND_PERFORM);



                    //wait for mailserver to complete or timeout

                    while (BUSY == true)
                    {
                        System.Threading.Thread.Sleep(500); //wait 0.5s
                    }



                    //evaluate error from MESSAGE
                    if (m_ierrorNumber != 0)
                    {
                        LogDebug("Email Server Error=" + m_ierrorNumber, (int)LogSetting.ERROR);
                        LogDebug("Email Server LastAction=" + LASTACTION, (int)LogSetting.ERROR);
                        OLD_SERVER_MESSAGE_ERROR = i; //mark server error for last received email - try again next time
                        //ReadMailBoxControllerExitHandling(true);
                        //return; //abort email transfer
                        break; //quit server and parse emails
                    }



                    LogDebug("_checkBoxdeletefromserver=" + _checkBoxdeletefromserver.ToString(), (int)LogSetting.DEBUG);
                    LogDebug("DELETE_EMAIL=" + DELETE_EMAIL.ToString(), (int)LogSetting.DEBUG);
                    // Delete mail from server if processing was correct
                    if ((_checkBoxdeletefromserver == true) && (DELETE_EMAIL == true))
                    {
                        BUSY = true;
                        LogDebug("**********************************************", (int)LogSetting.DEBUG);
                        LogDebug("Deleting message number " + i.ToString() + " from Server", (int)LogSetting.INFO);
                        LogDebug("**********************************************", (int)LogSetting.DEBUG);
                        m_mailNumber = i;
                        m_mailAction = (int)MailAction.MAIL_SEND_DELE;
                        InteractServer((int)MailAction.MAIL_SEND_PERFORM);
                        //wait for mailserver to complete or timeout

                        while (BUSY == true)
                        {
                            System.Threading.Thread.Sleep(500); //wait 0.5s
                        }

                        //evaluate error from MESSAGE
                        if (m_ierrorNumber != 0)
                        {
                            LogDebug("Email Server Error=" + m_ierrorNumber, (int)LogSetting.ERROR);
                            LogDebug("Email Server LastAction=" + LASTACTION, (int)LogSetting.ERROR);
                            OLD_SERVER_MESSAGE_ERROR = i; //mark server error for last received email - try again next time
                            //ReadMailBoxControllerExitHandling(true);
                            //return; //abort email transfer
                            break; //quit server and parse emails
                        }
                        if (i == LastProcessedEmailNumber)
                        {
                            LastProcessedEmailNumber = 0;
                            LastProcessedEmail = "";
                        }

                    }

                    LogDebug("Result of Testing POP3 Server:", (int)LogSetting.DEBUG);
                    LogDebug("\n\n" + MESSAGE, (int)LogSetting.DEBUG);


                    mailretrievectr++;
                    if (mailretrievectr > MAX_EMAIL_PROCESSING)  //threshold for too many mails on the server - will process only the latest ones
                    {
                        LogDebug("**********************************************************************", (int)LogSetting.ERROR);
                        LogDebug("Error: Too many mails on server, will process only the latest " + mailretrievectr.ToString(), (int)LogSetting.ERROR);
                        LogDebug("**********************************************************************", (int)LogSetting.ERROR);
                        LASTACTION = "Too Many mails on server - Clean Up!";
                        OLD_SERVER_MESSAGE_ERROR = i; //mark server error for last received email - try again next time
                        break;
                    }


                }
                else
                {
                    LogDebug("Old mail on server detected - will not retrieve message " + i.ToString(), (int)LogSetting.INFO);
                }

            }

            //Quit from server
            try
            {
                LogDebug("Log off request sent to mail server", (int)LogSetting.DEBUG);
                m_mailAction = (int)MailAction.MAIL_SEND_QUIT;
                InteractServer(m_mailAction);
            }
            catch (Exception ex)
            {
                LogDebug("Log off request sent to mail server failed with message " + ex.Message, (int)LogSetting.ERROR);
            }








            LogDebug("Reading emails from server completed", (int)LogSetting.DEBUG);


            //process and parse emails
            if (newlabelmessage != null)
                newlabelmessage("Parsing Emails");

            LogDebug("Processing Emails", (int)LogSetting.DEBUG);
            if (EmailBodies.Count > 0)
            {
                for (int i = EmailBodies.Count - 1; i >= 0; i--)  //reverse order for processing to restore original time schedule of sent emails
                {

                    string header = EmailHeaders[i] as String;

                    string body = EmailBodies[i] as String;
                    messageparser(header, body);
                }
            }
            LogDebug("Processing Emails completed", (int)LogSetting.DEBUG);






            //Send all reply mails
            if (_checkBoxReplyToEmails == true)
            {
                LogDebug("Sending reply emails", (int)LogSetting.DEBUG);
                // build the email message
                SendTvServerEmail sendobject = new SendTvServerEmail(_TextBoxSmtpServer, Convert.ToInt32(_numericUpDownSmtpPort), _checkBoxSSL, _TextBoxUserName, _TextBoxPassword, _TextBoxSmtpEmailAddress);
                sendobject.Debug = DEBUG;

                for (int i = 0; i < s_receiver.Count; i++)
                {

                    s_subject[i] = "Re: " + s_subject[i];
                    LogDebug("Send reply mail to " + s_receiver[i].ToString() + " at " + DateTime.Now.ToString(), (int)LogSetting.DEBUG);
                    LogDebug("Subject:" + s_subject[i].ToString(), (int)LogSetting.DEBUG);
                    LogDebug(s_text[i].ToString(), (int)LogSetting.DEBUG);
                    LogDebug("End of mail", (int)LogSetting.DEBUG);

                    bool ok = sendobject.SendNewEmail(s_receiver[i].ToString(), s_subject[i].ToString(), s_text[i].ToString());

                }

                LogDebug("Sending return emails completed", (int)LogSetting.DEBUG);
            }


            //exit busy handling and send quit to server
            ReadMailBoxControllerExitHandling(false);

            

        }

        public void ReadMailBoxControllerExitHandling(bool quit_server)
        {
            //deactivate timers
            //m_timeOutTimer.Tick -= new EventHandler(TimeOut);

            //logout from server
            if (quit_server == true)
            {
                try
                {
                    LogDebug("Log off request sent to mail server", (int)LogSetting.DEBUG);
                    m_mailAction = (int)MailAction.MAIL_SEND_QUIT;
                    InteractServer(m_mailAction);
                }
                catch (Exception ex)
                {
                    LogDebug("Log off request sent to mail server failed with message " + ex.Message, (int)LogSetting.ERROR);
                }
            }
            //write processed emails
            LogDebug("Writing last processed email", (int)LogSetting.DEBUG);
            write_marked_emails();

            
            if (newlabelmessage != null)
                newlabelmessage("Completed");


            if (File.Exists(emailtransactionbusyfile) == true)
            {
                LogDebug("EmailTransactionBusyFile deleted", (int)LogSetting.DEBUG);
                File.Delete(emailtransactionbusyfile);
            }


            LogDebug("ReadMailBoxControllerExitHandling completed", (int)LogSetting.DEBUG);

            
        }

//________________________________________________code from _Agree_  with modifications
        // getting all mails from an mailbox
        public void ReadMailBox(ref MailBox mailbox)
        {
            LogDebug("ReadMailBox started", (int)LogSetting.DEBUG);
            //set BUSY flag
            BUSY = true;

            
            MESSAGE = "";
            serversuccess = 0; //initialization of "OK" counter
            ssl_error=true; //suspect ssl error
            LASTACTION = "CONNECT TO SERVER";

       


            IPAddress[] addr = new IPAddress[0];
            if (ServerExists(mailbox, ref addr) == true)
            {
                System.Net.IPEndPoint ePoint = new IPEndPoint(addr[0], mailbox.Port);
                //mailbox.ClearMailList();
                m_mb = mailbox;
                m_mailNumber = 0;
                m_endPoint = ePoint;
                m_TLSSecured = mailbox.TLS;
                m_mailSocket = new Socket(System.Net.Sockets.AddressFamily.InterNetwork, System.Net.Sockets.SocketType.Stream, System.Net.Sockets.ProtocolType.IP);
                m_ierrorNumber = (int)SocketError.ERROR_NO_ERROR;
                m_errorMessage = "";
                m_mailFolder = mailbox.MailboxFolder;
                m_attachmentFolder = mailbox.AttachmentFolder;

                
                
                /*
                m_timeOutTimer.Interval = 15000;    // set timeout to 15 seconds
                m_timeOutTimer.Enabled = true;
                m_timeOutTimer.Start();
                LogDebug("ReadMailBox:m_timeOutTimer.Start()", (int)LogSetting.DEBUG);
                */

                /*
                comparetimestamp = DateTime.Now;
                LogDebug("Timestamp created at "+comparetimestamp.ToString(),(int)LogSetting.DEBUG);
                System.Threading.Thread th = new System.Threading.Thread(StartPortTimeOutTimer);
                th.Start();*/

                TimeoutTimer("START");
                

                AsyncCallback callback = new AsyncCallback(ConnectCallback);
                // Begin Asyncronous Connection
                m_mailSocket.BeginConnect(ePoint, callback, m_mailSocket);
                
                

                
                m_mailNumber = my_mailnumber;
                LogDebug("m_mailNumber=" + m_mailNumber, (int)LogSetting.DEBUG);

                m_mailAction = my_mailaction;
                LogDebug("m_mailAction=" + m_mailAction, (int)LogSetting.DEBUG);
             
                
                m_mailBuffer.Initialize();
            }
            else
            {
                m_ierrorNumber = (int)SocketError.ERROR_SERVER_NOT_READY;
                m_mb.MailCount = 0;
                LogDebug("Could not connect to Ip address of server "+ m_mb.ServerAddress.ToString(),(int) LogSetting.ERROR);
                LASTACTION = "ERROR_SERVER_NOT_READY MAIL_SEND_QUIT";
                InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server
            }
            LogDebug("ReadMailBox completed", (int)LogSetting.DEBUG);
        
        }

        public void TimeoutTimer(string mode)
        // original timeout timer did not work  (m_timeOutTimer) for me
        {
            if (mode == "START")
            {
                comparetimestamp = DateTime.Now;
                System.Threading.Thread th = new System.Threading.Thread(StartTimeOutTimer);
                th.Start();
            }
            else if (mode == "STOP")
            {
                comparetimestamp = DateTime.Now; //timestamps do not match anymore and timer is deactivated
                //LogDebug("TimeOutTimer stopped at " + comparetimestamp.ToString("hh:mm:ss.ffff", CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);
            }
            else
            {
                LogDebug("Programerror: mode=" + mode, (int)LogSetting.ERROR);
            }
        }

        public void StartTimeOutTimer()
        {
            //LogDebug("StartTimeOutTimer: - waiting 15s ", (int)LogSetting.DEBUG);
            DateTime mytimestamp = comparetimestamp;
            //LogDebug("Comparing timestamp is " + mytimestamp.ToString("hh:mm:ss.ffff", CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);

            System.Threading.Thread.Sleep(15000); //wait 15s
            if (mytimestamp == comparetimestamp)
            {
                try
                {
                    m_mailSocket.Close();
                    LogDebug("m_mailsocket has been closed", (int)LogSetting.ERROR);
                }
                catch
                {// do nothing

                }
                if (ssl_error == false) //TIMEOUT
                {
                    LogDebug("TIMEOUT ERROR", (int)LogSetting.ERROR);
                    LogDebug("LASTACTION=" + LASTACTION, (int)LogSetting.ERROR);

                    m_ierrorNumber = (int)SocketError.ERROR_TIMEOUT; // error timeout
                }
                else  //PORT TIMEOUT
                {
                    LogDebug("PORT TIMEOUT ERROR: SSL setting error detected ", (int)LogSetting.ERROR);
                    m_ierrorNumber = (int)SocketError.ERROR_SSL; // SSL_ERROR
                }
                

                //GotMailData(m_errorMessage, "Ready", m_ierrorNumber); // ready event triggered

                

                LogDebug("MailClass: MESSAGE=" + MESSAGE.ToString(), (int)LogSetting.DEBUG);
                LogDebug("Resetting BUSY flag", (int)LogSetting.DEBUG);
                BUSY = false; //reset busy flag
            }
            else //ssl_error=false
            {
                //LogDebug("No timeout error detected for timestamp " + mytimestamp.ToString("hh:mm:ss.ffff", CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);
            }
            

        }






        private void ConnectCallback(IAsyncResult ar)
        {
            LogDebug("ConnectCallback started", (int)LogSetting.DEBUG);
            m_ierrorNumber = (int)SocketError.ERROR_PORT;
            try
            {
                Socket sock1 = (Socket)ar.AsyncState;
                if (sock1.Connected)
                {
                    //InformUser((int)InformNumber.INFORM_CONNECTED, "");
                    LogDebug("Connected to Server", (int)LogSetting.DEBUG);
                    m_ierrorNumber = (int)SocketError.ERROR_NO_ERROR; //reset porterror

                    //TimeoutTimer("STOP"); because of port ssl errortimer
                    /*
                    m_timeOutTimer.Stop();
                    LogDebug("ConnectCallback: m_timeOutTimer.Stop()", (int)LogSetting.DEBUG);*/
                    m_mailSocketStream = new NetworkStream(m_mailSocket, false);
                    if (m_TLSSecured == MailBox.SSL_PORT)
                    {
                        LogDebug("Secured SSL Port", (int)LogSetting.DEBUG);
                        LASTACTION = "SECURED SSL PORT WAIT FOR DATA";
                        AsyncCallback recieveData = new AsyncCallback(OnRecievedData);

                        try
                        {
                            m_mailTLSStream = new SslStream(m_mailSocketStream, false, this.RemoteCertificateValidationCallback);
                            m_mailTLSStream.AuthenticateAsClient(m_mb.ServerAddress, null, System.Security.Authentication.SslProtocols.Ssl2 | System.Security.Authentication.SslProtocols.Ssl3 | System.Security.Authentication.SslProtocols.Tls, !CertRevokedOK);

                            m_TLS_OK = true;

                            m_currAction = (int)MailAction.MAIL_MB_CONNECTED;
                            m_mailTLSStream.BeginRead(m_mailBuffer, 0, m_buffSize, recieveData, m_mailTLSStream);

                            LogDebug("Connected to server " + m_mb.ServerAddress.ToString() + " using SSL", (int)LogSetting.INFO);

                        }
                        catch (Exception ee)
                        {
                            LogDebug("SSL connection attempt to dedicated port failed", (int)LogSetting.ERROR);
                            LogDebug("Exception message is " + ee.Message, (int)LogSetting.ERRORONLY);
                            m_ierrorNumber = (int)SocketError.ERROR_PORT;
                            /*
                            Log.Info("mymail: SSL connection attempt to dedicated port failed: {0}", ee.Message);

                            m_mailTLSStream = null;
                            m_TLS_OK = false;

                            m_ierrorNumber = (int)SocketError.ERROR_CONNECTION_ERR;
                            m_currAction = (int)MailAction.MAIL_SEND_QUIT;
                            m_mailSocketStream.BeginRead(m_mailBuffer, 0, m_buffSize, recieveData, m_mailSocketStream);
                            */
                        }


                    }
                    else
                    {
                        AsyncCallback recieveData = new AsyncCallback(OnRecievedData);
                        LASTACTION = "MAIL_MB_CONNECTED";
                        m_TLS_OK = false;

                        m_currAction = (int)MailAction.MAIL_MB_CONNECTED;
                        m_mailSocketStream.BeginRead(m_mailBuffer, 0, m_buffSize, recieveData, m_mailSocketStream);

                        LogDebug("Connected to server " + m_mb.ServerAddress.ToString() + " without SSL", (int)LogSetting.INFO);

                    }


                }

            }
            catch (Exception ee)
            {
                LogDebug("Error in ConnectCallback ", (int)LogSetting.ERROR);
                LogDebug("Exception message is " + ee.Message, (int)LogSetting.ERRORONLY);
                m_ierrorNumber = (int)SocketError.ERROR_PORT;


            }
            if (m_ierrorNumber != (int)SocketError.ERROR_NO_ERROR)
            {
                LogDebug("Port Error occured - aborting receive", (int)LogSetting.ERROR);
                comparetimestamp = DateTime.Now;
                BUSY = false; //resetting busy flag
            }
            LogDebug("ConnectCallback completed", (int)LogSetting.DEBUG);
        }

        private void OnRecievedData(IAsyncResult ar)
        {
            LogDebug("Data received from server LASTACTION= " + LASTACTION, (int)LogSetting.DEBUG);

            ssl_error = false;
            LogDebug("OnRecievedData: ssl_error = false", (int)LogSetting.DEBUG);

            if (m_currAction == (int)MailAction.MAIL_ACTION_WAIT_SERVER_CERTIFICATE)
            {
                if (m_TLSSecured == MailBox.STLS && m_TLS_OK)
                {
                    LogDebug("Re-connection attempt to server " + m_mb.ServerAddress.ToString() + " using SSL", (int)LogSetting.INFO);
                    LASTACTION = "RECONNECTION MAIL_SEND_USER";
                    InteractServer((int)MailAction.MAIL_SEND_USER);
                }
                else
                {
                    LogDebug("SSL re-connection attempt using STARTTLS command failed: Explicit TLS issued w/out any effective SSL layer protection", (int)LogSetting.INFO);
                    m_ierrorNumber = (int)SocketError.ERROR_CONNECTION_ERR;
                    LASTACTION = "ERROR_CONNECTION_ERR MAIL_SEND_QUIT";
                    InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server
                    quitreceivemail();
                }
                return;
            }
            int bytesCount;
            if (m_TLSSecured != MailBox.NO_SSL && m_TLS_OK)
            {
                bytesCount = ((SslStream)ar.AsyncState).EndRead(ar);
            }
            else
            {
                bytesCount = ((NetworkStream)ar.AsyncState).EndRead(ar);
            }
            System.String strData = System.Text.Encoding.Default.GetString(m_mailBuffer, 0, bytesCount);//changed from Encoding.ASCII to Default for ,,...
            //TimeoutTimer("STOP");
            /*
            m_timeOutTimer.Stop();
            LogDebug("OnRecievedData: m_timeOutTimer.Stop()", (int)LogSetting.DEBUG);
             */

            // read email message
            try
            {
                if (bytesCount == 0 && m_currAction == (int)MailAction.MAIL_ACTION_READ_ON)
                {
                    LogDebug("There is an recieve error. No data was send from server", (int)LogSetting.ERROR);
                    m_errorMessage = "Error. No Mail-End indicator found";
                    m_ierrorNumber = (int)SocketError.ERROR_WRONG_DATA;
                    LASTACTION = "ERROR_WRONG_DATA MAIL_SEND_QUIT";
                    InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server
                    quitreceivemail();
                }
                // getting mailbox list
                // getting mail number x
                if (bytesCount > 0 && m_currAction == (int)MailAction.MAIL_ACTION_READ_ON)
                {
                    m_recMailData += strData;
                    //LogDebug("Mail Number "+strData, (int)LogSetting.DEBUG);

                    //log last 3 characters
                    //LogDebug("Character3 " + strData[strData.Length - 1].ToString() + "ascii: " + Convert.ToInt32(strData[strData.Length - 1]).ToString(), (int)LogSetting.DEBUG);
                    //LogDebug("Character2 " + strData[strData.Length - 2].ToString() + "ascii: " + Convert.ToInt32(strData[strData.Length - 2]).ToString(), (int)LogSetting.DEBUG);
                    //LogDebug("Character1 " + strData[strData.Length - 3].ToString() + "ascii: " + Convert.ToInt32(strData[strData.Length - 3]).ToString(), (int)LogSetting.DEBUG);


                    //InformUser((int)InformNumber.INFORM_GETTING_MAIL, Convert.ToString((m_imailCount + 1) - m_mailNumber) + "/" + Convert.ToString(m_imailCount) + percentDoneText);

                    if (m_recMailData.EndsWith(_CRLF_ + "." + _CRLF_) == false)
                    {
                        LASTACTION = "WAIT FOR MORE DATA";
                        AsyncCallback recieveData = new AsyncCallback(OnRecievedData);  //expect more data from server
                        m_mailBuffer = System.Text.Encoding.Default.GetBytes(m_emptyBuffer);//changed from Encoding.ASCII to Default for ,,...

                        TimeoutTimer("START");
                        /*
                        m_timeOutTimer.Start();
                        LogDebug("OnRecievedData: m_timeOutTimer.Start()", (int)LogSetting.DEBUG);
                        */

                        if (recieveData != null)
                        {
                            if (m_TLSSecured != MailBox.NO_SSL && m_TLS_OK)
                            {
                                ((SslStream)ar.AsyncState).BeginRead(m_mailBuffer, 0, m_buffSize, recieveData, (SslStream)ar.AsyncState);
                            }
                            else
                            {
                                ((NetworkStream)ar.AsyncState).BeginRead(m_mailBuffer, 0, m_buffSize, recieveData, (NetworkStream)ar.AsyncState);
                            }

                        }
                    }
                    else
                    {
                        LogDebug("Recieved message number " + Convert.ToString(m_mailNumber), (int)LogSetting.DEBUG);
                        try
                        {
                            //SaveEMail(m_recMailData, m_mailNumber);
                            //LogDebug("Mail " + m_mailNumber + "\n" + m_recMailData, (int)LogSetting.DEBUG);
                            emailparser(m_recMailData, m_mailNumber); //   email will directly be parsed to mail processing

                        }
                        catch
                        {
                            LogDebug("There was an error parsing the mail nr. " + Convert.ToString(m_mailNumber), (int)LogSetting.ERROR);
                        }
                        m_recMailData = "";
                        m_mailNumber--;
                        if (m_mailNumber <= 0)
                        {
                            m_mailBuffer = System.Text.Encoding.Default.GetBytes(m_emptyBuffer);//changed from Encoding.ASCII to Default for ,,...
                            LogDebug("All messages transfered. count: " + Convert.ToString(m_imailCount), (int)LogSetting.DEBUG);
                            m_ierrorNumber = (int)SocketError.ERROR_NO_ERROR;
                            LASTACTION = "NO_MORE_MAILS";
                            //InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server   changequit
                            quitreceivemail();
                        }
                        else
                        {
                            //InformUser((int)InformNumber.INFORM_GETTING_MAIL, Convert.ToString((m_imailCount + 1) - m_mailNumber) + "/" + Convert.ToString(m_imailCount));
                            LogDebug("Getting message number " + Convert.ToString(m_mailNumber), (int)LogSetting.DEBUG);
                            //m_mailAction = (int)MailAction.MAIL_SEND_LIST;  
                            //LASTACTION = "MAIL_SEND_LIST";
                            //InteractServer((int)MailAction.MAIL_SEND_LIST);

                            LASTACTION = "MAIL_RETRIEVED";
                            quitreceivemail();

                        }
                        return;
                    }
                }


                //read server response on specific command action
                if (bytesCount > 0 && m_currAction != (int)MailAction.MAIL_ACTION_READ_ON)
                {
                    string strRecieved = strData;

                    if (strRecieved.StartsWith("-ERR"))
                    {
                        LogDebug("Getting error message " + strRecieved, (int)LogSetting.ERROR);

                        m_errorMessage = strRecieved.Substring(4, strRecieved.Length - 4);
                        m_ierrorNumber = (int)SocketError.ERROR_UNKNOWN_MSG_FROM_SERVER;
                        LASTACTION = "ERROR_UNKNOWN_MSG_FROM_SERVER - MAIL_SEND_QUIT";
                        InteractServer((int)MailAction.MAIL_SEND_QUIT);
                    }
                    if (strRecieved.Substring(0, 3).Equals("+OK"))
                    {
                        string message = strRecieved.Substring(0, strRecieved.Length - 1);
                        LogDebug("Status OK -  message is " + message, (int)LogSetting.MESSAGE);
                        serversuccess++; //increase server success counter for error evaluation

                        /* not working
                        //do not send MAIL_SEND_LIST
                        if (LASTACTION == "MAIL_SEND_LIST")
                        {
                            quitreceivemail();
                            return;
                        }*/

                        switch (m_currAction)
                        {
                            case (int)MailAction.MAIL_SEND_LIST:
                                LASTACTION = "MAIL_SEND_LIST:";
                                string size = strRecieved;
                                size = size.Replace(_CRLF_, "");
                                string[] strSeg = size.Split(new char[] { ' ' });
                                int count = int.Parse(strSeg[strSeg.Length - 1]);

                                if (count > 0 && IsMailInList(size) == false)
                                {
                                    AppendMailToList(size);
                                    m_mailNumberSize = count;
                                    m_mailAction = (int)MailAction.MAIL_SEND_RETR;
                                    LASTACTION = "MAIL_SEND_RETR MAIL_SEND_PERFORM";
                                    InteractServer((int)MailAction.MAIL_SEND_PERFORM); // get the next mail
                                }
                                else
                                {
                                    //LogDebug("Message number " + Convert.ToString(m_mailNumber) + " has already been downloaded or is malformed", (int)LogSetting.DEBUG);



                                    m_mailNumber--;
                                    if (m_mailNumber <= 0)
                                    {
                                        m_ierrorNumber = (int)SocketError.ERROR_NO_ERROR;
                                        LASTACTION = "NO_MORE_MAILS";
                                        //InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server   changequit
                                        quitreceivemail();
                                    }
                                    else
                                    {
                                        LASTACTION = "MAIL_SEND_LIST";
                                        InteractServer((int)MailAction.MAIL_SEND_LIST);
                                    }
                                }
                                break;
                            case (int)MailAction.MAIL_MB_CONNECTED: // send the user and begin login or first issue a STLS command
                                LASTACTION = "MAIL_MB_CONNECTED:";
                                if (m_TLSSecured == MailBox.STLS && !m_TLS_OK)
                                {
                                    LASTACTION = "MAIL_MB_CONNECTED:MAIL_SEND_CAPABILITIES";
                                    InteractServer((int)MailAction.MAIL_SEND_CAPABILITIES);
                                }
                                else
                                {
                                    LASTACTION = "MAIL_MB_CONNECTED:MAIL_SEND_USER";
                                    InteractServer((int)MailAction.MAIL_SEND_USER);
                                }
                                break;
                            case (int)MailAction.MAIL_SEND_CAPABILITIES: // check server capabilities
                                LASTACTION = "MAIL_SEND_CAPABILITIES:";
                                Boolean is_STLS_Authorized = false;
                                //A t'on  faire  un serveur qui peut utiliser une couche SSL/TLS?
                                Regex regexEndOfLine = new Regex(_CRLF_);
                                string[] caps = regexEndOfLine.Split(strRecieved);
                                for (int i = 0; i < caps.Length; i++)
                                    if (caps[i].Substring(0, 4).Equals("STLS"))
                                    {
                                        is_STLS_Authorized = true;
                                        LASTACTION = "MAIL_SEND_CAPABILITIES:MAIL_SEND_STARTTLS";
                                        InteractServer((int)MailAction.MAIL_SEND_STARTTLS);
                                        break;
                                    }
                                //Non? alors on arrte l...
                                if (!is_STLS_Authorized)
                                {
                                    LogDebug("Server does not advertise STLS. No secure connection will be issued.", (int)LogSetting.INFO);
                                    m_ierrorNumber = (int)SocketError.ERROR_CONNECTION_ERR;
                                    LASTACTION = "MAIL_SEND_CAPABILITIES:ERROR: MAIL_SEND_QUIT";
                                    InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server
                                }
                                break;
                            case (int)MailAction.MAIL_SEND_STARTTLS: // SSL/TLS via standard POP3 port
                                LASTACTION = "MAIL_SEND_STARTTLS";
                                //LogDebug("MAIL_SEND_STARTTLS:", (int)LogSetting.MESSAGE);
                                AsyncCallback recieveData_TLS = new AsyncCallback(OnRecievedData);
                                try
                                {
                                    m_mailTLSStream = new SslStream((NetworkStream)ar.AsyncState, false, this.RemoteCertificateValidationCallback);
                                    m_TLS_OK = true;
                                    LASTACTION = "MAIL_ACTION_WAIT_SERVER_CERTIFICATE";
                                    m_currAction = (int)MailAction.MAIL_ACTION_WAIT_SERVER_CERTIFICATE;
                                    m_mailTLSStream.BeginAuthenticateAsClient(m_mb.ServerAddress, null, System.Security.Authentication.SslProtocols.Ssl2 | System.Security.Authentication.SslProtocols.Ssl3 | System.Security.Authentication.SslProtocols.Tls, !CertRevokedOK, recieveData_TLS, m_mailTLSStream);
                                }
                                catch (Exception ee)
                                {
                                    m_mailSocket.Blocking = false;
                                    LogDebug("SSL connection attempt using STARTTLS command failed", (int)LogSetting.ERROR);
                                    LogDebug(" Exception message is: " + ee.Message, (int)LogSetting.ERRORONLY);

                                    m_mailTLSStream = null;
                                    m_TLS_OK = false;

                                    m_ierrorNumber = (int)SocketError.ERROR_CONNECTION_ERR;
                                    LASTACTION = "ERROR_CONNECTION_ERR - MAIL_SEND_QUIT";
                                    m_currAction = (int)MailAction.MAIL_SEND_QUIT;
                                    m_mailSocketStream.BeginRead(m_mailBuffer, 0, m_buffSize, recieveData_TLS, m_mailSocketStream);
                                }
                                break;
                            case (int)MailAction.MAIL_SEND_USER: // send password
                                LASTACTION = "MAIL_SEND_USER";
                                InteractServer((int)MailAction.MAIL_SEND_PASS);

                                break;
                            case (int)MailAction.MAIL_SEND_PASS: // if the pass is sended we perform our action
                                LASTACTION = "MAIL_SEND_PASS";
                                InteractServer((int)MailAction.MAIL_SEND_PERFORM);
                                break;

                            case (int)MailAction.MAIL_SEND_PERFORM: // we quit now
                                if (m_mailAction == (int)MailAction.MAIL_SEND_STAT) // return the mail count from the inbox
                                {
                                    LASTACTION = "MAIL_SEND_STAT";
                                    // get the mails count 
                                    strRecieved = strRecieved.Replace(_CRLF_, "");
                                    try
                                    {
                                        m_imailCount = int.Parse(Regex.Replace(strRecieved, @"^.*\+OK[ |	]+([0-9]+)[ |	]+.*$", "$1"));
                                    }
                                    catch
                                    {
                                        m_imailCount = 0;
                                    }
                                    //	
                                    m_mb.MailCount = m_imailCount;
                                    m_mb.MailCount = m_imailCount;
                                    LogDebug("There are " + Convert.ToString(m_imailCount) + " messages in the mailbox", (int)LogSetting.INFO);
                                    if (m_imailCount > 0)
                                    {
                                        LASTACTION = "MAIL_SEND_LIST";
                                        //m_lastMailToRecieve=m_mb.LastCheckCount;
                                        m_mailNumber = m_imailCount;
                                        //m_mb.LastCheckCount=m_imailCount;
                                        //InformUser((int)InformNumber.INFORM_GETTING_MAIL, Convert.ToString((m_imailCount + 1) - m_mailNumber) + "/" + Convert.ToString(m_imailCount));
                                        InteractServer((int)MailAction.MAIL_SEND_LIST);



                                        // starting out with getting a list
                                        // m_mailAction=(int)MailAction.MAIL_SEND_RETR_LIST;
                                        // InteractServer((int)MailAction.MAIL_SEND_PERFORM);
                                    }
                                    else
                                    {
                                        //m_ierrorNumber = 2;// no mails on server
                                        // do not set errormessage if there are no messages on the server
                                        m_ierrorNumber = (int)SocketError.ERROR_NO_ERROR;
                                        OLD_SERVER_MESSAGE_ERROR = 0;


                                        LogDebug("There are no messages in the mailbox", (int)LogSetting.INFO);
                                        LASTACTION = "NO MESSAGES";
                                        //m_mb.MailCount = CountMail(m_mb);
                                        //InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server change
                                        quitreceivemail();
                                    }
                                }
                                if (m_mailAction == (int)MailAction.MAIL_SEND_RETR) // return the mail content (if its size is greater than the actual buffer size, will pursue using MAIL_ACTION_READ_ON command on next buffer filling pass)
                                {
                                    LASTACTION = "MAIL_SEND_RETR";
                                    //m_recMailData = "";
                                    m_recMailData = strRecieved;
                                    //QUICK FIX: mail bodies whose size is lower than buffer length don't pass MAIL_ACTION_READ_ON related procedure through MAIL_SEND_RETR related procedure. 
                                    if (strRecieved.EndsWith(_CRLF_ + "." + _CRLF_))
                                    {
                                        LogDebug("Recieved message number " + Convert.ToString(m_mailNumber), (int)LogSetting.DEBUG);
                                        try
                                        {
                                            //SaveEMail(m_recMailData, m_mailNumber);
                                            LogDebug("Mail " + m_mailNumber + "\n" + m_recMailData, (int)LogSetting.DEBUG);
                                            emailparser(m_recMailData, m_mailNumber); //   email will directly be parsed to mail processing
                                        }
                                        catch
                                        {
                                            LogDebug("There was an error saving the mail nr. " + Convert.ToString(m_mailNumber), (int)LogSetting.ERROR);
                                        }
                                        m_recMailData = "";
                                        m_mailNumber--;
                                        if (m_mailNumber <= 0)
                                        {
                                            m_mailBuffer = System.Text.Encoding.Default.GetBytes(m_emptyBuffer);//changed from Encoding.ASCII to Default for ,,...
                                            LogDebug("All messages transfered. count: " + Convert.ToString(m_imailCount), (int)LogSetting.INFO);
                                            m_ierrorNumber = (int)SocketError.ERROR_NO_ERROR;
                                            LASTACTION = "MAIL_SEND_LIST_COMPLETED";
                                            //InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server  or continue with next message changequit
                                            quitreceivemail();
                                        }
                                        else
                                        {
                                            //InformUser((int)InformNumber.INFORM_GETTING_MAIL, Convert.ToString((m_imailCount + 1) - m_mailNumber) + "/" + Convert.ToString(m_imailCount));
                                            LogDebug("Getting message number " + Convert.ToString(m_mailNumber), (int)LogSetting.DEBUG);
                                            m_mailAction = (int)MailAction.MAIL_SEND_LIST;
                                            LASTACTION = "MAIL_SEND_LIST";
                                            InteractServer((int)MailAction.MAIL_SEND_LIST);
                                        }
                                    }
                                    else
                                    {
                                        m_currAction = (int)MailAction.MAIL_ACTION_READ_ON;
                                        LASTACTION = "MAIL_ACTION_READ_ON";
                                        AsyncCallback recieveData = new AsyncCallback(OnRecievedData);
                                        if (m_TLSSecured != MailBox.NO_SSL && m_TLS_OK)
                                            ((SslStream)ar.AsyncState).BeginRead(m_mailBuffer, 0, m_buffSize, recieveData, (SslStream)ar.AsyncState);
                                        else
                                            ((NetworkStream)ar.AsyncState).BeginRead(m_mailBuffer, 0, m_buffSize, recieveData, (NetworkStream)ar.AsyncState);
                                    }
                                }
                                if (m_mailAction == (int)MailAction.MAIL_SEND_DELE) // return the mail count from the inbox
                                {
                                    LASTACTION = "MAIL_SEND_DELE";
                                    quitreceivemail();
                                    //InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server changequit
                                }
                                break;
                            case (int)MailAction.MAIL_SEND_QUIT:
                                LASTACTION = "MAIL_SEND_QUIT";
                                //m_mb.MailCount = CountMail(m_mb);

                                TimeoutTimer("STOP");
                                /*
                                m_timeOutTimer.Stop();
                                LogDebug("OnRecievedData: m_timeOutTimer.Stop()", (int)LogSetting.DEBUG);
                                */

                                m_mailSocket.Close();
                                m_mailSocketStream = null;
                                m_mailTLSStream = null;
                                if (m_ierrorNumber != 0)
                                {
                                    LogDebug("An error occured. Errornumber " + Convert.ToString(m_ierrorNumber) + " on receiving mail from mailbox", (int)LogSetting.ERROR);
                                    LogDebug("An error occured. errormessage from server: " + m_errorMessage, (int)LogSetting.ERROR);
                                }
                                //GotMailData(m_errorMessage, "Ready", m_ierrorNumber); // ready
                                quitreceivemail();
                                break;
                        }
                    } // else we are ready
                    else if (m_ierrorNumber != (int)SocketError.ERROR_NO_ERROR)
                    {
                        LogDebug("Error on receiving mails - operation aborted and busy flag set to false", (int)LogSetting.DEBUG);
                        quitreceivemail();
                    }
                }

            }
            catch (Exception ex)
            {
                LogDebug("Recieve error. mail number " + Convert.ToString(m_mailNumber) + " on mailbox ", (int)LogSetting.ERROR);
                LogDebug("Exception message is " + ex.Message, (int)LogSetting.ERROR);
                m_ierrorNumber = (int)SocketError.ERROR_EXCEPTION;
                LASTACTION = "RECEIVE ERROR - MAIL_SEND_QUIT";
                InteractServer((int)MailAction.MAIL_SEND_QUIT); // logout from the server
                quitreceivemail();
            }
            LogDebug("OnRecievedData completed", (int)LogSetting.DEBUG);
        }


        private void quitreceivemail()
        {
            TimeoutTimer("STOP");
            LogDebug("Operation completed - resetting busy flag", (int)LogSetting.DEBUG);
            BUSY = false;
        }

        // sending some request to the mailserver
        // and set the required mailAction
        // for example: if we sended the user we send the pass...
        private int InteractServer(int action)
        {
            LogDebug("InteractServer started " + action.ToString(), (int)LogSetting.DEBUG);
            Socket sock1 = m_mailSocket;
            byte[] toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("");
            if (sock1.Connected == true)
            {
                switch (action)
                {
                    case (int)MailAction.MAIL_SEND_LIST: // send user

                        toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("list " + Convert.ToString(m_mailNumber) + _CRLF_);
                        LogDebug("  MAIL_SEND_LIST", (int)LogSetting.MESSAGE);
                        break;
                    case (int)MailAction.MAIL_SEND_CAPABILITIES: //check capabilities (to this date, only used to verify if server supports STARTTLS)
                        LogDebug("  MAIL_SEND_CAPABILITIES", (int)LogSetting.MESSAGE);
                        toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("capa" + _CRLF_);
                        break;
                    case (int)MailAction.MAIL_SEND_STARTTLS: //authenticate through explicit SSL/TLS
                        LogDebug("  MAIL_SEND_STARTTLS", (int)LogSetting.MESSAGE);
                        toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("stls" + _CRLF_);
                        break;
                    case (int)MailAction.MAIL_SEND_USER: // send user
                        LogDebug("  MAIL_SEND_USER", (int)LogSetting.MESSAGE);
                        toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("user " + m_mb.Username + _CRLF_);
                        break;
                    case (int)MailAction.MAIL_SEND_PASS: // send pass
                        LogDebug("  MAIL_SEND_PASS", (int)LogSetting.MESSAGE);
                        toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("pass " + m_mb.Password + _CRLF_);
                        break;
                    case (int)MailAction.MAIL_SEND_PERFORM: // send depends on what we request in Connect()
                        if (m_mailAction == (int)MailAction.MAIL_SEND_STAT)
                        {
                            toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("stat" + _CRLF_);
                            LogDebug("  MAIL_SEND_STAT", (int)LogSetting.MESSAGE);
                        }
                        if (m_mailAction == (int)MailAction.MAIL_SEND_RETR)
                        {
                            toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("retr " + Convert.ToString(m_mailNumber) + _CRLF_);
                            LogDebug("  MAIL_SEND_RETR", (int)LogSetting.MESSAGE);
                        }
                        if (m_mailAction == (int)MailAction.MAIL_SEND_DELE)
                        {
                            toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("dele " + Convert.ToString(m_mailNumber) + _CRLF_);
                            LogDebug("  MAIL_SEND_DELE", (int)LogSetting.MESSAGE);
                        }
                        if (m_mailAction == (int)MailAction.MAIL_SEND_RETR_LIST)
                        {
                            toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("list" + _CRLF_);
                            LogDebug("  MAIL_SEND_RETR_LIST", (int)LogSetting.MESSAGE);
                        }
                        break;
                    case (int)MailAction.MAIL_SEND_QUIT:

                        toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("QUIT" + _CRLF_);
                        LogDebug("  MAIL_SEND_QUIT", (int)LogSetting.MESSAGE);

                        break;
                    default:
                        LogDebug("  DEFAULT send nothing", (int)LogSetting.MESSAGE);
                        toSend = System.Text.ASCIIEncoding.ASCII.GetBytes("");
                        break;
                }


            }
            TimeoutTimer("START");
            //m_timeOutTimer.Start();
            if (sock1.Connected == true && action > 0 && toSend.Length > 1)
            {
                try
                {
                    m_currAction = action;
                    AsyncCallback recieveData = new AsyncCallback(OnRecievedData);
                    sock1.Blocking = false;
                    //Log.Info(System.Text.Encoding.ASCII.GetString(toSend));
                    //sock1.Poll(15000,System.Net.Sockets.SelectMode.SelectRead);
                    //sock1.Send(toSend,0,toSend.Length,noFlags);
                    if (m_TLSSecured != MailBox.NO_SSL && m_TLS_OK)
                        m_mailTLSStream.Write(toSend, 0, toSend.Length);
                    else
                        m_mailSocketStream.Write(toSend, 0, toSend.Length);
                    m_mailBuffer = System.Text.Encoding.ASCII.GetBytes(m_emptyBuffer);

                    //TimeoutTimer("START");
                    /*
                    m_timeOutTimer.Start();
                    LogDebug("InteractServer: m_timeOutTimer.Start()", (int)LogSetting.DEBUG);*/
                    //sock1.BeginReceive( m_mailBuffer, 0, m_buffSize, noFlags, recieveData , sock1 );
                    if (m_TLSSecured != MailBox.NO_SSL && m_TLS_OK)
                        m_mailTLSStream.BeginRead(m_mailBuffer, 0, m_buffSize, recieveData, m_mailTLSStream);
                    else
                        m_mailSocketStream.BeginRead(m_mailBuffer, 0, m_buffSize, recieveData, m_mailSocketStream);
                }
                catch (Exception ee)
                {

                    LogDebug("Error in InteractServer ", (int)LogSetting.ERROR);
                    LogDebug("Exception message is " + ee.Message, (int)LogSetting.ERRORONLY);
                    return 0;
                }
            }
            LogDebug("InteractServer completed", (int)LogSetting.DEBUG);
            return 0;
        }






        private bool RemoteCertificateValidationCallback(Object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
        {
            SslPolicyErrors errors = sslPolicyErrors;

            if (((errors & SslPolicyErrors.RemoteCertificateChainErrors) ==
                  SslPolicyErrors.RemoteCertificateChainErrors) && UntrustedRootOK)
            {
                errors -= SslPolicyErrors.RemoteCertificateChainErrors;
            }

            /* --> CertNameMistmatchOK is always set to false
            if (((errors & SslPolicyErrors.RemoteCertificateNameMismatch) ==
                  SslPolicyErrors.RemoteCertificateNameMismatch) && CertNameMistmatchOK)
            {
              errors -= SslPolicyErrors.RemoteCertificateNameMismatch;
            }
             */

            if (errors == SslPolicyErrors.None)
                return true;
            else
                return false;

            //Le serveur doit s'authentifier sans erreur
        }

        public void SetMailboxPath(string mailbox, string attachments)
        {
            m_mailFolder = mailbox;
            m_attachmentFolder = attachments;
        }
        public Socket GetSocket
        {
            get { return m_mailSocket; }
        }
        // get a mail
        protected virtual bool ServerExists(MailBox mb)
        {
            try
            {
                IPHostEntry hostIP = Dns.GetHostEntry(mb.ServerAddress);
                IPAddress[] addr = hostIP.AddressList;
            }
            catch
            {
                return false;
            }
            return true;
        }
        protected virtual bool ServerExists(MailBox mb, ref IPAddress[] addr)
        {
            try
            {
                IPHostEntry hostIP = Dns.GetHostEntry(mb.ServerAddress);
                string[] aliases = hostIP.Aliases;
                addr = hostIP.AddressList;
            }
            catch
            {
                return false;
            }
            return true;
        }


        private bool IsMailInList(string mailText)
        {
            mailText = mailText.Replace(_CRLF_, "");
            string fileName = m_mailFolder + @"\transferList.txt";
            string listText = "";
            if (File.Exists(fileName) == true)
            {
                try
                {
                    System.IO.TextReader tr = (System.IO.TextReader)System.IO.File.OpenText(fileName);
                    listText = tr.ReadToEnd();
                    tr.Close();

                    Regex splitter = new Regex(@_CRLF_);
                    string[] lines = splitter.Split(listText);
                    foreach (string line in lines)
                        if (mailText.Equals(line) == true)
                            return true;
                    return false;
                }
                catch (Exception ee)
                {

                    LogDebug("Error in processing transferList.txt ", (int)LogSetting.ERROR);
                    LogDebug("Exception message is " + ee.Message, (int)LogSetting.ERRORONLY);
                    return false;
                }
            }
            return true;
        }
        //
        private void AppendMailToList(string text)
        {
            try
            {
                byte[] buffer = Encoding.ASCII.GetBytes(text);
                string fileName = m_mailFolder + @"\transferList.txt";
                System.IO.FileStream fs = new System.IO.FileStream(fileName, System.IO.FileMode.Append);
                fs.Write(buffer, 0, buffer.Length);
                fs.WriteByte(13);
                fs.WriteByte(10);
                fs.Close();
            }
            catch (Exception ee)
            {
                LogDebug("Error in appending transferList.txt ", (int)LogSetting.ERROR);
                LogDebug("Exception message is " + ee.Message, (int)LogSetting.ERRORONLY);

            }
        }

        
    

//______________________________________________________________________________________
// huha part starts here for parsing

        //-------------------------------------------------------------------------------------------------------------        
        //log handling for debug, error and addmessage (return mals)
        //-------------------------------------------------------------------------------------------------------------                
        public void LogDebug(string text, int field)
        {
            //trigger message event
            
            if (field == (int)LogSetting.INFO)
            {
                Log.Debug("EmailScheduler MailClass: " + text);
                //if (newmessage != null)
                //    newmessage(text, field);

            }
            else if ((field == (int)LogSetting.DEBUG) && (DEBUG == true))
            {
                if (DEBUG == true)
                {
                    Log.Debug("EmailScheduler MailClass: " + text);
                    //if (newmessage != null)
                    //    newmessage(text, field);
                }

            }
            else if (field == (int)LogSetting.ERROR)
            {
                Log.Error("EmailScheduler MailClass: " + text);
                Log.Debug("EmailScheduler MailClass: " + text);
                MESSAGE = MESSAGE + text + "\n";
                //if (newmessage != null)
                //    newmessage(text, field);

            }
            else if (field == (int)LogSetting.ERRORONLY)
            {
                Log.Error("EmailScheduler MailClass: " + text);
                //if (newmessage != null)
                //    newmessage(text, field);

            }
            else if ((field == (int) LogSetting.MESSAGE)&& (DEBUG == true))
            {
                MESSAGE = MESSAGE + text + "\n";
                Log.Debug("EmailScheduler MailClass: " + text);
                //if (newmessage != null)
                //    newmessage(text, field);

            }
            else if (field == (int)LogSetting.ADDRESPONSE)
            {
                RESPONSE += text + "\n";
                Log.Debug(text);
                //if (newmessage != null)
                //    newmessage(text, field);

            }
            else
            {
                //Log.Error("EmailScheduler Error MailClass: Unknown message Code " + field.ToString(), (int)LogSetting.ERROR);
            }
        }



        //-------------------------------------------------------------------------------------------------------------        
        //load all settings from data base
        //-------------------------------------------------------------------------------------------------------------                
        public bool LoadSettings()
        {
            //Initialization
            _checkBoxAcceptEmail = false;
            _checkBoxUseSchedulerPassword = false;
            _checkBoxUseTAN = false;
            _checkBoxUseRecordingHourLimit = false;
            _checkBoxAllowDelete = false;
            _checkBoxAllowRecord = false;
            _checkBoxReplyToEmails = false;
            _checkBoxAllowHelpChannel = true;
            _checkBoxAllowRunScripts = false;
            _checkBoxAllowHelpSchedule = false;
            _checkBoxAllowHelpEPG = false;
            _checkBoxAllowTvWishList = false;
            _checkBoxAllowSeriesSchedules = false;
            _checkBoxdeletefromserver = false;

            _LabelRecordingHours = 0;
            _TextBoxEmailSubject = "";
            _TextBoxUserName = "";
            _TextBoxPassword = "";
            _TextBoxSmtpEmailAddress = "";
            _TextBoxSchedulerPassword = "";
            _TextBoxEditEmailSender = "";
            _TextBoxEditTan = "";
            _numericUpDownCheckEmail = 0;
            _numericUpDownMaxRecordingHours = 0;
            _lastprovider = ";;;;;;;";

            
            _numericUpDownPop3Port = 0;
            _checkBoxImpliciteSSL = false;
            _checkBoxExpliciteSSL = false;
            _TextBoxSmtpServer = "";
            _numericUpDownSmtpPort = 0;
            _checkBoxSSL = false;

            _ListBoxEmailSender = "";
            _ListBoxTAN = "";


            TvBusinessLayer layer = new TvBusinessLayer();
            Setting setting;




            //check for installation folders
            setting = layer.GetSetting("EmailScheduler_TV_USER_FOLDER", "NOT_FOUND");
            TV_USER_FOLDER = setting.Value;



            if ((File.Exists(TV_USER_FOLDER + @"\TvService.exe") == true) || (Directory.Exists(TV_USER_FOLDER) == false))
            {

                //autodetect paths
                InstallPaths instpaths = new InstallPaths();  //define new instance for folder detection
                instpaths.GetInstallPaths();
                TV_USER_FOLDER = instpaths.TV_USER_FOLDER;
                LogDebug("TV server user folder detected at " + TV_USER_FOLDER, (int)LogSetting.DEBUG);

                if ((File.Exists(TV_USER_FOLDER + @"\TvService.exe") == true)||(Directory.Exists(TV_USER_FOLDER)==false))
                {
                    LogDebug(@" TV server user folder does not exist - using C:\MediaPortal", (int)LogSetting.ERROR);
                    TV_USER_FOLDER = @"C:\MediaPortal";
                    if (Directory.Exists(TV_USER_FOLDER) == false)
                        Directory.CreateDirectory(TV_USER_FOLDER + @"\EmailScheduler");
                }


            }



            //checkboxes
            setting = layer.GetSetting("EmailScheduler_Debug", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                DEBUG = true;
            else
                DEBUG = false;

            setting = layer.GetSetting("EmailScheduler_AcceptEmail", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxAcceptEmail = true;
            else
                _checkBoxAcceptEmail = false;


            setting = layer.GetSetting("EmailScheduler_EmailPassword", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxUseSchedulerPassword = true;
            else
                _checkBoxUseSchedulerPassword = false;


            setting = layer.GetSetting("EmailScheduler_UseTAN", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxUseTAN = true;
            else
                _checkBoxUseTAN = false;

            setting = layer.GetSetting("EmailScheduler_UseRecordingHourLimit", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxUseRecordingHourLimit = true;
            else
                _checkBoxUseRecordingHourLimit = false;

            setting = layer.GetSetting("EmailScheduler_AllowDelete", "true");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxAllowDelete = true;
            else
                _checkBoxAllowDelete = false;

            setting = layer.GetSetting("EmailScheduler_AllowRecord", "true");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxAllowRecord = true;
            else
                _checkBoxAllowRecord = false;

            setting = layer.GetSetting("EmailScheduler_ReplyToEmails", "true");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxReplyToEmails = true;
            else
                _checkBoxReplyToEmails = false;

            setting = layer.GetSetting("EmailScheduler_AllowSeriesSchedules", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxAllowSeriesSchedules = true;
            else
                _checkBoxAllowSeriesSchedules = false;

            setting = layer.GetSetting("EmailScheduler_AllowHelpChannel", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxAllowHelpChannel = true;
            else
                _checkBoxAllowHelpChannel = false;

            setting = layer.GetSetting("EmailScheduler_AllowRunScripts", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxAllowRunScripts = true;
            else
                _checkBoxAllowRunScripts = false;

            setting = layer.GetSetting("EmailScheduler_AllowHelpSchedule", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxAllowHelpSchedule = true;
            else
                _checkBoxAllowHelpSchedule = false;

            setting = layer.GetSetting("EmailScheduler_AllowHelpEPG", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxAllowHelpEPG = true;
            else
                _checkBoxAllowHelpEPG = false;

            setting = layer.GetSetting("EmailScheduler_AllowTvWishList", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxAllowTvWishList = true;
            else
                _checkBoxAllowTvWishList = false;

            if (_checkBoxAllowTvWishList == true)
            {//  check for TvWishList plugin
                string plugversion = detectplugin("TvWishList");
                if (plugversion == "NOT_FOUND")
                {
                    LogDebug("TvWishList plugin not installed\n Open the MediaPortal MPI installer and install the plugin first before enabling it in EmailScheduler", (int)LogSetting.ERROR);
                    _checkBoxAllowTvWishList = false;
                }
            }


            setting = layer.GetSetting("EmailScheduler_DeleteMailFromServer", "false");
            if (Convert.ToBoolean(setting.Value) == true)
                _checkBoxdeletefromserver = true;
            else
                _checkBoxdeletefromserver = false;


            //labels
            setting = layer.GetSetting("EmailScheduler_RecordingHours", "-1");
            _LabelRecordingHours = Convert.ToSingle(setting.Value);

            //textboxes

            setting = layer.GetSetting("EmailScheduler_EmailSubject", "");
            _TextBoxEmailSubject = setting.Value;

            setting = layer.GetSetting("EmailScheduler_UserName", "");
            _TextBoxUserName = setting.Value;

            setting = layer.GetSetting("EmailScheduler_Password", "");
            _TextBoxPassword = setting.Value;

            setting = layer.GetSetting("EmailScheduler_SmtpEmailAddress", "");
            _TextBoxSmtpEmailAddress = setting.Value;

            setting = layer.GetSetting("EmailScheduler_SchedulerPassword", "");
            _TextBoxSchedulerPassword = setting.Value;

            setting = layer.GetSetting("EmailScheduler_EditEmailSender", "");
            _TextBoxEditEmailSender = setting.Value;


            setting = layer.GetSetting("EmailScheduler_EditTan", "");
            _TextBoxEditTan = setting.Value;


            setting = layer.GetSetting("EmailScheduler_EmailSender", "");
            _ListBoxEmailSender = setting.Value;



            setting = layer.GetSetting("EmailScheduler_TAN", "");
            _ListBoxTAN = setting.Value;


            //integer values
            setting = layer.GetSetting("EmailScheduler_CheckEmail", "0");
            _numericUpDownCheckEmail = Convert.ToDouble(setting.Value);

            setting = layer.GetSetting("EmailScheduler_RecordingHoursLimit", "0");
            _numericUpDownMaxRecordingHours = Convert.ToInt32(setting.Value);

            setting = layer.GetSetting("EmailScheduler_MaxEmails", "100");
            MAX_EMAIL_PROCESSING = Convert.ToInt32(setting.Value);

            setting = layer.GetSetting("EmailScheduler_MaxEpg", "500");
            MAX_EPG_OUTPUT = Convert.ToInt32(setting.Value);

            setting = layer.GetSetting("EmailScheduler_MaxWait", "5");
            MAX_SCRIPT_WAIT_MINUTES = Convert.ToInt32(setting.Value);

            setting = layer.GetSetting("EmailScheduler_Providers_0", ";;;;;;;");
            _lastprovider = setting.Value;

            //default pre and post record from general recording settings
            setting = layer.GetSetting("preRecordInterval", "5");
            DEFAULT_PRERECORD = Convert.ToInt32(setting.Value);

            setting = layer.GetSetting("postRecordInterval", "5");
            DEFAULT_POSTRECORD = Convert.ToInt32(setting.Value);


            //provider values
            string[] array = _lastprovider.Split(";".ToCharArray());
            if (array.Length != 8)
            {
                LogDebug("EmailScheduler Error: Invalid provider string: " + _lastprovider + "\n Count is " + array.Length, (int)LogSetting.DEBUG);
                MessageBox.Show("EmailScheduler Error: Invalid provider string: " + _lastprovider + "\n Count is " + array.Length);
                return false;
            }

            _TextBoxPop3Server = array[1].ToString();
            _numericUpDownPop3Port = Convert.ToInt32(array[2].ToString());
            _checkBoxImpliciteSSL = Convert.ToBoolean(array[3].ToString());
            _checkBoxExpliciteSSL = Convert.ToBoolean(array[4].ToString());
            _TextBoxSmtpServer = array[5].ToString();
            _numericUpDownSmtpPort = Convert.ToInt32(array[6].ToString());
            _checkBoxSSL = Convert.ToBoolean(array[7].ToString());

            //basic checking of provider data
            if (_TextBoxSmtpServer == "")
            {
                LogDebug("Error: No Smtp Server defined - check and test configuration in TV Server Configuration", (int)LogSetting.ERROR);
                if (newlabelmessage != null)
                {
                    newlabelmessage("No Smtp Server defined");
                }
                return false;
            }

            if (_TextBoxUserName == "")
            {
                LogDebug("Error: No user name defined - check and test configuration in TV Server Configuration", (int)LogSetting.ERROR);
                if (newlabelmessage != null)
                {
                    newlabelmessage("No user name defined");
                }
                return false;
            }

            if (_TextBoxPassword == "")
            {
                LogDebug("Error: No password defined - check and test configuration in TV Server Configuration", (int)LogSetting.ERROR);
                if (newlabelmessage != null)
                {
                    newlabelmessage("No password defined");
                }
                return false;
            }
            if (_TextBoxSmtpEmailAddress == "")
            {
                _TextBoxSmtpEmailAddress = _TextBoxUserName;
            }
            



            return true;

        }


        //-------------------------------------------------------------------------------------------------------------        
        //detect plugin with the name "plugin name" and return the version number
        //-------------------------------------------------------------------------------------------------------------      
        private string detectplugin(string pluginname)
        {
            PluginLoader mypluginloader = new PluginLoader();
            mypluginloader.Load();
            foreach (ITvServerPlugin plug in mypluginloader.Plugins)
            {
                if (plug.Name == pluginname)
                {
                    return plug.Version;
                }
            }
            return "NOT_FOUND";
        }

        //-------------------------------------------------------------------------------------------------------------        
        //immediate email header parsing after receiving email - header and body are built up in lists and processed later
        //-------------------------------------------------------------------------------------------------------------                
        public void emailparser(string email, int messagenumber)
        {
	        String[] mail_lines = email.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
	        String datum="NOTFOUND";
	        String from="NOTFOUND";
	        String subject="NOTFOUND";
	        String encoding = "NOTFOUND";
            String content = "NOTFOUND";
            int body_start=-1;
            int body_end = -1;
            
            RESPONSE = "";
            DELETE_EMAIL = false;

            //DEBUG:
            //Log.Debug("begin original email");
            //Log.Debug(email);
            //Log.Debug("end original email");

            int line_ctr = 0;
            string emailmessage = "";
            foreach (string line in mail_lines)  //get keywords for must have
            {
                emailmessage += line + "\n";
                //	extract timestamp   	
                if ((extractkeyworddata("DATE", line, ':') != "NOTFOUND") && (datum == "NOTFOUND"))
                {
                    datum = extractkeyworddata("DATE", line, ':');

                    LogDebug("OldProcessedEmail=" + OldProcessedEmail, (int)LogSetting.DEBUG);
                    LogDebug("datum=" + datum + "\n", (int)LogSetting.DEBUG);

                    if (messagenumber > LastProcessedEmailNumber) //mark latest mail on server
                    {
                        BackupLastProcessedEmailNumber = LastProcessedEmailNumber; //backup in case this email will get deleted from server
                        BackupLastProcessedEmail = LastProcessedEmail; //backup in case this email will get deleted from server
                        LastProcessedEmailNumber = messagenumber;
                        LastProcessedEmail = datum;
                    }

                    if (OldProcessedEmail == datum)  //check for oldmail already processed on server
                    {
                        LogDebug("Email with time stamp " + OldProcessedEmail + " has been already processed", (int)LogSetting.DEBUG);
                        OLD_MAIL_REACHED = true; // set the flag that no more messages are being retrieved from the server, besides old errors
                        return;
                    }

                }
                //	extract from		
                else if ((extractkeyworddata("FROM", line, ':') != "NOTFOUND") && (from == "NOTFOUND"))
                {
                    from = extractkeyworddata("FROM", line, ':');
                }
                //	extract subject		
                else if ((extractkeyworddata("SUBJECT", line, ':') != "NOTFOUND") && (subject == "NOTFOUND"))
                {
                    subject = extractkeyworddata("SUBJECT", line, ':');
                    if (subject != _TextBoxEmailSubject)
                    {
                        LogDebug("Email Subject \n" + subject + "\ndoes not match TV server subject \n" + _TextBoxEmailSubject, (int)LogSetting.INFO);
                        return;
                    }
                }
                
                //extract body start
                else if (extractkeyworddata("ENVELOPE", line, '-') != "NOTFOUND") 
                {
                    body_start = line_ctr+1;
                }
                //extract body start
                else if (extractkeyworddata("<BODY", line, '>') != "NOTFOUND")
                {
                    body_start = line_ctr;
                }
                //extract body start
                else if (extractkeyworddata("</BODY", line, '>') != "NOTFOUND")
                {
                    body_end = line_ctr;
                }
                //extract encoding
                else if ((extractkeyworddata("CONTENT-TRANSFER-ENCODING", line, ':') != "NOTFOUND")&& (encoding == "NOTFOUND"))
                {
                    encoding = extractkeyworddata("CONTENT-TRANSFER-ENCODING", line, ':');
                }
                else if ((extractkeyworddata("CONTENT-TYPE", line, ':') != "NOTFOUND") && (content == "NOTFOUND"))
                {
                    content = extractkeyworddata("CONTENT-TYPE", line, ':');
                    if (content.ToLower().Contains("multipart")==true)
                    {
                        LogDebug("CONTENT-TYPE found for multipart", (int)LogSetting.DEBUG);
                        content = "NOTFOUND";
                    }
                }
                else if ((extractkeyworddata("CONTENT-TYPE", line, ':') != "NOTFOUND") && (content != "NOTFOUND"))
                { //ignore second email part
                    LogDebug("Second CONTENT-TYPE found for multipart- skipping rest of email message", (int)LogSetting.DEBUG);
                    break;
                }

                

                line_ctr++;
            }
            if (body_end == -1)
            {
                body_end = line_ctr - 1;                
            }
            
	        
            // build up buffer strings for each email
            // lines are separated by \n
            // Later the emails will be parsed in revers order to ensure time cionsistent schedule processing of emails
            // the buffer strings start with
            // 0     int    message number from server
            // 1     string From
            // 2     string Date
            // 3     string Subject
            // 4     int    body start
            // 5     int    body end
            // 6     string encoding
            // 7     string Content-Type:
            // 8    int    line count body
            string header = messagenumber.ToString() + "\n" + from + "\n" + datum + "\n" + subject + "\n" + body_start.ToString() + "\n" + body_end.ToString() + "\n" + encoding + "\n" + content+"\n" +email.Length.ToString();
            EmailHeaders.Add(header);
            EmailBodies.Add(emailmessage);
            DELETE_EMAIL = true; // delete mail from server as initial email parsing was OK

            //LogDebug("Emailmessage:"+emailmessage, (int)LogSetting.DEBUG);
            //LogDebug("Emailmessage end", (int)LogSetting.DEBUG);
            

        }


        //-------------------------------------------------------------------------------------------------------------        
        //handle special encoding for QUOTED-PRINTABLE, remove tags and warn for incorrect encoding
        //-------------------------------------------------------------------------------------------------------------                
        public string specialencoding(string emailheader, string emailbody)
        {
            //log complete email
            String[] mail_header = emailheader.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
            

            LogDebug("Loging Mailheader:", (int)LogSetting.DEBUG);
            for (int i = 0; i < mail_header.Length; i++)  //header is always defined
            {
                LogDebug(mail_header[i], (int)LogSetting.DEBUG);
            }
            string encoding = mail_header[6];
            string type = mail_header[7];

            
            



            //warning for not 7 bit encoding
            if ((encoding.ToUpper() != "7BIT") && (encoding.ToUpper() != "8BIT"))
            {
                if ((encoding.ToUpper() != "QUOTED-PRINTABLE") && (type.ToUpper().Contains("CHARSET=ISO-8859-15") == false))
                {//special case CHARSET=ISO-8859-15 for QUOTED-PRINTABLE
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.DEBUG);
                    LogDebug("Warning: You are not using 7 or 8 bit encoding for sending emails - your encoding is " + encoding, (int)LogSetting.ADDRESPONSE);
                    LogDebug("This can cause mismatches for special characters in password, tan, channel name or program name", (int)LogSetting.ADDRESPONSE);
                    LogDebug("If you cannot change the setting and you encouter problems try to use a different provider", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.DEBUG);

                }
            }


            // handle special case CHARSET=ISO-8859-15 for QUOTED-PRINTABLE 
            if (encoding.ToUpper() == "QUOTED-PRINTABLE")
            {
                LogDebug("QUOTED-PRINTABLE Encoding for CHARSET=ISO-8859-15", (int)LogSetting.DEBUG);
                emailbody = emailbody.Replace("=\n", "");
                emailbody = emailbody.Replace("=\r\n", "");
                emailbody = emailbody.Replace("=3D", "=");
                char mychar;

                mychar = (char)196;//
                emailbody = emailbody.Replace("=C4", mychar.ToString());

                mychar = (char)228;//
                emailbody = emailbody.Replace("=E4", mychar.ToString());

                mychar = (char)220;//
                emailbody = emailbody.Replace("=DC", mychar.ToString());

                mychar = (char)252;//
                emailbody = emailbody.Replace("=FC", mychar.ToString());

                mychar = (char)214;//
                emailbody = emailbody.Replace("=D6", mychar.ToString());

                mychar = (char)246;//
                emailbody = emailbody.Replace("=F6", mychar.ToString());

                mychar = (char)223;//
                emailbody = emailbody.Replace("=DF", mychar.ToString());

                


            }
            LogDebug("Loging Encoded Mailbody:", (int)LogSetting.DEBUG);
            removetags(ref emailbody);
            LogDebug(emailbody, (int)LogSetting.DEBUG);            
            return emailbody;
        }


        //-------------------------------------------------------------------------------------------------------------        
        //parse messages and built up partial emails, do basic checking and parse password and tan
        //-------------------------------------------------------------------------------------------------------------                
        public void messageparser(string emailheader, string emailbody)
        {

            string encodedbody=specialencoding(emailheader,emailbody);

            String[] mail_header = emailheader.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
            String[] mail_lines = encodedbody.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
            //change ending . to space
            if (mail_lines.Length > 0)
            {
                if (mail_lines[mail_lines.Length - 1] == ".")
                {
                    mail_lines[mail_lines.Length - 1] = " ";
                }
            }
            DELETE_EMAIL = false; //assume error during parsing, will be set tot rue at the end
            //log parsing email
            LogDebug("***************************************************************************", (int)LogSetting.DEBUG);
            LogDebug("Parsing message " + mail_header[0], (int)LogSetting.DEBUG);
            LogDebug("***************************************************************************", (int)LogSetting.DEBUG);


            int number = Convert.ToInt32(mail_header[0]);

            // event trigger for status
            if (newlabelmessage != null)
                newlabelmessage("Parsing Email " + number);

            String from = mail_header[1];
            String datum = mail_header[2];
            String subject = mail_header[3];
            String password = "NOTFOUND";
            String tan = "NOTFOUND";

            int body_start = Convert.ToInt32(mail_header[4]);
            int body_end = Convert.ToInt32(mail_header[5]);
            
            
            String partialemail = "";
            RESPONSE = "";

            int lastoperation = (int)Scheduleoperation.NONE;

            
            // parse for password and TAN
            foreach (string line in mail_lines)  
            {
                //	extract password	
                if ((extractkeyworddata("PASSWORD", line, '=') != "NOTFOUND") && (password == "NOTFOUND"))
                {
                    password = extractkeyworddata("PASSWORD", line, '=');
                    LogDebug(line, (int)LogSetting.ADDRESPONSE);
                }
                //extract tan
                else if ((extractkeyworddata("TAN", line, '=') != "NOTFOUND") && (tan == "NOTFOUND"))
                {
                    tan = extractkeyworddata("TAN", line, '=');
                    LogDebug(line, (int)LogSetting.ADDRESPONSE);
                }


            }

            
            //check for password 
            if ((_checkBoxUseSchedulerPassword == true) && (password != _TextBoxSchedulerPassword))
            {

                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Error: Password "+password+" does not match", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);

                //for (int i = 0; i < password.Length; i++)
                //    LogDebug("i=" + i + "  char=" + Convert.ToInt16(password[i]) + "    char=" + password[i]);

                //LogDebug(password + " (length=" + password.Length + ") does not match password " + _TextBoxSchedulerPassword+"(length = "+_TextBoxSchedulerPassword.Length);
                s_receiver.Add(from);
                s_subject.Add(subject);
                s_text.Add( RESPONSE + "\n\n\n \n" + emailbody);
                
                return;
            }

            //check for TAN
            if (_checkBoxUseTAN == true)
            {

                string tempListBox = '\n' + _ListBoxTAN + '\n';
                string temp = '\n' + tan + '\n';

                //LogDebug("tempListBox length=" + tempListBox.Length + "    temp length=" + temp.Length);

                if (tempListBox.Contains(temp) == true)
                {
                    tempListBox = tempListBox.Replace(temp, "\n");
                    //LogDebug("replaced tempListBox=" + tempListBox);
                }
                else
                {
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Error: Tan " + tan + " does not match - aborting", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    //LogDebug("DEBUG: tan=" + tan + "   listboxtan=" + _ListBoxTAN);
                    s_receiver.Add(from);
                    s_subject.Add(subject);
                    s_text.Add( RESPONSE + "\n\n\n Reply to:\n" + emailbody);

                    return;
                }

                if (tempListBox.StartsWith("\n") == true)
                    tempListBox = tempListBox.Substring(1, tempListBox.Length - 1);

                if (tempListBox.EndsWith("\n") == true)
                    tempListBox = tempListBox.Substring(0, tempListBox.Length - 1);

                _ListBoxTAN = tempListBox;
                TvBusinessLayer layer = new TvBusinessLayer();
                Setting setting;
                setting = layer.GetSetting("EmailScheduler_TAN", "");
                setting.Value = _ListBoxTAN;
                setting.Persist();

            }

            //check for emailsender

            if (_checkBoxAcceptEmail == true)
            {
                String[] valid_senders = _ListBoxEmailSender.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);


                bool found = false;
                for (int i = 0; i < valid_senders.Length; i++)
                {
                    if (from.Contains(valid_senders[i]) == true)
                    {
                        found = true;
                        break;
                    }
                }


                if (found == false)
                {
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Error: Email Sender is not trusted - aborting", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    s_receiver.Add(from);
                    s_subject.Add(subject);
                    s_text.Add( RESPONSE + "\n\n\n Reply to:\n" + emailbody);
                    return;
                }

            }

            

            //check for invalid date
            if (datum == "NOTFOUND")
            {
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Error: date could not be retrieved from email \n" + emailbody, (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);

                return;
            }

            //initialization of partial email
	        partialemail="";
            UseScheduleName = false;
            DELETE_EMAIL=true;
            string name = "";
	        foreach (string line in mail_lines)  //get keywords for must have
	        {
                
	            //	extract AddProgram=<ProgramName>
		        if  (extractkeyworddata("ADDPROGRAM",line,'=') != "NOTFOUND")
		        {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("ADDPROGRAM", line, '=');
                    lastoperation = (int)Scheduleoperation.ADD;
		        }

                //	extract AddSchedule=<ProgramName>
                if (extractkeyworddata("ADDSCHEDULE", line, '=') != "NOTFOUND")
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("ADDSCHEDULE", line, '=');
                    lastoperation = (int)Scheduleoperation.ADD;
                }

                //	extract ProgramName=<ProgramName>
                if (extractkeyworddata("PROGRAM", line, '=') != "NOTFOUND")  //same as above with keyword program name
                {
                    processpreviousdata(name, ref partialemail,datum,number,lastoperation);
                    name = extractkeyworddata("PROGRAM", line, '=');
                    lastoperation = (int)Scheduleoperation.ADD;
                }

                //	extract PartialProgramName=<ProgramName>
                if (extractkeyworddata("PARTIAL", line, '=') != "NOTFOUND")  //same as above with keyword partial program name
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("PARTIAL", line, '=');
                    lastoperation = (int)Scheduleoperation.PARTIAL;
                }

                //	extract AllPartialProgramName=<ProgramName>
                if (extractkeyworddata("ALLPARTIAL", line, '=') != "NOTFOUND")  //same as above with keyword allpartial program name
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("ALLPARTIAL", line, '=');
                    lastoperation = (int)Scheduleoperation.ALLPARTIAL;
                }

	            //	extract DeleteSchedule <ProgramName>
		        if (extractkeyworddata("DELETESCHEDULE",line,'=') != "NOTFOUND")
		        {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("DELETESCHEDULE", line, '=');
                    lastoperation = (int)Scheduleoperation.DELETE;
		        }

                //	extract DeleteProgram <ProgramName>
                if (extractkeyworddata("DELETEPROGRAM", line, '=') != "NOTFOUND")
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("DELETEPROGRAM", line, '=');
                    lastoperation = (int)Scheduleoperation.DELETE;
                }

                //	extract Help
                if (extractkeyworddata("HELP", line, '=') != "NOTFOUND")
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("HELP", line, '=');
                    lastoperation = (int)Scheduleoperation.HELP;
                }

                //check for run scripts
                if (extractkeyworddata("RUN", line, '=') != "NOTFOUND")
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("RUN", line, '=');
                    lastoperation = (int)Scheduleoperation.RUN; 
                }

                //check for TvWishList ADD
                if (extractkeyworddata("ADDTV", line, '=') != "NOTFOUND")
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("ADDTV", line, '=');
                    lastoperation = (int)Scheduleoperation.TVWISH_ADD;
                }

                //check for TvWishList EDIT
                if (extractkeyworddata("EDITTV", line, '=') != "NOTFOUND")
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("EDITTV", line, '=');
                    lastoperation = (int)Scheduleoperation.TVWISH_EDIT;
                }

                //check for TvWishList DELETE
                if (extractkeyworddata("DELETETV", line, '=') != "NOTFOUND")
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("DELETETV", line, '=');
                    lastoperation = (int)Scheduleoperation.TVWISH_DELETE;
                }

                //check for TvWishList LIST
                if (extractkeyworddata("LISTTV", line, '\n') != "NOTFOUND")
                {
                    processpreviousdata(name, ref partialemail, datum, number, lastoperation);
                    name = extractkeyworddata("LISTTV", line, '\n');
                    lastoperation = (int)Scheduleoperation.TVWISH_LIST;
                }

                

                //build partialemail
                if (lastoperation!=(int)Scheduleoperation.NONE)
		        {
			        partialemail+=line+"\n";
		        }    	
	        }
            //process previous data
            processpreviousdata(name, ref partialemail, datum, number, lastoperation);
            lastoperation = (int)Scheduleoperation.NONE;

	        //	send return mail
            s_receiver.Add(from);
            s_subject.Add(subject);
            if (DEBUG == true)
                s_text.Add(RESPONSE + "\n\n\n Reply to:\n" + emailbody);  //attach email in debug mode
            else
                s_text.Add(RESPONSE + "\n\n\n");
        }


        //-------------------------------------------------------------------------------------------------------------        
        //call addschedule, deleteschedule, help or run operation 
        //-------------------------------------------------------------------------------------------------------------                
        public void processpreviousdata(string name, ref string partialemail, string datum, int number, int operation)
        {
            //process previous data
            LogDebug("processpreviousdata", (int)LogSetting.DEBUG);

            LogDebug("", (int)LogSetting.ADDRESPONSE);
            LogDebug("___________________________________________________________", (int)LogSetting.ADDRESPONSE);
            LogDebug("", (int)LogSetting.ADDRESPONSE);
        
            if ((operation == (int)Scheduleoperation.NONE) && (partialemail != ""))
            {
                //do nothing, as nonoperation was scheduled
            }
            else if ((operation == (int)Scheduleoperation.ADD) && (partialemail != "") )
            {
                bool partialprogramname=false; //programname must exactly match EPG data
                bool allpartialprograms = false; // do not add all matching programs
                bool ok = addschedule(name, partialemail, number, partialprogramname, allpartialprograms);
                if (ok == false)
                {
                    LogDebug("DELETE_EMAIL=false", (int)LogSetting.DEBUG);
                    DELETE_EMAIL = false;
                }
            }
            else if ((operation == (int)Scheduleoperation.PARTIAL) && (partialemail != ""))
            {
                bool partialprogramname = true; //partial programname match allowed to EPG data
                bool allpartialprograms = false;// do not add all matching programs
                bool ok = addschedule(name, partialemail, number, partialprogramname, allpartialprograms);
                if (ok == false)
                {
                    LogDebug("DELETE_EMAIL=false", (int)LogSetting.DEBUG);
                    DELETE_EMAIL = false;
                }
            }
            else if ((operation == (int)Scheduleoperation.ALLPARTIAL) && (partialemail != ""))
            {
                bool partialprogramname = true; //partial programname match allowed to EPG data
                bool allpartialprograms = true;// add all matching programs
                bool ok = addschedule(name, partialemail, number, partialprogramname, allpartialprograms);
                if (ok == false)
                {
                    LogDebug("DELETE_EMAIL=false", (int)LogSetting.DEBUG);
                    DELETE_EMAIL = false;
                }
            }
            else if ((operation == (int)Scheduleoperation.DELETE) && (partialemail != "") )
            {
                bool ok = deleteschedule(name, partialemail, number);
                if (ok == false)
                {
                    LogDebug("DELETE_EMAIL=false", (int)LogSetting.DEBUG);
                    DELETE_EMAIL = false;
                }
            }
            else if ((operation == (int)Scheduleoperation.HELP) && (partialemail != ""))
            {
                bool ok = helpschedule(name, partialemail, number);
                if (ok == false)
                {
                    LogDebug("DELETE_EMAIL=false", (int)LogSetting.DEBUG);
                    DELETE_EMAIL = false;
                }
            }
            else if ((operation == (int)Scheduleoperation.RUN) )
            {
                bool ok = runscriptfile(name, partialemail, number);
                if (ok == false)
                {
                    LogDebug("DELETE_EMAIL=false", (int)LogSetting.DEBUG);
                    DELETE_EMAIL = false;
                }
            }
            else if ((operation == (int)Scheduleoperation.TVWISH_ADD) || (operation == (int)Scheduleoperation.TVWISH_DELETE) || (operation == (int)Scheduleoperation.TVWISH_EDIT) || (operation == (int)Scheduleoperation.TVWISH_LIST))
            {
                bool ok = tvwishlist(name, partialemail, number,operation);
                if (ok == false)
                {
                    LogDebug("DELETE_EMAIL=false", (int)LogSetting.DEBUG);
                    DELETE_EMAIL = false;
                }
            }
            
            
            partialemail = "";
            UseScheduleName = false;
        }


        //-------------------------------------------------------------------------------------------------------------        
        //plausibility check of all row entries and reset to default values if  unrecognized format
        //-------------------------------------------------------------------------------------------------------------
        public string checkrowentry(string row, int number)
        {
            string[] defaultcolumns = new string[] { "Yes", "", "Partial Title", "All Channels", "All Movies", "Both", "", "0", DEFAULT_PRERECORD.ToString(), DEFAULT_POSTRECORD.ToString(), "", "", "", "", "All", "Always", "Any", "0" };
            string[] columns = row.Split(TV_WISH_COLUMN_SEPARATOR);
            int colcount = columns.Length;

            if (colcount > 0)//Active
            {
                if ((columns[0] != "No") && (columns[0] != "Yes"))
                {
                    LogDebug("!!!Error: Unknown value=" + columns[0] + " for keyword ACTIVE - resetting to Yes", number);
                }
                else
                {
                    defaultcolumns[0] = columns[0];
                }
            }

            if (colcount > 1) //SearchFor
            {
                defaultcolumns[1] = columns[1];
            }

            if (colcount > 2)//MatchType
            {
                if ((columns[2] != "Exact Title") && (columns[2] != "Partial Text") && (columns[2] != "Partial Text/Title") && (columns[2] != "Partial Title"))
                {
                    LogDebug("!!!Error: Unknown value=" + columns[2] + " for keyword MATCHTYPE - resetting to Partial Title", number);
                }
                else
                {
                    defaultcolumns[2] = columns[2];
                }
            }

            if (colcount > 3)//Group
            {
                bool foundflag = false;
                foreach (ChannelGroup channelgroup in ChannelGroup.ListAll())
                {
                    if (channelgroup.GroupName == columns[3])
                    {
                        foundflag = true;
                    }
                }
                foreach (RadioChannelGroup radiochannelgroup in RadioChannelGroup.ListAll())
                {
                    if (radiochannelgroup.GroupName == columns[3])
                    {
                        foundflag = true;
                    }
                }


                if (foundflag == false)
                {
                    LogDebug("!!!Error: Unknown value=" + columns[3] + " for keyword GROUP - resetting to All Channels", number);
                }
                else
                {
                    defaultcolumns[3] = columns[3];
                }
            }

            if (colcount > 4)//RecordType
            {
                if ((columns[4] != "All Movies") && (columns[4] != "One Episode") && (columns[4] != "All Episodes") && (columns[4] != "One Movie"))
                {
                    LogDebug("!!!Error: Unknown value=" + columns[4] + " for keyword RECORDTYPE - resetting to One Movie", number);
                }
                else
                {
                    defaultcolumns[4] = columns[4];
                }
            }

            if (colcount > 5)//Action
            {
                if ((columns[5] != "Record") && (columns[5] != "Email") && (columns[5] != "Both"))
                {
                    LogDebug("!!!Error: Unknown value=" + columns[5] + " for keyword Action - resetting to Both", number);
                }
                else
                {
                    defaultcolumns[5] = columns[5];
                }
            }

            if (colcount > 6) //Exclude
            {
                defaultcolumns[6] = columns[6];
            }

            if (colcount > 7) //Found
            {
                try
                {
                    int k = Convert.ToInt32(columns[7]);
                    if (k >= 0)
                    {
                        defaultcolumns[7] = k.ToString();
                    }
                }
                catch //do nothing and use default
                {
                    LogDebug("!!!Error: Unknown value=" + columns[7] + " for keyword Found - resetting to 0", number);
                }
            }

            if (colcount > 8) //PreRecord
            {
                try
                {
                    int k = Convert.ToInt32(columns[8]);
                    if (k >= 0)
                    {
                        defaultcolumns[8] = k.ToString();
                    }
                }
                catch //do nothing and use default
                {
                    LogDebug("!!!Error: Unknown value=" + columns[8] + " for keyword PreRecord - resetting to recording setting default", number);
                }
            }

            if (colcount > 9) //PostRecord
            {
                try
                {
                    int k = Convert.ToInt32(columns[9]);
                    if (k >= 0)
                    {
                        defaultcolumns[9] = k.ToString();
                    }
                }
                catch //do nothing and use default
                {
                    LogDebug("!!!Error: Unknown value=" + columns[9] + " for keyword PreRecord - resetting to recording setting default", number);
                }
            }

            if (colcount > 10) //EpisodeName
            {
                defaultcolumns[10] = columns[10];
            }

            if (colcount > 11) //EpisodePart
            {
                defaultcolumns[11] = columns[11];
            }

            if (colcount > 12) //EpisodeNumber
            {
                if (columns[12] != "")
                {
                    try
                    {
                        int k = Convert.ToInt32(columns[12]);
                        if (k > 0)
                        {
                            defaultcolumns[12] = k.ToString();
                        }
                    }
                    catch //do nothing and use default
                    {
                        LogDebug("!!!Error: Unknown value=" + columns[12] + " for keyword EpisodeNumber - resetting to empty string", number);
                    }
                }
            }

            if (colcount > 13) //SeriesNumber
            {
                if (columns[13] != "")
                {
                    try
                    {
                        int k = Convert.ToInt32(columns[13]);
                        if (k > 0)
                        {
                            defaultcolumns[13] = k.ToString();
                        }
                    }
                    catch //do nothing and use default
                    {
                        LogDebug("!!!Error: Unknown value=" + columns[13] + " for keyword SeriesNumber - resetting to empty string", number);
                    }
                }
            }

            if (colcount > 14) //KeepEpisodes
            {
                if (columns[14] != "All")
                {
                    try
                    {
                        int k = Convert.ToInt32(columns[14]);
                        if (k > 0)
                        {
                            defaultcolumns[14] = k.ToString();
                        }
                    }
                    catch //do nothing and use default
                    {
                        LogDebug("!!!Error: Unknown value=" + columns[14] + " for keyword KeepEpisodes - resetting to All", number);
                    }
                }
            }

            if (colcount > 15) //KeepUntil
            {
                if (columns[15] != "Always")
                {
                    try
                    {
                        DateTime k = DateTime.ParseExact(columns[15], "yyyy-MM-dd", CultureInfo.InvariantCulture);
                        LogDebug("debug  k=" + k.ToString(), (int)LogSetting.DEBUG);
                        if (k > DateTime.Now)
                        {
                            defaultcolumns[15] = columns[15];
                        }
                    }
                    catch //do nothing and use default
                    {
                        LogDebug("!!!Error: Unknown value=" + columns[15] + " for keyword KeepUntil - resetting to Always", number);
                    }
                }
            }

            if (colcount > 16) //RecommendedCard
            {
                if (columns[16] != "Any")
                {
                    try
                    {
                        int k = Convert.ToInt32(columns[16]);
                        if ((k > 0) && (k <= Card.ListAll().Count))
                        {
                            defaultcolumns[16] = k.ToString();
                        }
                    }
                    catch //do nothing and use default
                    {
                        LogDebug("!!!Error: Unknown value=" + columns[16] + " for keyword RecommendedCard - resetting to Any", number);
                    }
                }
            }

            if (colcount > 17) //Priority
            {
                try
                {
                    int k = Convert.ToInt32(columns[17]);
                    if ((k >= 0) && (k <= 9))
                    {
                        defaultcolumns[17] = k.ToString();
                    }
                }
                catch //do nothing and use default
                {
                    LogDebug("!!!Error: Unknown value=" + columns[17] + " for keyword Priority - resetting to 0", number);
                }
            }


            string checkedrow = defaultcolumns[0];
            for (int i = 1; i < defaultcolumns.Length; i++)
            {
                checkedrow += TV_WISH_COLUMN_SEPARATOR + defaultcolumns[i];
            }

            return checkedrow;
        }



        //-------------------------------------------------------------------------------------------------------------        
        // process TvWishlist commands
        //-------------------------------------------------------------------------------------------------------------   
        public bool tvwishlist(string name, string partialemail, int number, int operation)
        {

            if (_checkBoxAllowTvWishList == false)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("TvWishList support is not allowed by TV server user settings ", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }

            TvBusinessLayer layer = new TvBusinessLayer();
            Setting setting;

            LogDebug("tvwishlist name="+name, (int)LogSetting.DEBUG);
            LogDebug("tvwishlist partialemail="+partialemail, (int)LogSetting.DEBUG);
            LogDebug("tvwishlist number="+number.ToString(), (int)LogSetting.DEBUG);
            LogDebug("tvwishlist operation="+operation.ToString(), (int)LogSetting.DEBUG);

            // parse additional keywords
            string[] mail_lines = partialemail.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);

            
            //defaults
            string Active = "Yes";
            string SearchFor = "";
            string MatchType = "Partial Title";
            string Group = "All Channels";
            string RecordType = "One Movie";
            string Action = "Both";
            string Exclude = "";
            string Found = "0";
            //default pre and post record from general recording settings
            string PreRecord = DEFAULT_PRERECORD.ToString();
            string PostRecord = DEFAULT_POSTRECORD.ToString();
            string Episodename = "";
            string EpisodePart = "";
            string EpisodeNumber = "";
            string SeriesNumber = "";
            string KeepEpisodes = "All";
            string KeepUntil = "Always";
            string RecommendedCard = "Any";
            string Priority = "0";

            if (operation == (int)Scheduleoperation.TVWISH_EDIT)
            {
                Active = "NOTFOUND";
                SearchFor = "NOTFOUND";
                MatchType = "NOTFOUND";
                Group = "NOTFOUND";
                RecordType = "NOTFOUND";
                Action = "NOTFOUND";
                Exclude = "NOTFOUND";
                Found = "NOTFOUND";
                PreRecord = "NOTFOUND";
                PostRecord = "NOTFOUND";
                Episodename = "NOTFOUND";
                EpisodePart = "NOTFOUND";
                EpisodeNumber = "NOTFOUND";
                SeriesNumber = "NOTFOUND";
                KeepEpisodes = "NOTFOUND";
                KeepUntil = "NOTFOUND";
                RecommendedCard = "NOTFOUND";
                Priority = "NOTFOUND";
            }
            
            //parse email
            foreach (string line in mail_lines)  //get keywords for must have
            {

                if (extractkeyworddata("ACTIVE", line, '=') != "NOTFOUND")
                {
                    Active = extractkeyworddata("ACTIVE", line, '=');
                }

                if (extractkeyworddata("SEARCHFOR", line, '=') != "NOTFOUND")
                {
                    SearchFor = extractkeyworddata("SEARCHFOR", line, '=');
                }

                if (extractkeyworddata("MATCHTYPE", line, '=') != "NOTFOUND")
                {
                    MatchType = extractkeyworddata("MATCHTYPE", line, '=');                   
                }

                if (extractkeyworddata("GROUP", line, '=') != "NOTFOUND")
                {
                    Group = extractkeyworddata("GROUP", line, '=');
                }

                if (extractkeyworddata("RECORDTYPE", line, '=') != "NOTFOUND")
                {
                    RecordType = extractkeyworddata("RECORDTYPE", line, '=');
                }

                if (extractkeyworddata("ACTION", line, '=') != "NOTFOUND")
                {
                    Action = extractkeyworddata("ACTION", line, '=');
                }

                if (extractkeyworddata("EXCLUDE", line, '=') != "NOTFOUND")
                {
                    Exclude = extractkeyworddata("EXCLUDE", line, '=');
                }

                if (extractkeyworddata("FOUND", line, '=') != "NOTFOUND")
                {
                    Found = extractkeyworddata("FOUND", line, '=');
                }

                if (extractkeyworddata("PRERECORD", line, '=') != "NOTFOUND")
                {
                    PreRecord = extractkeyworddata("PRERECORD", line, '=');
                }

                if (extractkeyworddata("POSTRECORD", line, '=') != "NOTFOUND")
                {
                    PostRecord = extractkeyworddata("POSTRECORD", line, '=');
                }

                if (extractkeyworddata("EPISODENAME", line, '=') != "NOTFOUND")
                {
                    Episodename = extractkeyworddata("EPISODENAME", line, '=');
                }

                if (extractkeyworddata("EPISODEPART", line, '=') != "NOTFOUND")
                {
                    EpisodePart = extractkeyworddata("EPISODEPART", line, '=');
                }

                if (extractkeyworddata("EPISODENUMBER", line, '=') != "NOTFOUND")
                {
                    EpisodeNumber = extractkeyworddata("EPISODENUMBER", line, '=');
                }

                if (extractkeyworddata("SERIESNUMBER", line, '=') != "NOTFOUND")
                {
                    SeriesNumber = extractkeyworddata("SERIESNUMBER", line, '=');
                }

                if (extractkeyworddata("KEEPEPISODES", line, '=') != "NOTFOUND")
                {
                    KeepEpisodes = extractkeyworddata("KEEPEPISODES", line, '=');
                }

                if (extractkeyworddata("KEEPUNTIL", line, '=') != "NOTFOUND")
                {
                    KeepUntil = extractkeyworddata("KEEPUNTIL", line, '=');
                }

                if (extractkeyworddata("RECOMMENDEDCARD", line, '=') != "NOTFOUND")
                {
                    RecommendedCard = extractkeyworddata("RECOMMENDEDCARD", line, '=');
                }

                if (extractkeyworddata("PRIORITY", line, '=') != "NOTFOUND")
                {
                    Priority = extractkeyworddata("PRIORITY", line, '=');
                }
                

            }

            //read settings
            setting = layer.GetSetting("TvWishList_ListView", "");
            string listviewdata = setting.Value;

            setting = layer.GetSetting("TvWishList_ColumnSeparator", ";");
            TV_WISH_COLUMN_SEPARATOR = setting.Value[0];

            string[] rowdata = listviewdata.Split('\n');
            string[] columns = rowdata[0].Split(TV_WISH_COLUMN_SEPARATOR);
            bool foundflag = false;

            

            LogDebug("tvwishlist listviewdata before processing =" + listviewdata, (int)LogSetting.DEBUG);
            
            //process operation
            try
            {
                switch (operation)
                {

                    case (int)Scheduleoperation.TVWISH_ADD:
                        if (listviewdata.Length >= 1)
                        {
                            if ((listviewdata[listviewdata.Length - 1] != '\n') && (rowdata.Length > 0))
                            {
                                listviewdata += "\n";
                            }
                        }
                        string newrow = Active + TV_WISH_COLUMN_SEPARATOR + name + TV_WISH_COLUMN_SEPARATOR + MatchType + TV_WISH_COLUMN_SEPARATOR + Group + TV_WISH_COLUMN_SEPARATOR + RecordType + TV_WISH_COLUMN_SEPARATOR + Action + TV_WISH_COLUMN_SEPARATOR + Exclude + TV_WISH_COLUMN_SEPARATOR;
                        newrow += Found + TV_WISH_COLUMN_SEPARATOR + PreRecord + TV_WISH_COLUMN_SEPARATOR + PostRecord + TV_WISH_COLUMN_SEPARATOR + Episodename + TV_WISH_COLUMN_SEPARATOR + EpisodePart + TV_WISH_COLUMN_SEPARATOR + EpisodeNumber + TV_WISH_COLUMN_SEPARATOR;
                        newrow += SeriesNumber + TV_WISH_COLUMN_SEPARATOR + KeepEpisodes + TV_WISH_COLUMN_SEPARATOR + KeepUntil + TV_WISH_COLUMN_SEPARATOR + RecommendedCard + TV_WISH_COLUMN_SEPARATOR + Priority;
                        newrow = checkrowentry(newrow, (int)LogSetting.ADDRESPONSE);

                        listviewdata += newrow;
                        LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                        LogDebug("TvWishList ADD: ", (int)LogSetting.ADDRESPONSE);
                        LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                        columns = newrow.Split(TV_WISH_COLUMN_SEPARATOR);
                        OutputColumns(columns, (int)LogSetting.ADDRESPONSE);
                        break;

                    case (int)Scheduleoperation.TVWISH_DELETE:
                        listviewdata = "";
                        foreach (string row in rowdata)
                        {
                            columns = row.Split(TV_WISH_COLUMN_SEPARATOR);
                            if (columns.Length < 6)
                            {
                                LogDebug("Invalid row format - ignoring row=" + row, (int)LogSetting.DEBUG);
                                continue;
                            }

                            
                            if (name == "*DELETEALL*")
                            {
                                foundflag = true;
                                LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                                LogDebug("TvWishList DELETE ALL: ", (int)LogSetting.ADDRESPONSE);
                                LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                                OutputColumns(columns, (int)LogSetting.ADDRESPONSE);
                            }
                            else if (name.ToUpper() != columns[1].ToUpper()) //Must not Match name
                            {
                                listviewdata += row + "\n";
                            }
                            else //Deleted from listviewdata
                            {
                                foundflag = true;
                                LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                                LogDebug("TvWishList DELETE: ", (int)LogSetting.ADDRESPONSE);
                                LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                                OutputColumns(columns, (int)LogSetting.ADDRESPONSE);
                            }
                        }
                        if (foundflag == false)
                        {
                            LogDebug("Error for TvWishList DELETE: Could not find Search for="+name, (int)LogSetting.ADDRESPONSE);
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                        }

                        break;

                    case (int)Scheduleoperation.TVWISH_EDIT:
                        int i = 0;
                        foreach (string row in rowdata)
                        {
                            columns = row.Split(TV_WISH_COLUMN_SEPARATOR);
                            if (columns.Length < 6)
                            {
                                LogDebug("Invalid row format - ignoring row=" + row, (int)LogSetting.DEBUG);
                                continue;
                            }
                            if (name.ToUpper() == columns[1].ToUpper()) //Match name
                            {
                                foundflag = true;
                                rowdata[i] = "";
                                
                                if (Active != "NOTFOUND")
                                {
                                    rowdata[i] += Active;
                                }
                                else
                                {
                                    rowdata[i] += columns[0];
                                }

                                if (SearchFor != "NOTFOUND")
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + SearchFor;
                                }
                                else if (columns.Length > 1)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[1];
                                }

                                if (MatchType != "NOTFOUND")
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + MatchType;
                                }
                                else if (columns.Length > 2)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[2];
                                }
                                
                                if (Group != "NOTFOUND")
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + Group;
                                }
                                else if (columns.Length > 3)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[3];
                                }
                                
                                if (RecordType != "NOTFOUND")
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + RecordType;
                                }
                                else if (columns.Length > 4)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[4];
                                }
                                
                                if (Action != "NOTFOUND")
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + Action;
                                }
                                else if (columns.Length > 5)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[5];
                                }
                        
                                if ((Exclude != "NOTFOUND") && (columns.Length > 6))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + Exclude;
                                }
                                else if (columns.Length > 6)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[6];
                                }

                                if ((Found != "NOTFOUND") && (columns.Length > 7))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + Found;
                                }
                                else if (columns.Length > 7)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[7];
                                }

                                if ((PreRecord != "NOTFOUND") && (columns.Length > 8))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + PreRecord;
                                }
                                else if (columns.Length > 8)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[8];
                                }

                                if ((PostRecord != "NOTFOUND") && (columns.Length > 9))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + PostRecord;
                                }
                                else if (columns.Length > 9)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[9];
                                }

                                if ((Episodename != "NOTFOUND") && (columns.Length > 10))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + Episodename;
                                }
                                else if (columns.Length > 10)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[10];
                                }

                                if ((EpisodePart != "NOTFOUND") && (columns.Length > 11))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + EpisodePart;
                                }
                                else if (columns.Length > 11)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[11];
                                }

                                if ((EpisodeNumber != "NOTFOUND") && (columns.Length > 12))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + EpisodeNumber;
                                }
                                else if (columns.Length > 12)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[12];
                                }

                                if ((SeriesNumber != "NOTFOUND") && (columns.Length > 13))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + SeriesNumber;
                                }
                                else if (columns.Length > 13)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[13];
                                }

                                if ((KeepEpisodes != "NOTFOUND") && (columns.Length > 14))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + KeepEpisodes;
                                }
                                else if (columns.Length > 14)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[14];
                                }

                                if ((KeepUntil != "NOTFOUND") && (columns.Length > 15))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + KeepUntil;
                                    LogDebug("debug  KeepUntil if=" + rowdata[i], (int)LogSetting.DEBUG);
                                }
                                else if (columns.Length > 15)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[15];
                                    LogDebug("debug  KeepUntil elseif=" + rowdata[i], (int)LogSetting.DEBUG);
                                }

                                if ((RecommendedCard != "NOTFOUND") && (columns.Length > 16))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + RecommendedCard;
                                }
                                else if (columns.Length > 16)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[16];
                                }

                                if ((Priority != "NOTFOUND") && (columns.Length > 17))
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + Priority;
                                }
                                else if (columns.Length > 17)
                                {
                                    rowdata[i] += TV_WISH_COLUMN_SEPARATOR + columns[17];
                                }

                                rowdata[i] = checkrowentry(rowdata[i], (int)LogSetting.ADDRESPONSE);

                                rowdata[i] += "\n";


                                columns = rowdata[i].Split(TV_WISH_COLUMN_SEPARATOR);
                                LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                                LogDebug("TvWishList EDIT: ", (int)LogSetting.ADDRESPONSE);
                                LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                                OutputColumns(columns, (int)LogSetting.ADDRESPONSE);
                            }
                            i++;
                        }
                        if (foundflag == false)
                        {
                            LogDebug("Error for TvWishList EDIT: Could not find Search for=" + name, (int)LogSetting.ADDRESPONSE);
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                        }
                        listviewdata = "";
                        for (i = 0; i < rowdata.Length; i++)
                        {
                            listviewdata += rowdata[i] + "\n";
                        }
                        break;

                    case (int)Scheduleoperation.TVWISH_LIST:
                        LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                        LogDebug("TvWishList listing of all search entries: ", (int)LogSetting.ADDRESPONSE);
                        LogDebug("****************************************", (int)LogSetting.ADDRESPONSE);
                        foreach (string row in rowdata)
                        {
                            columns = row.Split(TV_WISH_COLUMN_SEPARATOR);
                            if (columns.Length < 6)
                            {
                                LogDebug("Invalid row format - ignoring row=" + row, (int)LogSetting.DEBUG);
                                continue;
                            }
                            OutputColumns(columns, (int)LogSetting.ADDRESPONSE);
                        }

                        break;

                }
            }
            catch (Exception exc)
            {
                LogDebug("tvwishlist exception during processing - message is" + exc.Message, (int)LogSetting.ERROR);
                return false;
            }


            //listview data
            if (listviewdata.Length >= 1)
            {
                if (listviewdata[listviewdata.Length - 1] == '\n')
                {
                    listviewdata = listviewdata.Substring(0, listviewdata.Length - 1);  //remove last "\n" if available
                }
            }
            setting = layer.GetSetting("TvWishList_ListView", "");
            setting.Value = listviewdata;
            setting.Persist();
            LogDebug("tvwishlist listviewdata after processing =" + listviewdata, (int)LogSetting.DEBUG);


            return true;
        }

        //-------------------------------------------------------------------------------------------------------------        
        //outputs listing of all columns to logfile or email
        //-------------------------------------------------------------------------------------------------------------                      
        public void OutputColumns(string[] columns, int number)
        {
            LogDebug("Name=" + columns[1], number);
            LogDebug("Active=" + columns[0], number);
            LogDebug("MatchType=" + columns[2], number);
            LogDebug("Group=" + columns[3], number);
            LogDebug("RecordType=" + columns[4], number);
            LogDebug("Action=" + columns[5], number);
            try
            {
                LogDebug("Exclude=" + columns[6], number);
            }
            catch //do nothing
            {
            }
            try
            {
                LogDebug("Found=" + columns[7], number);
                LogDebug("PreRecord=" + columns[8], number);
                LogDebug("PostRecord=" + columns[9], number);
                LogDebug("Episodename=" + columns[10], number);
                LogDebug("EpisodePart=" + columns[11], number);
                LogDebug("EpisodeNumber=" + columns[12], number);
                LogDebug("SeriesNumber=" + columns[13], number);
                LogDebug("KeepEpisodes=" + columns[14], number);
                LogDebug("KeepUntil=" + columns[15], number);
                LogDebug("RecommendedCard=" + columns[16], number);
                LogDebug("Priority=" + columns[17], number);
            }
            catch //do nothing
            {
            }
            LogDebug("", (int)LogSetting.ADDRESPONSE);
        }


        //-------------------------------------------------------------------------------------------------------------        
        //remove all tags for parsing html mails
        //-------------------------------------------------------------------------------------------------------------                
        public bool removetags(ref string text)
        {
            string newline = "";
            bool stringcopy = true;
            bool has_changed = false;
            for (int i = 0; i < text.Length; i++)
            {
                if (text[i] == '<')
                {
                    stringcopy = false;
                    has_changed = true;
                }
                if (stringcopy == true)
                {
                    newline += text[i].ToString();
                }
                if (text[i] == '>')
                {
                    stringcopy = true;
                }
            }
            text = newline;
            return has_changed;
        }


        //-------------------------------------------------------------------------------------------------------------        
        //read latest marked email from file 
        //-------------------------------------------------------------------------------------------------------------                
        public bool read_marked_emails() 
        {
            //initialization
            OLD_SERVER_MESSAGE_ERROR = 0; 
            OldProcessedEmail = "";


            string username = _TextBoxUserName.Replace('@', '.');
	        string fileName=TV_USER_FOLDER+@"\EmailScheduler\Mailsprocessed."+username+".txt";
            LogDebug("read_marked_emails: file="+fileName, (int)LogSetting.DEBUG);

            try
            {
                if (System.IO.File.Exists(fileName) == true)
                {
                    System.IO.StreamReader sr = new System.IO.StreamReader(fileName);
                    string mailText = sr.ReadToEnd();
                    sr.Close();
		            string[] lines=mailText.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
                    //LogDebug("lines.Length=" + lines.Length, (int)LogSetting.DEBUG);
                    
                    if (lines.Length > 0)
                    {
                        OLD_SERVER_MESSAGE_ERROR = Convert.ToInt32(lines[0]);
                        LogDebug("OLD_SERVER_MESSAGE_ERROR=" + lines[0], (int)LogSetting.DEBUG);
                    }

                    if (lines.Length > 1)
                    {
                        OldProcessedEmail = lines[1];
                        LogDebug("OldProcessedEmail=" + lines[1], (int)LogSetting.DEBUG);
                    }        
                }
            }
            catch (Exception ee)
            {
                        LogDebug("Error in reading the file " + fileName, (int)LogSetting.ERROR);
                        LogDebug("Exception message is " + ee.Message, (int)LogSetting.ERROR);
                        return false;   
            }
	        return true;

        }


        //-------------------------------------------------------------------------------------------------------------        
        //write latest marked emails to File
        //-------------------------------------------------------------------------------------------------------------                
        public bool write_marked_emails()
        {	        
            string username = _TextBoxUserName.Replace('@', '.');
            string fileName = TV_USER_FOLDER + @"\EmailScheduler\Mailsprocessed." + username + ".txt";
            LogDebug("write_marked_emails: file=" + fileName, (int)LogSetting.DEBUG);
	        try
            {
                string text=OLD_SERVER_MESSAGE_ERROR.ToString()+"\n";

                if (LastProcessedEmailNumber > 0)
                {
                    text += LastProcessedEmail + "\n";
                    
                }
                LogDebug("Writing Lines" + text, (int)LogSetting.DEBUG);

                byte[] buffer = Encoding.ASCII.GetBytes(text);       
                System.IO.FileStream fs = new System.IO.FileStream(fileName, System.IO.FileMode.Create);
                fs.Write(buffer, 0, buffer.Length);
                fs.WriteByte(13);
                fs.WriteByte(10);
                fs.Close();
            }
            catch (Exception ee)
            {
                LogDebug("Error in writing file  "+fileName, (int)LogSetting.ERROR);
                LogDebug("Exception message is " + ee.Message, (int)LogSetting.ERRORONLY);
                return false;
            }
	        return true;
        }


        //-------------------------------------------------------------------------------------------------------------        
        // parse the partial email for schedule adding and process new schedules
        //-------------------------------------------------------------------------------------------------------------                
        public bool addschedule(string programName, string partialemail, int number,bool partialprogramname, bool allpartialprograms)
        {
            LogDebug(partialemail, (int)LogSetting.ADDRESPONSE);

            if (_checkBoxAllowRecord == false)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Recording schedules not allowed by Tv server settings - will skip schedule ", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }

            int actualprerecord = DEFAULT_PRERECORD;
            int actualpostrecord = DEFAULT_POSTRECORD;
            
            int scheduletype = 0;
            int priority = 0;
            int recommendedcard = 0;
            bool series = false;
            DateTime keepdate = DateTime.ParseExact("9999-01-01_00:00", "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);	//keep for ever;

	        //define schedule global variables
	        string Displayname ="NOTFOUND";
	        int idChannel = -1;
            string Groupname = "NOTFOUND";
	        DateTime startTime=DateTime.ParseExact("9999-01-01_00:00","yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);	//old date as default
	        DateTime endTime=DateTime.ParseExact("9999-01-01_00:01","yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);	//old date as default

	        string[] mail_lines = partialemail.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
            //string[] mail_lines = partialemail.Split(, StringSplitOptions.RemoveEmptyEntries);

	        //parse email

	        string parserstring="";
        	
	        foreach (string line in mail_lines)  //get keywords for new schedule
	        {
                //LogDebug("line=" + line);
                if (extractkeyworddata("CHANNELGROUP", line, '=') != "NOTFOUND")
                {
                    Groupname = extractkeyworddata("CHANNELGROUP", line, '=');
                }
		        else if (extractkeyworddata("CHANNEL",line,'=') != "NOTFOUND")
		        {
			        Displayname=extractkeyworddata("CHANNEL",line,'=');
                    idChannel = getfirstchannelid(Displayname);
		        }
                
		        else if (extractkeyworddata("START_TIME",line,'=') != "NOTFOUND")
		        {
			        parserstring=extractkeyworddata("START_TIME",line,'=');
			        try
			        {
				        startTime=DateTime.ParseExact(parserstring,"yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
			        }
			        catch
			        {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Error: could not parse date value " + parserstring + " for START_TIME", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);               
                    }
		        }
		        else if (extractkeyworddata("END_TIME",line,'=') != "NOTFOUND")
		        {
                    parserstring = extractkeyworddata("END_TIME", line, '=');
    			    try
                    {			            
				        endTime=DateTime.ParseExact(parserstring,"yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
			        }
			        catch
			        {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Error: could not parse date value " + parserstring + " for END_TIME", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);               
                    
                    }
		        }
                else if (extractkeyworddata("KEEP_DATE", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("KEEP_DATE", line, '=');
                    try
                    {
                        keepdate = DateTime.ParseExact(parserstring, "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Error: could not parse date value " + parserstring + " for KEEP_DATE", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);

                    }
                }
                else if (extractkeyworddata("SCHEDULETYPE", line, '=') != "NOTFOUND")
                {
                    if (_checkBoxAllowSeriesSchedules == true)
                    {
                        parserstring = extractkeyworddata("SCHEDULETYPE", line, '=');
                        try
                        {
                            if (parserstring.ToUpper() == "ONCE")
                            {
                                scheduletype = 0;
                            }
                            else if (parserstring.ToUpper() == "ALWAYS")
                            {
                                scheduletype = 3;
                            }
                            else if (parserstring.ToUpper() == "ALWAYSALLCHANNELS")
                            {
                                scheduletype = 4;
                            }
                            else if (parserstring.ToUpper() == "WEEKLY")
                            {
                                scheduletype = 2;
                            }
                            else if (parserstring.ToUpper() == "DAILY")
                            {
                                scheduletype = 1;
                            }
                            else if (parserstring.ToUpper() == "MON-FRI")
                            {
                                scheduletype = 6;
                            }
                            else if (parserstring.ToUpper() == "WEEKENDS")
                            {
                                scheduletype = 5;
                            }
                            else
                            {
                                LogDebug("", (int)LogSetting.ADDRESPONSE);
                                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                                LogDebug("Scheduletype " + parserstring + " not identified - will schedule only ONCE", (int)LogSetting.ADDRESPONSE);
                                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                                scheduletype = 0;
                            }
                        }
                        catch
                        {
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                            LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                            LogDebug("Error: Could not parse " + parserstring + " for SCHEDULETYPE", (int)LogSetting.ADDRESPONSE);
                            LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);

                        }
                    }
                    else
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Series scheduletype is not allowed by TV server settings - will schedule only ONCE", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        scheduletype = 0;
                    }
                }
                else if (extractkeyworddata("PRERECORD", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("PRERECORD", line, '=');
                    try
                    {
                        actualprerecord = Int32.Parse(parserstring);                        
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Could not parse " + parserstring + " for PRERECORD", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    }
                }
                else if (extractkeyworddata("POSTRECORD", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("POSTRECORD", line, '=');
                    try
                    {
                        actualpostrecord = Int32.Parse(parserstring);
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Could not parse" + parserstring + " for POSTRECORD", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    }
                }
                else if (extractkeyworddata("PRIORITY", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("PRIORITY", line, '=');
                    try
                    {
                        priority = Int32.Parse(parserstring);
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Could not parse " + parserstring + " for PRIORITY", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    }
                }

                /* not used
		        else if (extractkeyworddata("QUALITY",line,'=') != "NOTFOUND")
		        {
			        parserstring=extractkeyworddata("QUALITY",line,'=');
			        try
			        {
				        schedule.Quality=Int32.Parse(parserstring);
			        }
			        catch
			        {
				        LogDebug("\nError: could not parse date value "+parserstring+" for QUALITY in line "+number.ToString()+"\n\n");
			        }
		        }
		        //Directory not allowed for security reasons
		        else if (extractkeyworddata("KEEPMETHOD",line,'=') != "NOTFOUND")
		        {
			        parserstring=extractkeyworddata("KEEPMETHOD",line,'=');
			        try
			        {
				        schedule.KeepMethod=Int32.Parse(parserstring);
			        }
			        catch
			        {
				        LogDebug("\nError: could not parse date value "+parserstring+" for KEEPMETHOD in line "+number.ToString()+"\n\n");
			        }
		        }
		        else if (extractkeyworddata("MAXAIRINGS",line,'=') != "NOTFOUND")
		        {
			        parserstring=extractkeyworddata("MAXAIRINGS",line,'=');
			        try
			        {
				        schedule.MaxAirings=Int32.Parse(parserstring);
			        }
			        catch
			        {
				        LogDebug("\nError: could not parse date value "+parserstring+" for MAXAIRINGS in line "+number.ToString()+"\n\n");
			        }
		        }*/
                else if (extractkeyworddata("RECOMMENDEDCARD", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("RECOMMENDEDCARD", line, '=');
                    try
                    {
                        recommendedcard = Int32.Parse(parserstring);
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Could not parse " + parserstring + " for RECOMMENDEDCARD", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    }
                }
                else if (extractkeyworddata("SERIES", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("SERIES", line, '=');
                    try
                    {
                        if ((parserstring.ToUpper() == "YES") || (parserstring.ToUpper() == "TRUE"))
                        {
                            series = true;
                        }
                        else
                        {
                            series = false;
                        }
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Could not parse date value " + parserstring + " for SERIES", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    }
                }
                else if (extractkeyworddata("USESCHEDULENAME", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("USESCHEDULENAME", line, '=');
                    try
                    {
                        if ((parserstring.ToUpper() == "YES") || (parserstring.ToUpper() == "TRUE"))
                        {
                            UseScheduleName = true;
                        }
                        else
                        {
                            UseScheduleName = false;
                        }
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Could not parse date value " + parserstring + " for UseScheduleName", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    }
                }
        		                              
                                        
	        }//end parsing keywords
            


            //manual recording
            if ((programName == "NOTFOUND") || (programName == ""))
            {
                programName = "Manual_" + Displayname + "_" + startTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                LogDebug("Changing program name to " + programName, (int)LogSetting.DEBUG);
                idChannel = getfirstchannelid(Displayname);
                if (idChannel == -1)
                {
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Error: Channel Display name " + Displayname + " could not be assigned", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    return false;
                }

                if ((startTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) == "9999-01-01_00:00") || (endTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) == "9999-01-01_00:01"))
                { //autocomplete start, end
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Error: Manual Recording does not have valid start time " + startTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) + " or end time" + endTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    return false;
                }
            }

            // try autocompletion
            //check for valid data of program name, channel start time and end time
            if ((programName == "NOTFOUND") || (programName == "") || (idChannel == -1) || (startTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) == "9999-01-01_00:00") || (endTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) == "9999-01-01_00:01"))
            {

                LogDebug("Trying autocompletion", (int)LogSetting.DEBUG);

                bool exact_time_match=true;
                bool ok = autocomplete(ref programName, ref Displayname, ref idChannel, Groupname, ref startTime, ref endTime, partialprogramname, exact_time_match);
                if (ok == false)
                { // no program data found
                    LogDebug("Autocompletion failed", (int)LogSetting.DEBUG);
                }
                else //autocomplete found programs in EPG data
                {

                    int allprogramctr = matchingprograms.Count;
                    int totalschedules = matchingprograms.Count; // store total number of matching schedules
                    int schedulecounter = 0; // store scheduled programs

                    if (allpartialprograms == true) //add all schedules with different program names
                    {
                        
#if(MP100)
                        IList allprograms = Program.ListAll();
#elif(MP101)
                        IList<Program> allprograms = new List<Program>();
#elif(MP11 || MP12)
                        IList<Program> allprograms = new List<Program>();
#endif
                        
                        while (allprogramctr>0)
                        {
                            Program foundprogram = getfirstconflictfreeschedule(priority);

                            if (foundprogram != null) //valid Program found
                            {
                                bool okadd = addsingleschedule(foundprogram.IdChannel, foundprogram.Title, foundprogram.StartTime, foundprogram.EndTime, actualprerecord, actualpostrecord, scheduletype, priority, series, recommendedcard, keepdate);                
                                if (okadd == true)
                                {
                                    schedulecounter++;
                                }

                                // remove program name from matching schedules
                                foreach (Program program in matchingprograms)  //double build to avoid exception error
                                {
                                    allprograms.Add(program);
                                }

                                foreach (Program program in allprograms)
                                {
                                    if (program.Title == programName)
                                    {
                                        matchingprograms.Remove(program);
                                    }
                                }
                            }
                            else // no more matching schedules found
                            {
                                break;
                            }
                            allprogramctr = matchingprograms.Count;

                        }//end processing all programs
                        int conflicts = totalschedules - schedulecounter;
                        if (conflicts > 0)
                        {
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                            LogDebug(conflicts.ToString() + " Conflicts found and not scheduled", (int)LogSetting.ADDRESPONSE);
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                        }
                        

                        return true;
                    }
                    else //add only one single schedule from autocompletion
                    {
                        Program foundprogram = getfirstconflictfreeschedule(priority);
                        if (foundprogram != null)
                        {
                            bool okadd = addsingleschedule(foundprogram.IdChannel, foundprogram.Title, foundprogram.StartTime, foundprogram.EndTime, actualprerecord, actualpostrecord, scheduletype, priority, series, recommendedcard, keepdate);
                            if (okadd == false)
                            {
                                LogDebug("", (int)LogSetting.ADDRESPONSE);
                                LogDebug("!!! Schedule could not be added due to conflicts", (int)LogSetting.ADDRESPONSE);
                                LogDebug("", (int)LogSetting.ADDRESPONSE);
                            }
                            return okadd;

                        }
                        else
                        {
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                            LogDebug("!!! Schedule has not been added due to conflicts", (int)LogSetting.ADDRESPONSE);
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                            LogDebug("getfirstconflictfreeschedule failed- aborting addschedule", (int)LogSetting.DEBUG);
                            return false;
                        }
                    }

                }
            }
            else //try to add single schedule if all mandatory schedule data are defined in email
            {
                addsingleschedule(idChannel, programName, startTime, endTime, actualprerecord, actualpostrecord, scheduletype, priority, series, recommendedcard, keepdate);
            }
            return true;
        }


        //-------------------------------------------------------------------------------------------------------------        
        // get the first free schedule, which is not scheduled yet and does not cause a conflict
        //-------------------------------------------------------------------------------------------------------------
        // the rooutine will check the Ilist<Programs> matchingprograms for schedule conflicts and return the first available Program which does not cause a conflict for recording
        [CLSCompliant(false)]
        public Program getfirstconflictfreeschedule(int priority)
        {
            TvBusinessLayer layer = new TvBusinessLayer();        
            Schedule testschedule = null;

            foreach (Program foundprogram in matchingprograms)
            {
                //LogDebug("Conflict testing of program "+foundprogram.Title, (int)LogSetting.DEBUG);
                //LogDebug("Channel id " + foundprogram.IdChannel.ToString(), (int)LogSetting.DEBUG);
                //LogDebug("Start time " + foundprogram.StartTime.ToString("yyyy-MM-dd_HH:mm",CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);
                //LogDebug("End time " + foundprogram.EndTime.ToString("yyyy-MM-dd_HH:mm",CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);
                //create test schedule 
                try
                {   // do not persist test schedule anywhere! 
                    testschedule = layer.AddSchedule(foundprogram.IdChannel, "Test" + DateTime.Now.ToString("yyyy-MM-dd_HH:mm.ffff", CultureInfo.InvariantCulture), foundprogram.StartTime, foundprogram.EndTime, 0);
                }
                catch (Exception ee)
                {
                    LogDebug("Creating testschedule caused exception " + ee.Message, (int)LogSetting.ERROR);
                    return null;
                }

                //check test schedule for conflicts
                List<Schedule> conflict_schedule = GetConflictingSchedules(testschedule);
                testschedule.Delete();

                if (conflict_schedule.Count == 0) 
                {
                    LogDebug("", (int)LogSetting.DEBUG);
                    LogDebug("Program: " + foundprogram.Title + " has no conflicts ", (int)LogSetting.DEBUG);
                    LogDebug("", (int)LogSetting.DEBUG);                    
                    return foundprogram;
                }
                else if (_checkBoxAllowDelete == true)
                {//check priority and delete conflicts


                    bool delete_all_conflict_schedules = true;  //check that all conflicts have lower priority
                    foreach (Schedule oldschedule in conflict_schedule)
                    {
                        if (oldschedule.Priority >= priority)
                        {
                            delete_all_conflict_schedules = false;
                            break;
                        }
                    }


                    if (delete_all_conflict_schedules == true)
                    {
                        foreach (Schedule oldschedule in conflict_schedule) //delete all conflicting schedules
                        {
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                            LogDebug("********************************************************************************", (int)LogSetting.ADDRESPONSE);
                            LogDebug("The following schedule has been deleted from TvServer due to priority conflicts:", (int)LogSetting.ADDRESPONSE);
                            LogDebug("********************************************************************************", (int)LogSetting.ADDRESPONSE);
                            outputscheduletoresponse(oldschedule);
                            try
                            {
                                oldschedule.Delete();
                            }
                            catch (Exception exc)
                            {
                                LogDebug("", (int)LogSetting.ADDRESPONSE);
                                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                                LogDebug("Fatal Error: Deleting schedule caused exception:", (int)LogSetting.ADDRESPONSE);
                                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                                LogDebug(exc.Message, (int)LogSetting.ADDRESPONSE);
                                return null;

                            }
                        }
                        return foundprogram;
                    }
                    
                }

            }
            return null;

            
            
        }




        //-------------------------------------------------------------------------------------------------------------        
        // collects all conflicts in LIST <Schedule> conflicts and returns the list for the existing schedule
        //------------------------------------------------------------------------------------------------------------- 
        [CLSCompliant(false)]
        public List<Schedule> GetConflictingSchedules(Schedule rec)
        {
            LogDebug("GetConflictingSchedules: Schedule = " + rec.ToString(), (int)LogSetting.DEBUG);
#if(MP100)
          IList schedulesList = Schedule.ListAll();
          IList cards = Card.ListAll();
#elif(MP101)
          IList<Schedule> schedulesList = Schedule.ListAll();
          IList<Card> cards = Card.ListAll();
#elif(MP11 || MP12)
            IList<Schedule> schedulesList = Schedule.ListAll();
            IList<Card> cards = Card.ListAll();
#endif

            List<Schedule> conflicts = new List<Schedule>();

            if (cards.Count == 0)
            {
                return conflicts;
            }
            //LogDebug("GetConflictingSchedules: Cards.Count =" + cards.Count.ToString(), (int)LogSetting.DEBUG);

            List<Schedule>[] cardSchedules = new List<Schedule>[cards.Count];
            for (int i = 0; i < cards.Count; i++)
            {
                cardSchedules[i] = new List<Schedule>();
            }

            // GEMX: Assign all already scheduled timers to cards. Assume that even possibly overlapping schedulues are ok to the user,
            // as he decided to keep them before. That's why they are in the db
            foreach (Schedule schedule in schedulesList)
            {

                //huha change bugfix
                if (schedule == rec)
                {
                    continue;
                }
                //end huha bugfix

                List<Schedule> episodes = GetRecordingTimes(schedule);
                foreach (Schedule episode in episodes)
                {
                    if (DateTime.Now > episode.EndTime)
                    {
                        continue;
                    }
                    if (episode.IsSerieIsCanceled(episode.StartTime))
                    {
                        continue;
                    }
                    Schedule overlapping;
                    AssignSchedulesToCard(episode, cardSchedules, out overlapping, DEBUG);
                }
            }

            List<Schedule> newEpisodes = GetRecordingTimes(rec);
            foreach (Schedule newEpisode in newEpisodes)
            {
                if (DateTime.Now > newEpisode.EndTime)
                {
                    continue;
                }
                if (newEpisode.IsSerieIsCanceled(newEpisode.StartTime))
                {
                    continue;
                }
                Schedule overlapping = null;
                if (!AssignSchedulesToCard(newEpisode, cardSchedules, out overlapping, DEBUG))
                {
                    LogDebug("GetConflictingSchedules: newEpisode can not be assigned to a card = " + newEpisode.ToString(), (int)LogSetting.DEBUG);
                    if (overlapping != null)
                    {
                        LogDebug("Overlapping schedule is:", (int)LogSetting.DEBUG);
                        outputscheduletoresponse(overlapping);
                    }
                    else
                    {
                        LogDebug("Overlapping schedule is not defined", (int)LogSetting.DEBUG);
                    }
                    conflicts.Add(overlapping);
                }


            }
            return conflicts;
        }


        //-------------------------------------------------------------------------------------------------------------        
        // assigns a single schedule to the card
        //------------------------------------------------------------------------------------------------------------- 
        private static bool AssignSchedulesToCard(Schedule schedule, List<Schedule>[] cardSchedules, out Schedule overlappingSchedule, bool Debug)
        {
            overlappingSchedule = null;
            //if (Debug==true)
            //    Log.Debug("AssignSchedulesToCard: schedule = " + schedule.ToString());


#if(MP100)
          IList cards = Card.ListAll();
#elif(MP101)
          IList<Card> cards = Card.ListAll();
#elif(MP11 || MP12)
            IList<Card> cards = Card.ListAll();
#endif

            bool assigned = false;
            int count = 0;
            foreach (Card card in cards)
            {
                //if (Debug == true)
                //  Log.Debug("Working on card: "+card.IdCard.ToString()+" ID Channel="+schedule.IdChannel.ToString());
                if (card.canViewTvChannel(schedule.IdChannel))
                {
                    // checks if any schedule assigned to this cards overlaps current parsed schedule
                    bool free = true;
                    // if (Debug == true)
                    //   Log.Debug("card can view channel - free=true");
                    foreach (Schedule assignedSchedule in cardSchedules[count])
                    {
                        //if (Debug == true)
                        //    Log.Debug("AssignSchedulesToCard: card {0}, ID = {1} has schedule = " + assignedSchedule, count, card.IdCard);
                        if (schedule.IsOverlapping(assignedSchedule))
                        {
                            //if (Debug == true)
                            //    Log.Debug("schedule is overlapping - checking same transponder");

                            if (!(schedule.isSameTransponder(assignedSchedule) && card.supportSubChannels))
                            {
                                overlappingSchedule = assignedSchedule;
                                if (Debug == true)
                                    Log.Debug("AssignSchedulesToCard: overlapping with " + assignedSchedule + " on card {0}, ID = {1}", card.IdCard);
                                free = false;
                                break;
                            }

                        }
                    }
                    if (free)
                    {
                        if (Debug == true)
                            Log.Debug("AssignSchedulesToCard: free on card " + count.ToString() + ", ID = " + card.IdCard.ToString());
                        cardSchedules[count].Add(schedule);
                        assigned = true;
                        break;
                    }
                }
                count++;
            }
            if (!assigned)
            {
                return false;
            }

            return true;
        }

        [CLSCompliant(false)]
        //-------------------------------------------------------------------------------------------------------------        
        // gets the recording time of a schedule
        //------------------------------------------------------------------------------------------------------------- 
        public List<Schedule> GetRecordingTimes(Schedule rec)
        {
            return GetRecordingTimes(rec, 10);
        }


        [CLSCompliant(false)]
        //-------------------------------------------------------------------------------------------------------------        
        // gets the recording time of a schedule
        //-------------------------------------------------------------------------------------------------------------
        public List<Schedule> GetRecordingTimes(Schedule rec, int days)
        {
            TvBusinessLayer layer = new TvBusinessLayer();
            List<Schedule> recordings = new List<Schedule>();

            DateTime dtDay = DateTime.Now;
            if (rec.ScheduleType == (int)ScheduleRecordingType.Once)
            {
                recordings.Add(rec);
                return recordings;
            }

            if (rec.ScheduleType == (int)ScheduleRecordingType.Daily)
            {
                for (int i = 0; i < days; ++i)
                {
                    Schedule recNew = rec.Clone();
                    recNew.ScheduleType = (int)ScheduleRecordingType.Once;
                    recNew.StartTime = new DateTime(dtDay.Year, dtDay.Month, dtDay.Day, rec.StartTime.Hour, rec.StartTime.Minute,
                                                    0);
                    if (rec.EndTime.Day > rec.StartTime.Day)
                    {
                        dtDay = dtDay.AddDays(1);
                    }
                    recNew.EndTime = new DateTime(dtDay.Year, dtDay.Month, dtDay.Day, rec.EndTime.Hour, rec.EndTime.Minute, 0);
                    if (rec.EndTime.Day > rec.StartTime.Day)
                    {
                        dtDay = dtDay.AddDays(-1);
                    }
                    recNew.Series = true;
                    if (recNew.StartTime >= DateTime.Now)
                    {
                        if (rec.IsSerieIsCanceled(recNew.StartTime))
                        {
                            recNew.Canceled = recNew.StartTime;
                        }
                        recordings.Add(recNew);
                    }
                    dtDay = dtDay.AddDays(1);
                }
                return recordings;
            }

            if (rec.ScheduleType == (int)ScheduleRecordingType.WorkingDays)
            {

#if(MP100 || MP101 || MP12)
                for (int i = 0; i < days; ++i)
              {
                  if (dtDay.DayOfWeek != DayOfWeek.Saturday && dtDay.DayOfWeek != DayOfWeek.Sunday)
          
#elif(MP11)
                WeekEndTool weekEndTool = Setting.GetWeekEndTool();
                for (int i = 0; i < days; ++i)
                {
                    if (weekEndTool.IsWorkingDay(dtDay.DayOfWeek))
#endif


                    {
                        Schedule recNew = rec.Clone();
                        recNew.ScheduleType = (int)ScheduleRecordingType.Once;
                        recNew.StartTime = new DateTime(dtDay.Year, dtDay.Month, dtDay.Day, rec.StartTime.Hour, rec.StartTime.Minute,
                                                        0);
                        if (rec.EndTime.Day > rec.StartTime.Day)
                        {
                            dtDay = dtDay.AddDays(1);
                        }
                        recNew.EndTime = new DateTime(dtDay.Year, dtDay.Month, dtDay.Day, rec.EndTime.Hour, rec.EndTime.Minute, 0);
                        if (rec.EndTime.Day > rec.StartTime.Day)
                        {
                            dtDay = dtDay.AddDays(-1);
                        }
                        recNew.Series = true;
                        if (rec.IsSerieIsCanceled(recNew.StartTime))
                        {
                            recNew.Canceled = recNew.StartTime;
                        }
                        if (recNew.StartTime >= DateTime.Now)
                        {
                            recordings.Add(recNew);
                        }
                    }
                    dtDay = dtDay.AddDays(1);
                }
                return recordings;
            }

            if (rec.ScheduleType == (int)ScheduleRecordingType.Weekends)
            {
#if(MP100 || MP101)
              IList progList = layer.SearchMinimalPrograms(dtDay, dtDay.AddDays(days), rec.ProgramName,rec.ReferencedChannel());
              foreach (Program prog in progList)
              {
                  if ((rec.IsRecordingProgram(prog, false)) &&
                      (prog.StartTime.DayOfWeek == DayOfWeek.Saturday || prog.StartTime.DayOfWeek == DayOfWeek.Sunday))

#elif(MP12)
              IList<Program> progList = layer.SearchMinimalPrograms(dtDay, dtDay.AddDays(days), rec.ProgramName,rec.ReferencedChannel());
              foreach (Program prog in progList)
              {
                  if ((rec.IsRecordingProgram(prog, false)) &&
                      (prog.StartTime.DayOfWeek == DayOfWeek.Saturday || prog.StartTime.DayOfWeek == DayOfWeek.Sunday))

#elif(MP11)
                IList<Program> progList = layer.SearchMinimalPrograms(dtDay, dtDay.AddDays(days), rec.ProgramName, rec.ReferencedChannel());
                WeekEndTool weekEndTool = Setting.GetWeekEndTool();
                foreach (Program prog in progList)
                {
                    if ((rec.IsRecordingProgram(prog, false)) &&
                        (weekEndTool.IsWeekend(prog.StartTime.DayOfWeek)))
#endif



                    {
                        Schedule recNew = rec.Clone();
                        recNew.ScheduleType = (int)ScheduleRecordingType.Once;
                        recNew.StartTime = prog.StartTime;
                        recNew.EndTime = prog.EndTime;
                        recNew.Series = true;

                        if (rec.IsSerieIsCanceled(recNew.StartTime))
                        {
                            recNew.Canceled = recNew.StartTime;
                        }
                        recordings.Add(recNew);
                    }
                }
                return recordings;







            }
            if (rec.ScheduleType == (int)ScheduleRecordingType.Weekly)
            {
                for (int i = 0; i < days; ++i)
                {
                    if ((dtDay.DayOfWeek == rec.StartTime.DayOfWeek) && (dtDay.Date >= rec.StartTime.Date))
                    {
                        Schedule recNew = rec.Clone();
                        recNew.ScheduleType = (int)ScheduleRecordingType.Once;
                        recNew.StartTime = new DateTime(dtDay.Year, dtDay.Month, dtDay.Day, rec.StartTime.Hour, rec.StartTime.Minute,
                                                        0);
                        if (rec.EndTime.Day > rec.StartTime.Day)
                        {
                            dtDay = dtDay.AddDays(1);
                        }
                        recNew.EndTime = new DateTime(dtDay.Year, dtDay.Month, dtDay.Day, rec.EndTime.Hour, rec.EndTime.Minute, 0);
                        if (rec.EndTime.Day > rec.StartTime.Day)
                        {
                            dtDay = dtDay.AddDays(-1);
                        }
                        recNew.Series = true;
                        if (rec.IsSerieIsCanceled(recNew.StartTime))
                        {
                            recNew.Canceled = recNew.StartTime;
                        }
                        if (recNew.StartTime >= DateTime.Now)
                        {
                            recordings.Add(recNew);
                        }
                    }
                    dtDay = dtDay.AddDays(1);
                }
                return recordings;
            }

#if(MP100)
          IList programs = rec.ScheduleType == (int)ScheduleRecordingType.EveryTimeOnThisChannel
                                      ? layer.SearchMinimalPrograms(dtDay, dtDay.AddDays(days), rec.ProgramName,
                                                                    rec.ReferencedChannel())
                                      : layer.SearchMinimalPrograms(dtDay, dtDay.AddDays(days), rec.ProgramName, null);
#elif(MP101)
          IList<Program> programs = rec.ScheduleType == (int)ScheduleRecordingType.EveryTimeOnThisChannel
                                      ? layer.SearchMinimalPrograms(dtDay, dtDay.AddDays(days), rec.ProgramName,
                                                                    rec.ReferencedChannel())
                                      : layer.SearchMinimalPrograms(dtDay, dtDay.AddDays(days), rec.ProgramName, null);
#elif(MP11 || MP12)
            IList<Program> programs = rec.ScheduleType == (int)ScheduleRecordingType.EveryTimeOnThisChannel
                                        ? layer.SearchMinimalPrograms(dtDay, dtDay.AddDays(days), rec.ProgramName,
                                                                      rec.ReferencedChannel())
                                        : layer.SearchMinimalPrograms(dtDay, dtDay.AddDays(days), rec.ProgramName, null);
#endif

            foreach (Program prog in programs)
            {
                if (rec.IsRecordingProgram(prog, false))
                {
                    Schedule recNew = rec.Clone();
                    recNew.ScheduleType = (int)ScheduleRecordingType.Once;
                    recNew.IdChannel = prog.IdChannel;
                    recNew.StartTime = prog.StartTime;
                    recNew.EndTime = prog.EndTime;
                    recNew.Series = true;
                    if (rec.IsSerieIsCanceled(recNew.StartTime))
                    {
                        recNew.Canceled = recNew.StartTime;
                    }
                    recordings.Add(recNew);
                }
            }
            return recordings;
        }


        /// <summary>
        /// Adds or updates an attribute of the xml file
        /// </summary>
        /// <param name="XmlNode node">xml node</param>
        /// <param name="string tagName">attribute name</param>
        /// <param name="string tagValue">attribute valuee</param>
        public void AddAttribute(XmlNode node, string tagName, string tagValue)
        {
            XmlAttribute attr = node.OwnerDocument.CreateAttribute(tagName);
            attr.InnerText = tagValue;
            node.Attributes.Append(attr);
        }

        //-------------------------------------------------------------------------------------------------------------
        //schedule new single schedule with the parameters
        //-------------------------------------------------------------------------------------------------------------
        public bool addsingleschedule(int idChannel, string programName, DateTime startTime, DateTime endTime, int actualprerecord, int actualpostrecord, int scheduletype, int priority, bool series, int recommendedcard, DateTime keepdate)
        {

            TvBusinessLayer layer = new TvBusinessLayer();
            Setting setting;
            int schedulecount_before = 0;
            int schedulecount_after = 0;


#if(MP100)
            IList allschedules = Schedule.ListAll();
#elif(MP101)
            IList<Schedule> allschedules = Schedule.ListAll();
#elif(MP11 || MP12)
            IList<Schedule> allschedules = Schedule.ListAll();
#endif
            schedulecount_before = allschedules.Count; //remember total schedule count before adding new schedule


            // add new schedule
            Schedule schedule = null;
            try
            {
                schedule = layer.AddSchedule(idChannel, programName, startTime, endTime, 0);
                schedule.PreRecordInterval = actualprerecord;
                schedule.PostRecordInterval = actualpostrecord;
                schedule.ScheduleType = scheduletype;
                schedule.Priority = priority;
                schedule.Series = series;
                schedule.RecommendedCard = recommendedcard;
                schedule.KeepDate = keepdate;

                if (UseScheduleName == true)
                {
                    if (programName.Contains(@"\"))
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Failed to add folder " + programName +" because program name must not contain \" \\\"", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    }
                    else
                    {
                        //schedule.Directory = programName;

                        /*not working
#if(MP100) 
            IList allTVcards = Card.ListAll();
#elif (MP101)
            IList<Card> allTVcards = Card.ListAll();
#elif (MP11)
                        IList<Card> allTVcards = Card.ListAll();
#endif
                        schedule.Directory = allTVcards[0].RecordingFolder +"\\"+ programName; //using recording folder of first TV card 
                        if (Directory.Exists(schedule.Directory) == false)
                        {
                            try
                            {
                                Directory.CreateDirectory(schedule.Directory);
                            }
                            catch (Exception exc)
                            {
                                LogDebug("Could not create directory " + schedule.Directory, (int)LogSetting.ERROR);
                                LogDebug("Exception message was " + exc.Message, (int)LogSetting.ERROR);
                            }

                        }*/

                        //create new xml file for renaming recorded filename
                        try
                        {
                            XmlDocument xmlDoc = new XmlDocument();
                            string filename = TV_USER_FOLDER + @"\EmailScheduler\" + FileRenameXML;
                            
                            try
                            {
                                xmlDoc.Load(filename);
                            }
                            catch(System.IO.FileNotFoundException)
                            {
                                XmlTextWriter xmlWriter = new XmlTextWriter(filename, System.Text.Encoding.UTF8);
                                xmlWriter.Formatting = Formatting.Indented;
                                xmlWriter.WriteProcessingInstruction("xml", "version='1.0' encoding='UTF-8'");
                                xmlWriter.WriteStartElement("AllJobs");
                                xmlWriter.Close();
                                xmlDoc.Load(filename);
                            }

                            XmlNode alljobs = xmlDoc.DocumentElement;
                            //XmlNode alljobs = xmlDoc.SelectSingleNode("/AllJobs");
                            XmlNode node = xmlDoc.CreateElement("Job");
                            AddAttribute(node, "ScheduleName", programName);
                            Double number = Convert.ToDouble(schedule.PreRecordInterval)*(-1);
                            DateTime absoluteStartTime = startTime.AddMinutes(number);
                            AddAttribute(node, "Start", absoluteStartTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture));
                            LogDebug("Start=" + absoluteStartTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);

                            number = Convert.ToDouble(schedule.PostRecordInterval);
                            DateTime absoluteEndTime = endTime.AddMinutes(number);
                            AddAttribute(node, "End", absoluteEndTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture));
                            LogDebug("End=" + absoluteEndTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);

                            AddAttribute(node, "idChannel", idChannel.ToString());


                            alljobs.AppendChild(node);


                            xmlDoc.Save(filename);
                        }
                        catch (Exception exc)
                        {
                            LogDebug("Could not update " + TV_USER_FOLDER + @"\EmailScheduler\" + FileRenameXML, (int)LogSetting.ERROR);
                            LogDebug("Exception message was " + exc.Message, (int)LogSetting.ERROR);
                        }
                    }
                }

            }
            catch
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Failed to add program " + programName, (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;

            }

            if (schedule == null)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Failed to create schedule for program " + programName, (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }



            

            // calculate recording time

            //get latest setting for _LabelRecordingHours
            setting = layer.GetSetting("EmailScheduler_RecordingHours", "0");
            _LabelRecordingHours = Convert.ToDouble(setting.Value);

            TimeSpan difference = endTime.Subtract(startTime);
            double hours = Convert.ToDouble(difference.Hours) + Convert.ToDouble(difference.Days) * 24.0 + Convert.ToDouble(difference.Minutes) / 60.0 + Convert.ToDouble(actualprerecord) / 60.0 + Convert.ToDouble(actualpostrecord) / 60.0;
            //LogDebug("hours=" + hours.ToString(), (int)LogSetting.DEBUG);
            //LogDebug("actualpostrecord=" + actualpostrecord.ToString(), (int)LogSetting.DEBUG);
            //LogDebug("actualprerecord=" + actualprerecord.ToString(), (int)LogSetting.DEBUG);
            double floatnumber = _LabelRecordingHours + hours;

            if ((_checkBoxUseRecordingHourLimit == true) && (_numericUpDownMaxRecordingHours < floatnumber))
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Maximum number of recording hours " + _numericUpDownMaxRecordingHours.ToString() + " has been exceeded (" + floatnumber.ToString() + ") - will not schedule program " + programName, (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }

            else if ((schedule.StartTime < DateTime.Now) && (schedule.ScheduleType == 0)) //old date, but only for type "ONCE"
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Start time of program is in the past - will skip schedule", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }
            else if (startTime.CompareTo(endTime) > 0)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("End time defined before start time - will skip schedule", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }
            else //success
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("***********************************************************", (int)LogSetting.ADDRESPONSE);
                LogDebug("Success: The following schedule has been added to TvServer:", (int)LogSetting.ADDRESPONSE);
                LogDebug("***********************************************************", (int)LogSetting.ADDRESPONSE);
                schedule.Persist();

                allschedules = Schedule.ListAll();
                schedulecount_after = allschedules.Count;



                //update total recorded hours if not already scheduled
                //LogDebug("schedulecount_after =" + schedulecount_after.ToString(), (int)LogSetting.DEBUG);
                //LogDebug("schedulecount_before =" + schedulecount_before.ToString(), (int)LogSetting.DEBUG);
                if (schedulecount_after != schedulecount_before)
                {
                    setting = layer.GetSetting("EmailScheduler_RecordingHours", "0");
                    setting.Value = String.Format("{0:0.##}", floatnumber);
                    setting.Persist();
                }
                else
                {
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Schedule has been added before", (int)LogSetting.ADDRESPONSE);
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                }
            }

            outputscheduletoresponse(schedule);

            return true;
        }


        [CLSCompliant(false)]
        //-------------------------------------------------------------------------------------------------------------        
        // output a single schedule with all parameters
        //-------------------------------------------------------------------------------------------------------------               
        public void outputscheduletoresponse(Schedule schedule)
        {
            LogDebug("ProgramName=           " + schedule.ProgramName, (int)LogSetting.ADDRESPONSE);
            try
            {
                Channel channel = Channel.Retrieve(schedule.IdChannel);
                LogDebug("Channel=               " + channel.DisplayName, (int)LogSetting.ADDRESPONSE);
            }
            catch
            {
                LogDebug("Channel ID=            " + schedule.IdChannel, (int)LogSetting.ADDRESPONSE);
            }
            LogDebug("START_TIME=            " + schedule.StartTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.ADDRESPONSE);

            LogDebug("END_TIME=              " + schedule.EndTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.ADDRESPONSE);
            
            string schedtype = "";
            if (schedule.ScheduleType == 0)
                schedtype = "Once";
            else if (schedule.ScheduleType == 3)
                schedtype = "Always";
            else if (schedule.ScheduleType == 4)
                schedtype = "AlwaysAllChannels";
            else if (schedule.ScheduleType == 2)
                schedtype = "Weekly";
            else if (schedule.ScheduleType == 1)
                schedtype = "Daily";
            else if (schedule.ScheduleType == 6)
                schedtype = "Mon-Fri";
            else if (schedule.ScheduleType == 5)
                schedtype = "Weekends";
            else
                schedtype = schedule.ScheduleType.ToString();

            LogDebug("ScheduleType=          " + schedtype, (int)LogSetting.ADDRESPONSE);
            if (schedule.KeepDate.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) == "2000-01-01_00:00:00")
                LogDebug("KeepDate=              Always", (int)LogSetting.ADDRESPONSE);
            else
                LogDebug("KeepDate=              " + schedule.KeepDate.ToString(), (int)LogSetting.ADDRESPONSE);

            LogDebug("PreRecord=             " + schedule.PreRecordInterval.ToString(), (int)LogSetting.ADDRESPONSE);
            LogDebug("PostRecord=            " + schedule.PostRecordInterval.ToString(), (int)LogSetting.ADDRESPONSE);
            LogDebug("Priority=              " + schedule.Priority.ToString(), (int)LogSetting.ADDRESPONSE);
            if (schedule.RecommendedCard == -1)
                LogDebug("RecommendedCard=       Any", (int)LogSetting.ADDRESPONSE);
            else
                LogDebug("RecommendedCard=       " + schedule.RecommendedCard.ToString(), (int)LogSetting.ADDRESPONSE);

            LogDebug("Series=                " + schedule.Series.ToString(), (int)LogSetting.ADDRESPONSE);
            if (schedule.Series==false)
                LogDebug("KeepMethod=            Keep All", (int)LogSetting.ADDRESPONSE);
            else
                LogDebug("KeepMethod=            Keep " + schedule.KeepMethod.ToString() + " Episodes", (int)LogSetting.ADDRESPONSE);

            LogDebug("UseScheduleName=       " + UseScheduleName.ToString(), (int)LogSetting.ADDRESPONSE);
            /*
            LogDebug("Quality:              " + schedule.Quality.ToString() );
            LogDebug("MaxAirings:           " + schedule.MaxAirings.ToString() );
            */

            LogDebug("", (int)LogSetting.ADDRESPONSE);
        }


        //-------------------------------------------------------------------------------------------------------------        
        // delete a single schedule from the data base
        //-------------------------------------------------------------------------------------------------------------                      
        public bool deleteschedule(string programName, string partialemail, int number)
        {

            LogDebug(partialemail, (int)LogSetting.ADDRESPONSE);
            

            if (_checkBoxAllowDelete == false)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Deleting schedules not allowed by TV server user settings ", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }

            TvBusinessLayer layer = new TvBusinessLayer();
            Setting setting;

            //define schedule global variables
            string Displayname = "NOTFOUND";
            int idChannel = -1;
            DateTime startTime = DateTime.ParseExact("9999-01-01_00:00", "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);	//old date as default
            DateTime endTime = DateTime.ParseExact("9999-01-01_00:01", "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);	//old date as default


            Schedule schedule = null;


            string[] mail_lines = partialemail.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);

            //parse email

            string parserstring = "";

            foreach (string line in mail_lines)  //get keywords for must have
            {

                if (extractkeyworddata("CHANNEL", line, '=') != "NOTFOUND")
                {
                    Displayname = extractkeyworddata("CHANNEL", line, '=');
                }
                else if (extractkeyworddata("START_TIME", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("START_TIME", line, '=');
                    try
                    {
                        startTime = DateTime.ParseExact(parserstring, "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Error: could not parse date value " + parserstring + " for START_TIME", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        return false;
                    }
                }
                else if (extractkeyworddata("END_TIME", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("END_TIME", line, '=');
                    try
                    {
                        
                        endTime = DateTime.ParseExact(parserstring, "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Error: could not parse date value " + parserstring + " for END_TIME", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        return false;
                    }
                }


            }

            idChannel = getfirstchannelid(Displayname);


            if (idChannel == -1)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Channel not specified or could not be identified", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }
            else if (startTime.Year > 3000)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Start time not specified or could not be identified", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }
            else if (endTime.Year > 3000)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("End time not specified or could not be identified", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }
            else if (programName == "NOTFOUND")
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Program name not specified or could not be identified", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }
            else if (startTime.CompareTo(endTime) > 0)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("End time defined before start time", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }

            schedule = null;
            try
            {
                schedule = Schedule.RetrieveOnce(idChannel, programName, startTime, endTime);

#if(MP100) 
                //do nothing Schedule.RetrieveSeries does not exist only ONCE can be deleted
#elif(MP101)
                if (schedule == null) //try series if once not found
                {
                    schedule = Schedule.RetrieveSeries(idChannel, programName, startTime, endTime);
                }
#elif(MP11)
                if (schedule == null) //try series if once not found
                {
                    schedule = Schedule.RetrieveSeries(idChannel, programName, startTime, endTime);
                }
#endif

            }
            catch (Exception exc)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Error: Schedule  could not be retrieved", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Program Name:         " + programName, (int)LogSetting.ADDRESPONSE);
                try
                {
                    Channel channel = Channel.Retrieve(schedule.IdChannel);
                    LogDebug("Channel=      " + channel.DisplayName, (int)LogSetting.ADDRESPONSE);
                }
                catch 
                {
                    LogDebug("Channel ID:           " + schedule.IdChannel, (int)LogSetting.ADDRESPONSE);
                }
                LogDebug("Start Time:           " + startTime.ToString(), (int)LogSetting.ADDRESPONSE);
                LogDebug("End Time:             " + endTime.ToString(), (int)LogSetting.ADDRESPONSE);
                LogDebug("Exception message:    " + exc.Message, (int)LogSetting.ADDRESPONSE);
                LogDebug(" Schedule will not be deleted", (int)LogSetting.ADDRESPONSE);
                return false;
            }

            if (schedule == null)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Error: Schedule could not be retrieved for", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Program Name:         " + programName, (int)LogSetting.ADDRESPONSE);
                LogDebug("Channel:              " + Displayname, (int)LogSetting.ADDRESPONSE);
                LogDebug("Start Time:           " + startTime.ToString(), (int)LogSetting.ADDRESPONSE);
                LogDebug("End Time:             " + endTime.ToString(), (int)LogSetting.ADDRESPONSE);
                LogDebug(" and will not be deleted", (int)LogSetting.ADDRESPONSE);
                return false;
            }
            LogDebug("", (int)LogSetting.ADDRESPONSE);
            LogDebug("***************************************************************", (int)LogSetting.ADDRESPONSE);
            LogDebug("Success: The following schedule has been deleted from TvServer:", (int)LogSetting.ADDRESPONSE);
            LogDebug("***************************************************************", (int)LogSetting.ADDRESPONSE);
            outputscheduletoresponse(schedule);


            //update total recorded hours
            TimeSpan difference = endTime.Subtract(startTime);
            double hours = Convert.ToDouble(difference.Hours) + Convert.ToDouble(difference.Days) * 24.0 + Convert.ToDouble(difference.Minutes) / 60.0 + Convert.ToDouble(schedule.PreRecordInterval) / 60.0 + Convert.ToDouble(schedule.PostRecordInterval) / 60.0;
            LogDebug("hours=" + hours.ToString(), (int)LogSetting.DEBUG);
            _LabelRecordingHours = _LabelRecordingHours - hours;
            setting = layer.GetSetting("EmailScheduler_RecordingHours", "-1");
            String.Format("{0:0.##}", _LabelRecordingHours);
            setting.Persist();

            
            try
            {
                schedule.Delete();
            }
            catch (Exception exc)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Fatal Error: Deleting schedule caused exception:", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug(exc.Message, (int)LogSetting.ADDRESPONSE);
                return false;
            }


            return true;

        }


        //-------------------------------------------------------------------------------------------------------------        
        // process all help commands (epg, channels, schedules)
        //-------------------------------------------------------------------------------------------------------------                              
        public bool helpschedule(string Name, string partialemail, int number)
        {
            LogDebug(partialemail, (int)LogSetting.ADDRESPONSE);   
        

            //LogDebug("Name.ToUpper()=" + Name.ToUpper(), (int)LogSetting.DEBUG);
            //LogDebug("partialemail=" + partialemail, (int)LogSetting.DEBUG);
            //LogDebug("number=" + number.ToString(), (int)LogSetting.DEBUG);

            //define schedule global variables
            string Groupname = "NOTFOUND";
            string Displayname = "NOTFOUND";
            int idChannel = -1;
            DateTime startTime = DateTime.ParseExact("9999-01-01_00:00", "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);	//old date as default
            DateTime endTime = DateTime.ParseExact("9999-01-01_00:01", "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);	//old date as default
            
            string[] mail_lines = partialemail.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);

            //parse email

            string parserstring = "";

            foreach (string line in mail_lines)  //get keywords for must have
            {
                if (extractkeyworddata("CHANNELGROUP", line, '=') != "NOTFOUND")
                {
                    Groupname = extractkeyworddata("CHANNELGROUP", line, '=');
                }
                else if (extractkeyworddata("CHANNEL", line, '=') != "NOTFOUND")
                {
                    Displayname = extractkeyworddata("CHANNEL", line, '=');
                }
                else if (extractkeyworddata("START_TIME", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("START_TIME", line, '=');
                    try
                    {
                        startTime = DateTime.ParseExact(parserstring, "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Error: could not parse date value " + parserstring + " for START_TIME", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    }
                }
                else if (extractkeyworddata("END_TIME", line, '=') != "NOTFOUND")
                {
                    parserstring = extractkeyworddata("END_TIME", line, '=');
                    try
                    {
                        
                        endTime = DateTime.ParseExact(parserstring, "yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture);
                    }
                    catch
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Error: could not parse date value " + parserstring + " for END_TIME", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    }
                }


            }

            
            Name += " "; //add a space to the name to make sure there is always a delimiter in Name
            if (extractkeyworddata("SCHEDULE", Name, ' ') != "NOTFOUND")
            {
                if (_checkBoxAllowHelpSchedule == true)
                {
                    LogDebug("Retrieving Schedules for help reply", (int)LogSetting.DEBUG);
#if(MP100)
                    IList allschedules = allschedules = Schedule.ListAll();
#elif(MP101)
                    IList<Schedule> allschedules = Schedule.ListAll();
#elif(MP11 || MP12)
                    IList<Schedule> allschedules = Schedule.ListAll();
#endif
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Listing all schedules:", (int)LogSetting.ADDRESPONSE);
                    foreach (Schedule schedule in allschedules)
                    {
                        LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                        outputscheduletoresponse(schedule);
                    }
                    
                    LogDebug("", (int)LogSetting.ADDRESPONSE);

                    //available drive space:
#if(MP100)
                    IList allcards = Card.ListAll();
#elif(MP101)
                    IList<Card> allcards = Card.ListAll();
#elif(MP11 || MP12)
                    IList<Card> allcards = Card.ListAll();
#endif
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Available drive space for all cards:", (int)LogSetting.ADDRESPONSE);
                    
                    foreach (Card card in allcards)
                    {
                        if (card.RecordingFolder.Length > 2)
                        {
                            DriveInfo drive;
                            string driveletter=card.RecordingFolder.Substring(0, 1);
                            drive = new DriveInfo(driveletter);
                            double freegigabytes = Math.Round( Convert.ToDouble(drive.AvailableFreeSpace) / 1073741824.0,0);
                            LogDebug("Card " + card.IdCard + " " + card.Name + " is using drive " + driveletter + ":\\ with " + freegigabytes.ToString() + " GB free disk space", (int)LogSetting.ADDRESPONSE);
                        }
                    }

                    
                }
                else
                {
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug(" Help Schedules not allowed by TV server settings" , (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    return false;
                }
                
            }
            else if (extractkeyworddata("CHANNEL", Name, ' ') != "NOTFOUND")
            {
                string GroupName = extractkeyworddata("CHANNEL", Name, ' ');
                if (_checkBoxAllowHelpChannel == true)
                {
                    LogDebug("Retrieving channel names for help reply", (int)LogSetting.DEBUG);

                         
                    if (GroupName == "")
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Listing all display channel names:", (int)LogSetting.ADDRESPONSE);
                   
#if(MP100)
                        IList allchannels = Channel.ListAll();
#elif(MP101)
                        IList<Channel> allchannels = Channel.ListAll();
#elif(MP11 || MP12)
                        IList<Channel> allchannels = Channel.ListAll();
#endif
                        foreach (Channel channel in allchannels)
                        {

                            LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                            LogDebug(channel.DisplayName, (int)LogSetting.ADDRESPONSE);

                        }
                    }
                    else //channel group defined
                    {
#if(MP100)
                        IList channelgroups = ChannelGroup.ListAll();
#elif(MP101)
                        IList<ChannelGroup> channelgroups = ChannelGroup.ListAll();
#elif(MP11 || MP12)
                        IList<ChannelGroup> channelgroups = ChannelGroup.ListAll();
#endif
                        foreach (ChannelGroup group in channelgroups)
                        {
                            if (GroupName == group.GroupName)
                            {//group name matches - list all channels within group
                                try //must use try due to in bug in map.ReferencedChannelGroup() - caused exception before
                                {
#if(MP100)
                                IList maps = group.ReferringGroupMap();
#elif(MP101)
                                IList<GroupMap> maps = group.ReferringGroupMap();
#elif(MP11 || MP12)
                                    IList<GroupMap> maps = group.ReferringGroupMap();
#endif
                                    foreach (GroupMap map in maps) //output all channels within group
                                    {
                                        Channel channel = map.ReferencedChannel();
                                        if (channel == null)
                                        {
                                            LogDebug("Error: Channel could not be assigned for tvmapping id " + map.IdMap.ToString(), (int)LogSetting.ERROR);
                                        }
                                        else
                                        {
                                            LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                                            LogDebug(channel.DisplayName, (int)LogSetting.ADDRESPONSE);
                                        }

                                    }
                                }
                                catch
                                {
                                    LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                                    LogDebug("Error: TV Channel group with name "+GroupName+" could not be processed - skipping group" , (int)LogSetting.ADDRESPONSE);
                                    LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                                }

                            }
                        }


                        //radio channels
#if(MP100)
                        IList radiochannelgroups = RadioChannelGroup.ListAll();
#elif(MP101)
                        IList<RadioChannelGroup> radiochannelgroups = RadioChannelGroup.ListAll();
#elif(MP11 || MP12)
                        IList<RadioChannelGroup> radiochannelgroups = RadioChannelGroup.ListAll();
#endif
                        foreach (RadioChannelGroup radiogroup in radiochannelgroups)
                        {
                            if (GroupName == radiogroup.GroupName)
                            {//group name matches - list all channels within group
                                try//must use try due to in bug in map.ReferencedChannelGroup() - caused exception before
                                {
#if(MP100)
                                IList radiomaps = radiogroup.ReferringRadioGroupMap();
#elif(MP101)
                                IList<RadioGroupMap> radiomaps = radiogroup.ReferringRadioGroupMap();
#elif(MP11 || MP12)
                                    IList<RadioGroupMap> radiomaps = radiogroup.ReferringRadioGroupMap();
#endif
                                    foreach (RadioGroupMap radiomap in radiomaps) //output all channels within group
                                    {
                                        Channel channel = radiomap.ReferencedChannel();
                                        if (channel == null)
                                        {
                                            LogDebug("Error: Channel could not be assigned for tvmapping id " + radiomap.IdMap.ToString(), (int)LogSetting.ERROR);
                                        }
                                        else
                                        {
                                            LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                                            LogDebug(channel.DisplayName, (int)LogSetting.ADDRESPONSE);
                                        }

                                    }
                                }
                                catch
                                {
                                    LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                                    LogDebug("Error: Radio Channel group with name " + GroupName + " could not be processed - skipping group", (int)LogSetting.ADDRESPONSE);
                                    LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                                }
                            }
                        }
                    }
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    
                }
                else
                {
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug(" Help Channels not allowed by TV server settings", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    return false;
                }
                
            }

            else if (extractkeyworddata("EPG", Name, ' ') != "NOTFOUND")
            {
                string ProgramName = extractkeyworddata("EPG", Name, ' ');
                if (_checkBoxAllowHelpEPG == true)
                {
                    LogDebug("Retrieving program names for help reply", (int)LogSetting.DEBUG);
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("***************************************************", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Listing all EPG program names:", (int)LogSetting.ADDRESPONSE);
                    bool partialname = true;
                    bool exact_time_match = false;
                    autocomplete(ref ProgramName, ref Displayname, ref idChannel, Groupname, ref startTime, ref endTime, partialname, exact_time_match);
                    int ctr = 1;
                    foreach (Program program in matchingprograms)
                    {
                        //output data
                        LogDebug("******************************************************", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Number=       " + ctr.ToString(), (int)LogSetting.ADDRESPONSE);
                        LogDebug("Program Name= " + program.Title, (int)LogSetting.ADDRESPONSE);
                        try
                        {
                            Channel channel = Channel.Retrieve(program.IdChannel);
                            LogDebug("Channel=      " + channel.DisplayName, (int)LogSetting.ADDRESPONSE);
                        }
                        catch
                        {
                            LogDebug("Channel ID=   " + program.IdChannel, (int)LogSetting.ADDRESPONSE);
                        }
                        LogDebug("START_TIME=   " + program.StartTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.ADDRESPONSE);

                        LogDebug("END_TIME=     " + program.EndTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.ADDRESPONSE);
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        ctr++;
                        if (ctr > MAX_EPG_OUTPUT)
                        {
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                            LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                            LogDebug("Too many programs (" + matchingprograms.Count.ToString() + ") do exist - aborting output", (int)LogSetting.ADDRESPONSE);
                            LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                            break;
                        }

                    }
                
                }
                else
                {
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug(" Help EPG is not allowed by TV server settings", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    return false;
                }
            }
            else
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Unknown Help Command "+ Name, (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }


            return true;
        }


        //-------------------------------------------------------------------------------------------------------------        
        // process run commands and execute batch file
        //-------------------------------------------------------------------------------------------------------------                                      
        public bool runscriptfile(string name, string partialemail, int number)
        {
            //start a user script file with arguments

            //process run scripts
            //LogDebug("runscriptfile parsing _checkBoxAllowRunScripts=" + _checkBoxAllowRunScripts.ToString(), (int)LogSetting.DEBUG);

            LogDebug(partialemail, (int)LogSetting.ADDRESPONSE);
            if (_checkBoxAllowRunScripts == false)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Running scripts not allowed by user settings - will skip run command", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                return false;
            }
            // find first space after script name 
            int i = 0;
            for (i = 0; i < name.Length; i++)
            {
                if ((name[i] == ' ') || (name[i] == '\t'))
                {
                    break;
                }
            }
            LogDebug("runscript i=" + i.ToString(), (int)LogSetting.DEBUG);

            if (i > 0) //command exists
            {
                string scriptfile = "NOTFOUND";
                string arguments = "";

                if (i < name.Length)
                {
                    scriptfile = TV_USER_FOLDER + @"\EmailScheduler\" + name.Substring(0, i - 1);
                    arguments = name.Substring(i, name.Length - i);
                }
                else
                {
                    scriptfile = TV_USER_FOLDER + @"\EmailScheduler\" + name;
                    arguments = "";
                }
                LogDebug("scriptfile=" + scriptfile, (int)LogSetting.DEBUG);
                LogDebug("arguments=" + arguments, (int)LogSetting.DEBUG);


                if (File.Exists(scriptfile) == true)
                {
                    LogDebug("User process " + scriptfile + " started", (int)LogSetting.DEBUG);
                    ProcessStartInfo EmailSchedulerBatchStart = new ProcessStartInfo(scriptfile);
                    EmailSchedulerBatchStart.Arguments = arguments;
                    EmailSchedulerBatchStart.WorkingDirectory = TV_USER_FOLDER + @"\EmailScheduler";
                    EmailSchedulerBatchStart.UseShellExecute = true;

                    Process EmailSchedulerBatchExecute = new Process();
                    EmailSchedulerBatchExecute.StartInfo = EmailSchedulerBatchStart;
                    try
                    {
                        EmailSchedulerBatchExecute.Start();
                    }
                    catch (Exception exc)
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Could not start " + scriptfile + "  " + EmailSchedulerBatchStart.Arguments, (int)LogSetting.ADDRESPONSE);
                        LogDebug("Exception message is " + exc.Message, (int)LogSetting.ERROR);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);

                        return false;
                    }
                    EmailSchedulerBatchExecute.WaitForExit(1000 * 60 * MAX_SCRIPT_WAIT_MINUTES); //wait minutes maximum
                    if (EmailSchedulerBatchExecute.HasExited == true)
                    {
                        if (EmailSchedulerBatchExecute.ExitCode != 0)
                        {
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                            LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                            LogDebug("Batch process completed with Errorcode " + EmailSchedulerBatchExecute.ExitCode.ToString(), (int)LogSetting.ADDRESPONSE);
                            LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);


                        }
                        else
                        {
                            LogDebug("", (int)LogSetting.ADDRESPONSE);
                            LogDebug("*********************************************************************************************************", (int)LogSetting.ADDRESPONSE);
                            LogDebug("User batch process " + scriptfile + " completed ", (int)LogSetting.ADDRESPONSE);
                            LogDebug("*********************************************************************************************************", (int)LogSetting.ADDRESPONSE);

                            //check for existing responsefile
                            string responsefile = scriptfile + ".response";
                            LogDebug("Searching for response file " + responsefile, (int)LogSetting.DEBUG);
                            if (File.Exists(responsefile) == true)
                            {

                                try
                                {
                                    LogDebug("User batch process response is: ", (int)LogSetting.ADDRESPONSE);
                                    System.IO.StreamReader sr = new System.IO.StreamReader(responsefile);
                                    string Text = sr.ReadToEnd();
                                    sr.Close();
                                    string[] lines = Text.Split("\n".ToCharArray(), StringSplitOptions.RemoveEmptyEntries);
                                    foreach (string line in lines)
                                    {
                                        LogDebug(line, (int)LogSetting.ADDRESPONSE);
                                    }

                                }
                                catch (Exception ee)
                                {
                                    LogDebug("Error in reading the file " + responsefile, (int)LogSetting.ERROR);
                                    LogDebug("Exception message is " + ee.Message, (int)LogSetting.ERROR);
                                    return false;
                                }
                            }
                            else
                            {
                                LogDebug("No batch process response found ", (int)LogSetting.DEBUG);
                            }
                        }
                    }
                    else
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Batch process did not complete within 3 minutes", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);


                    }

                }
                else
                {
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Scriptname " + scriptfile + " does not exist for RUN command", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);

                }
            }
            else //no scriptname specified
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("No scriptname specified for RUN command", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);

            }
            return true;
        }

        
        //-------------------------------------------------------------------------------------------------------------        
        // extract single keyword and parse arguments after separator
        //-------------------------------------------------------------------------------------------------------------                              
        public string extractkeyworddata(String keyword, String line, Char character)
        {
		    string templine=line.ToUpper();
		    templine=templine.Replace(" ","");
            //Log.Debug("keyword=" + keyword);
            //Log.Debug("line=" + line);
            //Log.Debug("templine=" + templine);
            //Log.Debug("templinecount=" + templine.Length.ToString());
            //Log.Debug("Character="+Convert.ToInt32(character).ToString());
		    if (templine.StartsWith(keyword.ToUpper()) == true)
		    {
			    //find first =
                int pos = 0;

                if (character == '\n')
                {
                    return ("DUMMY"); //dummy string returned
                }


                if (line.Contains(character.ToString()) == true)
                {
                    pos = line.IndexOf(character);
                }
                else //delimiter not found, ignore keyword
                {
                    return ("NOTFOUND");
                }

                //Log.Debug("int pos = "+pos.ToString());

			    //extract data
                string substring = "";
                if (pos > 0)
                {
                    substring = line.Substring(pos + 1, line.Length - pos - 1);
                }

                //Log.Debug("substring=" + substring);

                if (substring.Length < 1)
                {
                    return ("");
                }
                                                


                if (Convert.ToInt16(substring[substring.Length - 1]) == 13)
                {
                    substring = substring.Substring(0, substring.Length - 1);
                }

                //remove leading spaces and tabs
                while (((substring.StartsWith(" ")) || (substring.StartsWith("\t"))) && (substring.Length > 0))
                {
                    substring = substring.Substring(1, substring.Length - 1);
                }

                //remove trailing spaces and tabs
                while (((substring.EndsWith(" ")) || (substring.EndsWith("\t"))) && (substring.Length > 0))
                {
                    substring = substring.Substring(0, substring.Length - 1);
                }
                                                    //MessageBox.Show("substring="+substring);
                LogDebug("DEBUG extractkeyworddata: found substring " + substring + " for keyword " + keyword, (int)LogSetting.DEBUG);
			    return(substring);

		    }
    		
		    return ("NOTFOUND");
    		

    }


        //-------------------------------------------------------------------------------------------------------------        
        // Search epg data and find all matching programs 
        //-------------------------------------------------------------------------------------------------------------  
        // matching programs are searched based on available information for program name, start time, endtime, displayname or groupname
        // if dispalyname is defined, groupnames will be ignored
        // partial name = true will handle partial name matches from program name
        // exact_time match = true will use for comparison an exact match, if set to false it will be used as a range limit
        // Date Time format of "9999-01-01_00:00" means it is not defined
        // the routine will return an IList<Program> matchingprograms which contains all EPG programs of Type Program
        // the routine will not do any checking for conflicts of the list
        //-------------------------------------------------------------------------------------------------------------                              
        public bool autocomplete(ref string programName, ref string Displayname, ref int idChannel, string Groupname, ref DateTime startTime, ref DateTime endTime, bool partialname, bool exact_time_match)
        {
            //Initialization
            matchingprograms.Clear();  // matching programs will contain all epg programs which did match to the data

            
            LogDebug("EmailScheduler: Trying autocompletion of programName = " + programName, (int)LogSetting.DEBUG);
            LogDebug("EmailScheduler: Trying autocompletion of idChannel = " + idChannel, (int)LogSetting.DEBUG);
            LogDebug("EmailScheduler: Trying autocompletion of start time = " + startTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);
            LogDebug("EmailScheduler: Trying autocompletion of end time = " + endTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);

            if (Displayname != "NOTFOUND")
            {
                Groupname = "NOTFOUND"; //If channel name is defined do not use group name
            }


#if(MP100)
            IList allprograms = new List<Program>();
#elif(MP101)
            IList<Program> allprograms = new List<Program>();
#elif(MP11 || MP12)
            IList<Program> allprograms = new List<Program>();
#endif

            //find all programs  name is case sensitive
            if (partialname == false)
            {//find all programs with correct name
                allprograms = Program.RetrieveByTitle(programName);
            }
            else
            {//find all programs with partial name match


                

                foreach (Program oneprogram in Program.ListAll())
                {
                    if (oneprogram.Title.Contains(programName) == true)
                    {
                        allprograms.Add(oneprogram);
                    }
                }
            }
            LogDebug("all programs listed", (int)LogSetting.DEBUG);
            //programs were found -match start time
            IList startprograms = new ArrayList();


            if (exact_time_match == true)
            {
                foreach (Program program in allprograms)
                {
                    if ((program.StartTime == startTime) || (startTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) == "9999-01-01_00:00"))
                    {
                        if (program.StartTime > DateTime.Now) //do not use programs from past
                            startprograms.Add(program);
                    }

                }
            }
            else  
            {
                foreach (Program program in allprograms)
                {
                    if ((program.StartTime > startTime) || (startTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) == "9999-01-01_00:00"))
                    {
                        if (program.StartTime > DateTime.Now) //do not use programs from past
                            startprograms.Add(program);
                    }

                }
            }

            if (startprograms.Count == 0)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Error: No programs could be assigned to start time " + startTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.DEBUG);
                LogDebug("Error: No programs could be assigned", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);                                                                                          
                
                return false;
            }
            else
            {
                LogDebug("Autocompletion found " + startprograms.Count + " programs matching title " + programName, (int)LogSetting.DEBUG);
            }

            //programs were found which match end time and start time
            IList endprograms = new ArrayList();

            if (exact_time_match == true)
            {
                foreach (Program program in startprograms)
                {
                    if ((program.EndTime == endTime) || (endTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) == "9999-01-01_00:01"))
                    {
                        endprograms.Add(program);
                    }

                }
            }
            else
            {
                foreach (Program program in startprograms)
                {
                    if ((program.EndTime < endTime) || (endTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture) == "9999-01-01_00:01"))
                    {
                        endprograms.Add(program);
                    }

                }
            }

            if (endprograms.Count == 0)
            {
                LogDebug("", (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                LogDebug("Error: No programs could be assigned to end time " + endTime.ToString("yyyy-MM-dd_HH:mm", CultureInfo.InvariantCulture), (int)LogSetting.ADDRESPONSE);
                LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);                                                                                          
                
                return false;
            }
            else
            {
                LogDebug("Autocompletion found " + endprograms.Count + " programs matching starttime, endtime and title " + programName, (int)LogSetting.DEBUG);
            }

            //programs were found -match channel, start time and endtime, try to filter channel if defined
            

            

            if (Groupname == "NOTFOUND")// match channel
            {
                foreach (Program program in endprograms)
                {
                    Channel channel = program.ReferencedChannel();
                    if ((channel.DisplayName == Displayname) || (Displayname == "NOTFOUND"))
                    {
                        matchingprograms.Add(program);
                    }

                }
            }
            else //match channel group for tv or radio
            {
                foreach (Program program in endprograms)
                {
                    Channel channel = program.ReferencedChannel();
#if(MP100)
                    IList maps = channel.ReferringGroupMap();
#elif(MP101)
                    IList<GroupMap> maps = channel.ReferringGroupMap();
#elif(MP11 || MP12)
                    IList<GroupMap> maps = channel.ReferringGroupMap();
#endif

                    foreach (GroupMap map in maps) 
                    {
                        try //must use try due to in bug in map.ReferencedChannelGroup() - caused exception before
                        {
                            ChannelGroup channelgroupmap = map.ReferencedChannelGroup();
                            if (channelgroupmap.GroupName == Groupname)
                            {
                                Channel mapchannel = map.ReferencedChannel();
                                if (mapchannel == channel)
                                {
                                    matchingprograms.Add(program);
                                }
                            }
                        }
                        catch
                        {
                            LogDebug("Referenced TV Channel Group "+map.IdGroup.ToString() +" caused exception and has been skipped", (int)LogSetting.DEBUG);
                        }
                    }


#if(MP100)
                    IList radiomaps = channel.ReferringGroupMap();
#elif(MP101)
                    IList<RadioGroupMap> radiomaps = channel.ReferringRadioGroupMap();
#elif(MP11 || MP12)
                    IList<RadioGroupMap> radiomaps = channel.ReferringRadioGroupMap();
#endif

                    foreach (RadioGroupMap radiomap in radiomaps)
                    {
                        try //must use try due to in bug in map.ReferencedChannelGroup() - caused exception before
                        {
                            RadioChannelGroup radiochannelgroupmap = radiomap.ReferencedRadioChannelGroup();
                            if (radiochannelgroupmap.GroupName == Groupname)
                            {
                                Channel mapchannel = radiomap.ReferencedChannel();
                                if (mapchannel == channel)
                                {
                                    matchingprograms.Add(program);
                                }

                            }
                        }
                        catch
                        {
                            LogDebug("Referenced RadioChannel Group " + radiomap.IdGroup.ToString() + " caused exception and has been skipped", (int)LogSetting.DEBUG);
                        }
                    }
                }
            }



            if (matchingprograms.Count == 0)
            {
                if (Groupname == "NOTFOUND")
                {
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Error: No programs could be assigned to channel name " + Displayname, (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                }
                else //groupname was defined
                {
                    LogDebug("", (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                    LogDebug("Error: No programs could be assigned to group name " + Groupname, (int)LogSetting.ADDRESPONSE);
                    LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                }
                
                return false;
            }
            else if (matchingprograms.Count == 1)
            {
                //do nothing exactly one match
            }
            else
            {
                LogDebug(matchingprograms.Count.ToString() + " programs did match", (int)LogSetting.ADDRESPONSE);

                //LogDebug("", (int)LogSetting.ADDRESPONSE);
                //LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                //LogDebug("Warning: " + matchingprograms.Count .ToString()+ " programs did match to program name=" + programName, (int)LogSetting.ADDRESPONSE);
                //LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);                                                                                                         
            }

            //Debug:
            if (DEBUG == true)  //if DEBUG for faster processing
            {

                LogDebug("Debug autocompletion - listing all matched programs", (int)LogSetting.DEBUG);
                int ctr = 1;
                foreach (Program program in matchingprograms)
                {
                    
                    LogDebug("Number=" + ctr.ToString(), (int)LogSetting.DEBUG);
                    LogDebug("Program=" + program.Title, (int)LogSetting.DEBUG);
                    LogDebug("Start=" + program.StartTime.ToString(), (int)LogSetting.DEBUG);
                    LogDebug("End=" + program.EndTime.ToString(), (int)LogSetting.DEBUG);
                    Channel channel = program.ReferencedChannel();
                    LogDebug("Channel=" + channel.DisplayName, (int)LogSetting.DEBUG);
                    LogDebug("", (int)LogSetting.DEBUG);

                    if (ctr > MAX_EPG_OUTPUT)
                    {
                        LogDebug("", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        LogDebug("Too many programs (" + matchingprograms.Count.ToString() + ") do exist - aborting output", (int)LogSetting.ADDRESPONSE);
                        LogDebug("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", (int)LogSetting.ADDRESPONSE);
                        break;
                    }
                    ctr++;
                }
            }

            return true;
        }


        //-------------------------------------------------------------------------------------------------------------        
        // get the unique channel id for a channel displayname 
        //-------------------------------------------------------------------------------------------------------------                              
        public int getfirstchannelid(string displayname)
        {
            //get id channel
#if(MP100) 
                IList allchannels = Channel.ListAll();
#elif(MP101)
            IList<Channel> allchannels = Channel.ListAll();
#elif(MP11 || MP12)
            IList<Channel> allchannels = Channel.ListAll();
#endif

            foreach (Channel channel in allchannels)
            {
                if (channel.DisplayName == displayname)
                {
                    return channel.IdChannel;
                }
            }
            return -1;
        }



}





//**************************************************************************************************************************************

  //***********************
  // the eMail class
  //***********************
  public class eMail
  {
    string m_mailFrom;
    string m_mailTo;
    string m_mailSubject;
    string m_mailBody;
    string m_mailHTMLBody;
    string m_id;
    bool m_isSetAsRead;
    bool m_isSetForDelete;
    int m_mailNumberOnServer;
    string m_mailboxPath;
    string m_attachmentsPath;
    ArrayList m_attachments = new ArrayList();

    public eMail()
    {
      m_mailFrom = "";
      m_mailTo = "";
      m_mailSubject = "";
      m_id = "";
      m_mailBody = "";
      m_mailHTMLBody = "";
      m_isSetAsRead = false;
      m_mailboxPath = "";
      m_attachmentsPath = "";
      m_mailNumberOnServer = -1;
    }
    public void AddAttachment(MailClass.MailAttachment att)
    {
      m_attachments.Add(att);
    }
    public void GetAttachmentList(ref ArrayList theList)
    {
      theList = (ArrayList)m_attachments.Clone();
    }
    public int MailNumberOnServer
    {
        get { return m_mailNumberOnServer; }
        set { m_mailNumberOnServer = value;}
    }
    public string MailboxPath
    {
      get { return m_mailboxPath; }
      set { m_mailboxPath = value; }
    }
    public string AttachmentsPath
    {
      get { return m_attachmentsPath; }
      set { m_attachmentsPath = value; }
    }
    public bool IsSetForDelete
    {
      get { return m_isSetForDelete; }
      set { m_isSetForDelete = value; }
    }
    public bool SetRead
    {
      get { return m_isSetAsRead; }
      set { m_isSetAsRead = value; }
    }
    public string From
    {
      get { return m_mailFrom; }
      set { m_mailFrom = value; }
    }
    public string To
    {
      get { return m_mailTo; }
      set { m_mailTo = value; }
    }
    public string Subject
    {
      get { return m_mailSubject; }
      set { m_mailSubject = value; }
    }
    public string Body
    {
      get { return m_mailBody; }
      set { m_mailBody = value; }
    }
    public string HTML
    {
      get { return m_mailHTMLBody; }
      set { m_mailHTMLBody = value; }
    }

    public string MailID
    {
      get { return m_id; }
      set { m_id = value; }
    }

  }



  //**************************************************************************************************************************************

  //***********************
  // the mailbox class
  //***********************
  
  public class MailBox
  {
    string m_mailBoxLabel;
    string m_userName;
    string m_passWord;
    string m_server;
    int m_mailsCount;
    int m_serverPort;
    string m_mailBoxPath;
    string m_attachmentsPath;
    int m_lastCheckCount;
    bool m_enabled = true;
    public const byte NO_SSL = 0;
    public const byte SSL_PORT = 1;
    public const byte STLS = 2;
    byte m_TLS;
    bool DEBUG = false;


    public bool Debug
    {
        get { return DEBUG; }
        set { DEBUG = value; }
    }

    public MailBox(string label, string userName, string passWord, string server, int port, byte TLS, string mailboxFolder, string attachmentsFolder)
    {
      m_mailBoxLabel = label;
      m_userName = userName;
      m_passWord = passWord;
      m_server = server;
      m_serverPort = port; // by default port 110 is used
      m_mailsCount = 0;
      m_attachmentsPath = attachmentsFolder;
      m_mailBoxPath = mailboxFolder;
      m_lastCheckCount = 0;
      m_enabled = true;
      m_TLS = TLS;


      // Check if MailboxFolder directory exist
      System.IO.DirectoryInfo dInfoMail = new System.IO.DirectoryInfo(m_mailBoxPath);
      if (!dInfoMail.Exists)
      {
        dInfoMail.Create(); // Creating the mail directory
        if (DEBUG == true)
            Log.Info("Mailbox {0} created mail folder: {1}", label, m_mailBoxPath);
      }

      // Check if Attachments directory exist
      System.IO.DirectoryInfo dInfoAtt = new System.IO.DirectoryInfo(m_attachmentsPath);
      if (!dInfoAtt.Exists)
      {
        dInfoAtt.Create(); // Creating the mail directory
        if (DEBUG == true)
            Log.Info("Mailbox {0} created attachemnts folder: {1}", label, m_attachmentsPath);
      }
    }

    //[Editor(typeof(FolderNameEditor), typeof(System.Drawing.Design.UITypeEditor))]
    public string AttachmentFolder
    {
        get
        {
            return m_attachmentsPath; }
            set { m_attachmentsPath = value;
         }
    }

    [BrowsableAttribute(false)]
    public int LastCheckCount
    {
        get { return m_lastCheckCount; }
        set { m_lastCheckCount = value; }
    }

    //[Editor(typeof(FolderNameEditor), typeof(System.Drawing.Design.UITypeEditor))]
    public string MailboxFolder
    {
        get { return m_mailBoxPath; }
        set { m_mailBoxPath = value;}
    }
    public int Port
    {
        get { return m_serverPort; }
        set { m_serverPort = value;}
    }
    public byte TLS
    {
        get { return m_TLS; }
        set { m_TLS = value;}
    }
    public string Username
    {
        get { return m_userName; }
        set { m_userName = value; }
    }
    [BrowsableAttribute(false)]
    public int MailCount
    {
        get {return m_mailsCount; }
        set { m_mailsCount = value;} // no need to set
    }
    [BrowsableAttribute(false)]
    public string Password
    {
        get { return m_passWord; }
        set { m_passWord = value;}
    }

    public string ServerAddress
    {
        get { return m_server; }
        set { m_server = value; }
    }
    public string BoxLabel
    {
        get { return m_mailBoxLabel; }
        set { m_mailBoxLabel = value;}
    }

    public bool Enabled
    {
        get { return m_enabled; }
        set { m_enabled = value; }
    }

    public override string ToString()
    {
        if (m_mailBoxLabel != null)
        {
            if (m_mailBoxLabel != "")
            {
                return m_mailBoxLabel;
            }
        }
        
      return base.ToString();
    }

  }




  //**************************************************************************************************************************************

  //***********************************
  // the CompareModificationTime class
  //***********************************
  public class CompareModificationTime : System.Collections.IComparer
  {
    public int Compare(object objA, object objB)// : System.Collections.IComparer
    {
      System.IO.FileInfo fInfoA = (System.IO.FileInfo)objA;
      System.IO.FileInfo fInfoB = (System.IO.FileInfo)objB;
      if (fInfoA.LastWriteTime > fInfoB.LastWriteTime) return -1;
      if (fInfoA.LastWriteTime == fInfoB.LastWriteTime) return 0;
      if (fInfoA.LastWriteTime < fInfoB.LastWriteTime) return 1;
      return 0;
    }

  }



  //**************************************************************************************************************************************

  //*****************************
  // the SendTvServerEmail class
  //*****************************

  public class SendTvServerEmail
  {
# region Declarations
      string s_userName = "";
      string s_passWord = "";
      string s_server = "";
      string s_from = "";
      string s_to = "";
      string s_subject = "";
      string s_body = "";
      bool s_busy = false;
      
      int s_serverPort = 0;
      bool s_secureSSL = true;

      
      bool s_error = false; 
      string s_errormessage = "";

      bool DEBUG = false;


      public bool Debug
      {
          get { return DEBUG; }
          set { DEBUG = value; }
      }

# endregion Declarations

# region Properties
      
        public string ServerAddress
        {
            get { return s_server; }
            set { s_server = value; }
        }

        public int Port
        {
            get { return s_serverPort; }
            set { s_serverPort = value;}
        }

        public string Username
        {
            get { return s_userName; }
            set { s_userName = value; }
        }

        public string Password
        {
            get { return s_passWord; }
            set { s_passWord = value;}
        }

        public string From
        {
            get { return s_from; }
            set { s_from = value;}
        }

        public bool SecureSSL
        {
            get { return s_secureSSL; }
            set { s_secureSSL = value;}
        }

        public string To
        {
            get { return s_to; }
            set { s_to = value; }
        }

        public string Subject
        {
            get { return s_subject; }
            set { s_subject = value; }
        }

        public string Body
        {
            get { return s_body; }
            set { s_body = value; }
        }

        public string ErrorMessage
        {
            get { return s_errormessage; }
        }

        public bool Error
        {
            get { return s_error; }
        }




# endregion Properties

# region Constructor
    public SendTvServerEmail (string server, int port, bool secure,  string user, string password, string from)
    {
        s_server = server;
        s_serverPort = port;
        s_secureSSL = secure;
        s_userName = user;
        s_passWord = password;
        s_from = from;
    }

#endregion Constructor

#region Methods
    public bool SendNewEmail(string to, string subject, string body)
    {

        s_to = to;
        s_subject = subject;
        s_body = body;

        //wait for old sent
        while (s_busy == true)
        {
            System.Threading.Thread.Sleep(500); //wait 0.5s
            if (DEBUG==true)
                Log.Debug("Waiting for old email sent to complete");
        }


        if (DEBUG == true)
            Log.Debug("Starting email thread");
        s_busy = true;
        System.Threading.Thread th = new System.Threading.Thread(SendEmailThread);
        th.Start();


        for (int i = 1; i < 600; i++)  //max wait 300s
        {
            System.Threading.Thread.Sleep(500); //wait 0.5s
            
            if (s_busy == false)
            {
                if (DEBUG == true)
                    Log.Debug("Email Completed");
                return true;
            }
        }

        //timeout try to kill thread
        if (DEBUG == true)
            Log.Debug("Timeout for sending email - try to kill thread");
        th.Abort();

        s_busy = false;


        
        
        return false;
    }


    public void SendEmailThread()
    {
        s_error = true;
        s_errormessage = "TIMEOUT";
        try
        {
            SmtpClient SmtpMail = new SmtpClient(s_server, s_serverPort);
            SmtpMail.Credentials = new NetworkCredential(s_userName, s_passWord);
            SmtpMail.EnableSsl = s_secureSSL;
            SmtpMail.Send(s_from, s_to, s_subject, s_body);
            
            
            if (DEBUG == true)
                Log.Debug("Email with subject " + s_subject + " sent to " + s_to);
            s_error = false;
            s_errormessage = "NOERROR";
            s_busy = false;
            //Log.Debug("Email sent " + subject + body + to + s_server + s_serverPort.ToString() + s_server + s_userName + s_passWord + s_secureSSL.ToString());
        }
        catch (Exception ee)
        {
            Log.Error("Fatal Error: Email with subject " + s_subject + " sent to " + s_to);
            Log.Error("Exception message is " + ee.Message);
            Log.Debug("Fatal Error: Email with subject " + s_subject + " sent to " + s_to);
            Log.Debug("Exception message is " + ee.Message);
            s_errormessage = ee.Message;
            return;
        }

        

    }
#endregion Methods

  }

}
