'Dim objects
Dim objFSO, objExcel, objSheetKFB, objSheetData, objOutputFile
Dim strInputData, strSaveDir
Dim intRow, IntCell, intMaxChannel
Dim arrFrekvens(100, 4)

strInputData = "\\elofnas01\HTPC\MediaPortal\Tuning Details\Grunddata.xls"
strSaveDir = "\\elofnas01\HTPC\MediaPortal\Tuning Details\Sweden\"

'Create objects
Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objExcel = CreateObject("Excel.Application")

'Create folder for generated files
objFSO.CreateFolder(strSaveDir)

'Open xls-file and fetch worksheets
objExcel.WorkBooks.Open strInputData
Set objSheetData = objExcel.ActiveWorkbook.Worksheets(1)
Set objSheetKFB = objExcel.ActiveWorkbook.Worksheets(2)

'Loop through the KanalFrekvensBandbredd worksheet and populate the array
intRow = 2
intMaxChannel = 0
Do While objSheetKFB.Cells(intRow, 1).Value <> ""
	arrFrekvens(objSheetKFB.Cells(intRow, 1), 1) = objSheetKFB.Cells(intRow, 2)
	arrFrekvens(objSheetKFB.Cells(intRow, 1), 2) = objSheetKFB.Cells(intRow, 3)
	arrFrekvens(objSheetKFB.Cells(intRow, 1), 3) = objSheetKFB.Cells(intRow, 4)
	arrFrekvens(objSheetKFB.Cells(intRow, 1), 4) = 0
	if objSheetKFB.Cells(intRow, 1) > intMaxChannel then
		intMaxChannel = objSheetKFB.Cells(intRow, 1)
	end if
	intRow = intRow + 1
Loop

'Loop through the Data worksheet
intRow = 2
Do While objSheetData.Cells(intRow, 1).Value <> ""
	'Open output file and write header
	Set objOutputFile = objFSO.CreateTextFile(strSaveDir & "Sweden." & objSheetData.Cells(intRow, 1).Value & ".xml", TRUE)
	objOutputFile.WriteLine("<?xml version=" & chr(34) & "1.0" & chr(34) & " encoding=" & chr(34) & "utf-8" & chr(34) & "?>")
	objOutputFile.WriteLine("<ArrayOfDVBTTuning xmlns:xsi="& chr(34) & "http://www.w3.org/2001/XMLSchema-instance" & chr(34) & " xmlns:xsd=" & chr(34) & "http://www.w3.org/2001/XMLSchema" & chr(34) & ">")

	'Loop through the different MUX
	For intCell = 2 to 8
		if objSheetData.Cells(intRow, intCell).Value <> "" then
			objOutputFile.WriteLine("  <DVBTTuning>")
			objOutputFile.WriteLine("    <Frequency>" & arrFrekvens(objSheetData.Cells(intRow, intCell).Value, 1) & "</Frequency>")
			objOutputFile.WriteLine("    <BandWidth>" & arrFrekvens(objSheetData.Cells(intRow, intCell).Value, 2) & "</BandWidth>")
			objOutputFile.WriteLine("    <Offset>" & arrFrekvens(objSheetData.Cells(intRow, intCell).Value, 3) & "</Offset>")
			objOutputFile.WriteLine("  </DVBTTuning>")
			
			'Mark the frequency as used
			arrFrekvens(objSheetData.Cells(intRow, intCell).Value, 4) = 1
		end if
	next
	
	'Write footer and close file
	objOutputFile.WriteLine("</ArrayOfDVBTTuning>")
	objOutputFile.Close
	intRow = IntRow + 1
Loop

'Create the All Regions file
Set objOutputFile = objFSO.CreateTextFile(strSaveDir & "Sweden.All Regions.xml", TRUE)
objOutputFile.WriteLine("<?xml version=" & chr(34) & "1.0" & chr(34) & " encoding=" & chr(34) & "utf-8" & chr(34) & "?>")
objOutputFile.WriteLine("<ArrayOfDVBTTuning xmlns:xsi="& chr(34) & "http://www.w3.org/2001/XMLSchema-instance" & chr(34) & " xmlns:xsd=" & chr(34) & "http://www.w3.org/2001/XMLSchema" & chr(34) & ">")

'Loop through the frequencies and write those used to the file
for intRow = 1 to intMaxChannel
	if arrFrekvens(intRow, 4) = 1 then
		objOutputFile.WriteLine("  <DVBTTuning>")
		objOutputFile.WriteLine("    <Frequency>" & arrFrekvens(intRow, 1) & "</Frequency>")
		objOutputFile.WriteLine("    <BandWidth>" & arrFrekvens(intRow, 2) & "</BandWidth>")
		objOutputFile.WriteLine("    <Offset>" & arrFrekvens(intRow, 3) & "</Offset>")
		objOutputFile.WriteLine("  </DVBTTuning>")
	end if
next

'Write footer and close file
objOutputFile.WriteLine("</ArrayOfDVBTTuning>")
objOutputFile.Close

'Close workbook and quit Excel.
objExcel.ActiveWorkbook.Close
objExcel.Application.Quit

'End
MsgBox "Finish!"
