﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;

namespace ConfigHandler
{
    public class Config
    {
        // Fields
        private System.Configuration.Configuration _config = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);

        // Methods
        public bool GetValue(string name, bool def)
        {
            if (this._config.AppSettings.Settings[name] == null)
            {
                return def;
            }
            return (this._config.AppSettings.Settings[name].Value.ToLower() == "true");
        }

        public int GetValue(string name, int def)
        {
            if (this._config.AppSettings.Settings[name] != null)
            {
                return Convert.ToInt32(this._config.AppSettings.Settings[name].Value);
            }
            return def;
        }

        public string GetValue(string name, string def)
        {
            if (this._config.AppSettings.Settings[name] != null)
            {
                return this._config.AppSettings.Settings[name].Value.ToString();
            }
            return def;
        }

        public void SetValue(string name, bool val)
        {
            this.SetValue(name, val.ToString());
        }

        public void SetValue(string name, int val)
        {
            this.SetValue(name, val.ToString());
        }

        public void SetValue(string name, string val)
        {
            if (this._config.AppSettings.Settings[name] == null)
            {
                this._config.AppSettings.Settings.Add(name, val);
            }
            else
            {
                this._config.AppSettings.Settings[name].Value = val;
            }
            this._config.Save(ConfigurationSaveMode.Modified);
            ConfigurationManager.RefreshSection("appSettings");
        }
    }

 

}


