﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using TvDatabase;
using NetworkHandler;

namespace SetupTv.Sections
{
    public class HomeServerUserControl : SectionSettings
    {
        // Fields
        private Button btAddRHBHost;
        private Button btDelRHBHost;
        private Button btTestRHBCheck;
        private CheckBox cbExtensiveLogging;
        private IContainer components;
        private GroupBox groupBox1;
        private GroupBox groupBox2;
        private GroupBox groupBox3;
        private Label label1;
        private Label label2;
        private Label label3;
        private Label label4;
        private Label label6;
        private Label label7;
        private Label lbWarning;
        private ListBox lstbRHBHosts;
        private TabControl tabControl1;
        private TabPage tabPage1;
        private TabPage tabPage2;
        private TextBox tbCheckInterval;
        private TextBox tbDeclareDeath;
        private LinkLabel linkLabel1;
        private TextBox tbRHBHost;

        // Methods
        public HomeServerUserControl()
        {
            this.InitializeComponent();
        }

        private void btAddRHBHost_Click(object sender, EventArgs e)
        {
            if (this.tbRHBHost.Text == "")
            {
                MessageBox.Show("No Hostname entered");
            }
            else
            {
                for (int i = 0; i < this.lstbRHBHosts.Items.Count; i++)
                {
                    if (this.lstbRHBHosts.Items[i].ToString().ToLower() == this.tbRHBHost.Text.ToLower())
                    {
                        MessageBox.Show("Host already in List");
                        return;
                    }
                }
                this.lstbRHBHosts.Items.Add(this.tbRHBHost.Text);
                this.lstbRHBHosts.Text = "";
            }
        }

        private void btDelRHBHost_Click(object sender, EventArgs e)
        {
            this.lstbRHBHosts.Items.Remove(this.lstbRHBHosts.SelectedItem);
        }

        private void btTestRHBCheck_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < this.lstbRHBHosts.Items.Count; i++)
            {
                if (NetworkHandler.NetworkHandler.isComputerAvaible(this.lstbRHBHosts.Items[i].ToString()))
                {
                    MessageBox.Show(this.lstbRHBHosts.Items[i].ToString() + " is avaible");
                }
                else
                {
                    MessageBox.Show(this.lstbRHBHosts.Items[i].ToString() + " is unavaible");
                }
            }
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private void InitializeComponent()
        {
            this.tabControl1 = new System.Windows.Forms.TabControl();
            this.tabPage1 = new System.Windows.Forms.TabPage();
            this.groupBox3 = new System.Windows.Forms.GroupBox();
            this.cbExtensiveLogging = new System.Windows.Forms.CheckBox();
            this.lbWarning = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.tabPage2 = new System.Windows.Forms.TabPage();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.btTestRHBCheck = new System.Windows.Forms.Button();
            this.btDelRHBHost = new System.Windows.Forms.Button();
            this.btAddRHBHost = new System.Windows.Forms.Button();
            this.label7 = new System.Windows.Forms.Label();
            this.label6 = new System.Windows.Forms.Label();
            this.tbRHBHost = new System.Windows.Forms.TextBox();
            this.lstbRHBHosts = new System.Windows.Forms.ListBox();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.label4 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this.tbCheckInterval = new System.Windows.Forms.TextBox();
            this.tbDeclareDeath = new System.Windows.Forms.TextBox();
            this.linkLabel1 = new System.Windows.Forms.LinkLabel();
            this.tabControl1.SuspendLayout();
            this.tabPage1.SuspendLayout();
            this.groupBox3.SuspendLayout();
            this.tabPage2.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.groupBox1.SuspendLayout();
            this.SuspendLayout();
            // 
            // tabControl1
            // 
            this.tabControl1.Controls.Add(this.tabPage1);
            this.tabControl1.Controls.Add(this.tabPage2);
            this.tabControl1.Location = new System.Drawing.Point(0, 3);
            this.tabControl1.Name = "tabControl1";
            this.tabControl1.SelectedIndex = 0;
            this.tabControl1.Size = new System.Drawing.Size(480, 380);
            this.tabControl1.TabIndex = 0;
            // 
            // tabPage1
            // 
            this.tabPage1.Controls.Add(this.linkLabel1);
            this.tabPage1.Controls.Add(this.groupBox3);
            this.tabPage1.Controls.Add(this.lbWarning);
            this.tabPage1.Controls.Add(this.label3);
            this.tabPage1.Location = new System.Drawing.Point(4, 22);
            this.tabPage1.Name = "tabPage1";
            this.tabPage1.Padding = new System.Windows.Forms.Padding(3);
            this.tabPage1.Size = new System.Drawing.Size(472, 354);
            this.tabPage1.TabIndex = 0;
            this.tabPage1.Text = "Home";
            this.tabPage1.UseVisualStyleBackColor = true;
            // 
            // groupBox3
            // 
            this.groupBox3.Controls.Add(this.cbExtensiveLogging);
            this.groupBox3.Location = new System.Drawing.Point(6, 261);
            this.groupBox3.Name = "groupBox3";
            this.groupBox3.Size = new System.Drawing.Size(437, 47);
            this.groupBox3.TabIndex = 6;
            this.groupBox3.TabStop = false;
            this.groupBox3.Text = "Global Config";
            // 
            // cbExtensiveLogging
            // 
            this.cbExtensiveLogging.AutoSize = true;
            this.cbExtensiveLogging.Location = new System.Drawing.Point(3, 19);
            this.cbExtensiveLogging.Name = "cbExtensiveLogging";
            this.cbExtensiveLogging.Size = new System.Drawing.Size(148, 17);
            this.cbExtensiveLogging.TabIndex = 5;
            this.cbExtensiveLogging.Text = "Enable extensive Logging";
            this.cbExtensiveLogging.UseVisualStyleBackColor = true;
            // 
            // lbWarning
            // 
            this.lbWarning.AutoSize = true;
            this.lbWarning.Location = new System.Drawing.Point(6, 311);
            this.lbWarning.Name = "lbWarning";
            this.lbWarning.Size = new System.Drawing.Size(35, 13);
            this.lbWarning.TabIndex = 1;
            this.lbWarning.Text = "label4";
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label3.Location = new System.Drawing.Point(142, 83);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(159, 20);
            this.label3.TabIndex = 0;
            this.label3.Text = "Homeserver Plugin";
            // 
            // tabPage2
            // 
            this.tabPage2.Controls.Add(this.groupBox2);
            this.tabPage2.Controls.Add(this.groupBox1);
            this.tabPage2.Location = new System.Drawing.Point(4, 22);
            this.tabPage2.Name = "tabPage2";
            this.tabPage2.Padding = new System.Windows.Forms.Padding(3);
            this.tabPage2.Size = new System.Drawing.Size(472, 354);
            this.tabPage2.TabIndex = 1;
            this.tabPage2.Text = "HeartBeat Monitor";
            this.tabPage2.UseVisualStyleBackColor = true;
            // 
            // groupBox2
            // 
            this.groupBox2.Controls.Add(this.btTestRHBCheck);
            this.groupBox2.Controls.Add(this.btDelRHBHost);
            this.groupBox2.Controls.Add(this.btAddRHBHost);
            this.groupBox2.Controls.Add(this.label7);
            this.groupBox2.Controls.Add(this.label6);
            this.groupBox2.Controls.Add(this.tbRHBHost);
            this.groupBox2.Controls.Add(this.lstbRHBHosts);
            this.groupBox2.Location = new System.Drawing.Point(6, 132);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(443, 189);
            this.groupBox2.TabIndex = 3;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Reversed HeartBeat Configuration";
            // 
            // btTestRHBCheck
            // 
            this.btTestRHBCheck.Location = new System.Drawing.Point(231, 117);
            this.btTestRHBCheck.Name = "btTestRHBCheck";
            this.btTestRHBCheck.Size = new System.Drawing.Size(75, 23);
            this.btTestRHBCheck.TabIndex = 6;
            this.btTestRHBCheck.Text = "Test Check";
            this.btTestRHBCheck.UseVisualStyleBackColor = true;
            this.btTestRHBCheck.Click += new System.EventHandler(this.btTestRHBCheck_Click);
            // 
            // btDelRHBHost
            // 
            this.btDelRHBHost.Location = new System.Drawing.Point(231, 45);
            this.btDelRHBHost.Name = "btDelRHBHost";
            this.btDelRHBHost.Size = new System.Drawing.Size(75, 23);
            this.btDelRHBHost.TabIndex = 5;
            this.btDelRHBHost.Text = "Delete";
            this.btDelRHBHost.UseVisualStyleBackColor = true;
            this.btDelRHBHost.Click += new System.EventHandler(this.btDelRHBHost_Click);
            // 
            // btAddRHBHost
            // 
            this.btAddRHBHost.Location = new System.Drawing.Point(231, 17);
            this.btAddRHBHost.Name = "btAddRHBHost";
            this.btAddRHBHost.Size = new System.Drawing.Size(75, 23);
            this.btAddRHBHost.TabIndex = 4;
            this.btAddRHBHost.Text = "Add";
            this.btAddRHBHost.UseVisualStyleBackColor = true;
            this.btAddRHBHost.Click += new System.EventHandler(this.btAddRHBHost_Click);
            // 
            // label7
            // 
            this.label7.AutoSize = true;
            this.label7.Location = new System.Drawing.Point(58, 45);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(41, 13);
            this.label7.TabIndex = 3;
            this.label7.Text = "Hostlist";
            // 
            // label6
            // 
            this.label6.AutoSize = true;
            this.label6.Location = new System.Drawing.Point(44, 22);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(55, 13);
            this.label6.TabIndex = 2;
            this.label6.Text = "Hostname";
            // 
            // tbRHBHost
            // 
            this.tbRHBHost.Location = new System.Drawing.Point(105, 19);
            this.tbRHBHost.Name = "tbRHBHost";
            this.tbRHBHost.Size = new System.Drawing.Size(120, 20);
            this.tbRHBHost.TabIndex = 1;
            // 
            // lstbRHBHosts
            // 
            this.lstbRHBHosts.FormattingEnabled = true;
            this.lstbRHBHosts.Location = new System.Drawing.Point(105, 45);
            this.lstbRHBHosts.Name = "lstbRHBHosts";
            this.lstbRHBHosts.Size = new System.Drawing.Size(120, 95);
            this.lstbRHBHosts.TabIndex = 0;
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.label4);
            this.groupBox1.Controls.Add(this.label2);
            this.groupBox1.Controls.Add(this.label1);
            this.groupBox1.Controls.Add(this.tbCheckInterval);
            this.groupBox1.Controls.Add(this.tbDeclareDeath);
            this.groupBox1.Location = new System.Drawing.Point(6, 6);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(443, 120);
            this.groupBox1.TabIndex = 2;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "HeartBeat Configuration";
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(77, 79);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(279, 13);
            this.label4.TabIndex = 7;
            this.label4.Text = "TvServer needs to be restarted for changes to take effect";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(11, 41);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(88, 13);
            this.label2.TabIndex = 3;
            this.label2.Text = "Interval to Check";
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(6, 16);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(93, 13);
            this.label1.TabIndex = 3;
            this.label1.Text = "Seconds to Death";
            // 
            // tbCheckInterval
            // 
            this.tbCheckInterval.Location = new System.Drawing.Point(105, 38);
            this.tbCheckInterval.Name = "tbCheckInterval";
            this.tbCheckInterval.Size = new System.Drawing.Size(62, 20);
            this.tbCheckInterval.TabIndex = 1;
            // 
            // tbDeclareDeath
            // 
            this.tbDeclareDeath.Location = new System.Drawing.Point(105, 13);
            this.tbDeclareDeath.Name = "tbDeclareDeath";
            this.tbDeclareDeath.Size = new System.Drawing.Size(62, 20);
            this.tbDeclareDeath.TabIndex = 0;
            // 
            // linkLabel1
            // 
            this.linkLabel1.AutoSize = true;
            this.linkLabel1.Location = new System.Drawing.Point(22, 145);
            this.linkLabel1.Name = "linkLabel1";
            this.linkLabel1.Size = new System.Drawing.Size(421, 13);
            this.linkLabel1.TabIndex = 7;
            this.linkLabel1.TabStop = true;
            this.linkLabel1.Text = "http://forum.team-mediaportal.com/tv-server-plugins-294/wip-homeserver-plugin-687" +
                "93/";
            this.linkLabel1.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.linkLabel1_LinkClicked);
            // 
            // HomeServerUserControl
            // 
            this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
            this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
            this.Controls.Add(this.tabControl1);
            this.Name = "HomeServerUserControl";
            this.Size = new System.Drawing.Size(500, 500);
            this.tabControl1.ResumeLayout(false);
            this.tabPage1.ResumeLayout(false);
            this.tabPage1.PerformLayout();
            this.groupBox3.ResumeLayout(false);
            this.groupBox3.PerformLayout();
            this.tabPage2.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.groupBox2.PerformLayout();
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            this.ResumeLayout(false);

        }

        public override void OnSectionActivated()
        {
            TvBusinessLayer layer = new TvBusinessLayer();
            if (!Convert.ToBoolean(layer.GetSetting("pluginPower Scheduler", "false").Value))
            {
                this.lbWarning.Text = "WARNING: The HeartBeat Monitor needs Power Scheduler to be activated an configured";
            }
            this.lbWarning.Text = "PowerScheduler is activated";
            Setting setting = layer.GetSetting("HomeServer HBM DeclareDeath", "45");
            this.tbDeclareDeath.Text = setting.Value;
            setting = layer.GetSetting("HomeServer HBM CheckInterval", "60");
            this.tbCheckInterval.Text = setting.Value;
            setting = layer.GetSetting("HomeServer ExtensiveLogging", "false");
            this.cbExtensiveLogging.Checked = Convert.ToBoolean(setting.Value);
            this.lstbRHBHosts.Items.Clear();
            string str = layer.GetSetting("HomeServer RHBM Hosts", "").Value;
            if (str != "")
            {
                foreach (string str2 in str.Split(";".ToCharArray()))
                {
                    this.lstbRHBHosts.Items.Add(str2);
                }
            }

            base.OnSectionActivated();
        }

        public override void OnSectionDeActivated()
        {
            TvBusinessLayer layer = new TvBusinessLayer();
            Setting setting = layer.GetSetting("HomeServer HBM DeclareDeath", "45");
            setting.Value = this.tbDeclareDeath.Text.ToString();
            setting.Persist();
            setting = layer.GetSetting("HomeServer HBM CheckInterval", "60");
            setting.Value = this.tbCheckInterval.Text.ToString();
            setting.Persist();
            setting = layer.GetSetting("HomeServer ExtensiveLogging", "false");
            setting.Value = this.cbExtensiveLogging.Checked.ToString();
            setting.Persist();
            string str = "";
            for (int i = 0; i < this.lstbRHBHosts.Items.Count; i++)
            {
                str = str + this.lstbRHBHosts.Items[i].ToString() + ";";
            }
            str = str.TrimEnd(";".ToCharArray());
            setting = layer.GetSetting("HomeServer RHBM Hosts", "");
            setting.Value = str;
            setting.Persist();
            base.OnSectionDeActivated();
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            // Specify that the link was visited.
            this.linkLabel1.LinkVisited = true;

            // Navigate to a URL.
            System.Diagnostics.Process.Start("http://forum.team-mediaportal.com/tv-server-plugins-294/wip-homeserver-plugin-68793/");
        }
    }

 

}

 

