﻿using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Timers;
using System.Windows.Forms;
using ConfigHandler;
using NetworkHandler;
using System.Net.NetworkInformation;
using System.Net;

namespace MPHSClient
{
    public class Main : Form
    {
        // Fields
        private Config _config;
        private bool _configValid;
        private Button btFind;
        private Button btToSysTray;
        private IContainer components;
        private bool firstShow;
        private GroupBox groupBox1;
        private GroupBox groupBox2;
        private ToolStripMenuItem itemExit;
        private ToolStripMenuItem itemRestore;
        private ToolStripMenuItem itemShare;
        private Label label1;
        private Label label2;
        private Label label3;
        private Label label4;
        private Label label5;
        private Label lbVersion;
        private ContextMenuStrip notifyContextMenu;
        private NotifyIcon notifyIcon;
        private TextBox tbHostname;
        private TextBox tbIP;
        private TextBox tbMAC;
        private TextBox tbNetwork;
        private TextBox tbTimer;
        private System.Timers.Timer timerHeartBeat;
        private System.Timers.Timer timerWOL;
        private Label label6;
        private Label label7;
        private ToolStripSeparator toolStripSeparator1;

        // Methods
        public Main()
        {
            this.InitializeComponent();
            this.firstShow = true;
            this.lbVersion.Text = Application.ProductVersion;
            this._configValid = false;
            this.timerHeartBeat = new System.Timers.Timer();
            this.timerHeartBeat.Interval = 15000.0;
            this.timerHeartBeat.AutoReset = true;
            this.timerWOL = new System.Timers.Timer();
            this.timerWOL.Interval = 2000.0;
            this.timerWOL.AutoReset = true;
            NetworkChange.NetworkAvailabilityChanged += new NetworkAvailabilityChangedEventHandler(this.NetworkChange_NetworkAvailabilityChanged);
            this.timerHeartBeat.Elapsed += new ElapsedEventHandler(this.timerHeartBeat_Elapsed);
            this.timerWOL.Elapsed += new ElapsedEventHandler(this.timerWOL_Elapsed);
            this._config = new Config();
            this.tbHostname.Text = this._config.GetValue("Hostname", "");
            this.tbIP.Text = this._config.GetValue("IP", "");
            this.tbMAC.Text = this._config.GetValue("MAC", "");
            if (((this.tbHostname.Text == "") || (this.tbIP.Text == "")) || (this.tbMAC.Text == ""))
            {
                MessageBox.Show("Need Config");
                this.firstShow = false;
            }
            else
            {
                this._configValid = true;
                this.timerWOL.Enabled = true;
                base.Hide();
            }
            GC.KeepAlive(timerHeartBeat);
            GC.KeepAlive(timerWOL);

        }

        private void browseSharedfolderToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ProcessStartInfo startInfo = new ProcessStartInfo("explorer.exe", @"\\" + this.tbHostname.Text + @"\");
            Process.Start(startInfo);
        }

        private void btFind_Click(object sender, EventArgs e)
        {
            this.tbIP.Text = "";
            this.tbMAC.Text = "";
            this.timerWOL.Enabled = false;
            this.timerWOL.Enabled = false;
            this._configValid = false;
            if (!Info.isNetworkAvaible())
            {
                MessageBox.Show("No Network Avaible");
            }
            else if (this.tbHostname.Text == "")
            {
                MessageBox.Show("No Hostname");
            }
            else if (!Info.isComputerAvaible(this.tbHostname.Text))
            {
                MessageBox.Show("Host is not avaible");
            }
            else
            {
                IPAddress ip = Info.HostnameToIPAddress(this.tbHostname.Text);
                if (ip == IPAddress.None)
                {
                    MessageBox.Show("Error while getting Host's IP");
                }
                else
                {
                    this.tbIP.Text = ip.ToString();
                    string mACAdress = Info.GetMACAdress(ip);
                    if (mACAdress == string.Empty)
                    {
                        MessageBox.Show("Error while getting MAC");
                    }
                    else
                    {
                        this.tbMAC.Text = mACAdress;
                        if (MessageBox.Show("Save Results", "Question", MessageBoxButtons.YesNo) == DialogResult.No)
                        {
                            this.tbIP.Text = "";
                            this.tbMAC.Text = "";
                        }
                        else
                        {
                            this._config.SetValue("Hostname", this.tbHostname.Text);
                            this._config.SetValue("MAC", this.tbMAC.Text);
                            this._config.SetValue("IP", this.tbIP.Text);
                            this._configValid = true;
                            this.timerWOL.Enabled = true;
                        }
                    }
                }
            }
        }

        private void btToSysTray_Click(object sender, EventArgs e)
        {
            base.Hide();
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Main));
            this.tbHostname = new System.Windows.Forms.TextBox();
            this.tbIP = new System.Windows.Forms.TextBox();
            this.tbMAC = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.btFind = new System.Windows.Forms.Button();
            this.label4 = new System.Windows.Forms.Label();
            this.tbTimer = new System.Windows.Forms.TextBox();
            this.label5 = new System.Windows.Forms.Label();
            this.tbNetwork = new System.Windows.Forms.TextBox();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.lbVersion = new System.Windows.Forms.Label();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.notifyIcon = new System.Windows.Forms.NotifyIcon(this.components);
            this.notifyContextMenu = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.itemShare = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this.itemRestore = new System.Windows.Forms.ToolStripMenuItem();
            this.itemExit = new System.Windows.Forms.ToolStripMenuItem();
            this.btToSysTray = new System.Windows.Forms.Button();
            this.label6 = new System.Windows.Forms.Label();
            this.label7 = new System.Windows.Forms.Label();
            this.groupBox1.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.notifyContextMenu.SuspendLayout();
            this.SuspendLayout();
            // 
            // tbHostname
            // 
            this.tbHostname.Location = new System.Drawing.Point(86, 13);
            this.tbHostname.Name = "tbHostname";
            this.tbHostname.Size = new System.Drawing.Size(122, 20);
            this.tbHostname.TabIndex = 0;
            // 
            // tbIP
            // 
            this.tbIP.Enabled = false;
            this.tbIP.Location = new System.Drawing.Point(86, 39);
            this.tbIP.Name = "tbIP";
            this.tbIP.Size = new System.Drawing.Size(122, 20);
            this.tbIP.TabIndex = 1;
            // 
            // tbMAC
            // 
            this.tbMAC.Enabled = false;
            this.tbMAC.Location = new System.Drawing.Point(86, 65);
            this.tbMAC.Name = "tbMAC";
            this.tbMAC.Size = new System.Drawing.Size(122, 20);
            this.tbMAC.TabIndex = 2;
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(25, 16);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(55, 13);
            this.label1.TabIndex = 3;
            this.label1.Text = "Hostname";
            // 
            // label2
            // 
            this.label2.AutoSize = true;
            this.label2.Location = new System.Drawing.Point(22, 42);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(58, 13);
            this.label2.TabIndex = 4;
            this.label2.Text = "IP-Address";
            // 
            // label3
            // 
            this.label3.AutoSize = true;
            this.label3.Location = new System.Drawing.Point(9, 68);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(71, 13);
            this.label3.TabIndex = 5;
            this.label3.Text = "MAC-Address";
            // 
            // btFind
            // 
            this.btFind.Location = new System.Drawing.Point(86, 91);
            this.btFind.Name = "btFind";
            this.btFind.Size = new System.Drawing.Size(122, 23);
            this.btFind.TabIndex = 6;
            this.btFind.Text = "Find";
            this.btFind.UseVisualStyleBackColor = true;
            this.btFind.Click += new System.EventHandler(this.btFind_Click);
            // 
            // label4
            // 
            this.label4.AutoSize = true;
            this.label4.Location = new System.Drawing.Point(6, 22);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(85, 13);
            this.label4.TabIndex = 7;
            this.label4.Text = "Network Avaible";
            // 
            // tbTimer
            // 
            this.tbTimer.Enabled = false;
            this.tbTimer.Location = new System.Drawing.Point(97, 45);
            this.tbTimer.Name = "tbTimer";
            this.tbTimer.Size = new System.Drawing.Size(111, 20);
            this.tbTimer.TabIndex = 10;
            // 
            // label5
            // 
            this.label5.AutoSize = true;
            this.label5.Location = new System.Drawing.Point(25, 48);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(66, 13);
            this.label5.TabIndex = 11;
            this.label5.Text = "Active Timer";
            // 
            // tbNetwork
            // 
            this.tbNetwork.Enabled = false;
            this.tbNetwork.Location = new System.Drawing.Point(97, 19);
            this.tbNetwork.Name = "tbNetwork";
            this.tbNetwork.Size = new System.Drawing.Size(111, 20);
            this.tbNetwork.TabIndex = 12;
            // 
            // groupBox1
            // 
            this.groupBox1.Controls.Add(this.tbNetwork);
            this.groupBox1.Controls.Add(this.label5);
            this.groupBox1.Controls.Add(this.tbTimer);
            this.groupBox1.Controls.Add(this.label4);
            this.groupBox1.Location = new System.Drawing.Point(12, 193);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(224, 104);
            this.groupBox1.TabIndex = 13;
            this.groupBox1.TabStop = false;
            this.groupBox1.Text = "Status";
            // 
            // lbVersion
            // 
            this.lbVersion.AutoSize = true;
            this.lbVersion.Location = new System.Drawing.Point(206, 37);
            this.lbVersion.Name = "lbVersion";
            this.lbVersion.Size = new System.Drawing.Size(44, 13);
            this.lbVersion.TabIndex = 13;
            this.lbVersion.Text = "X.X.X.X";
            // 
            // groupBox2
            // 
            this.groupBox2.BackColor = System.Drawing.SystemColors.Control;
            this.groupBox2.Controls.Add(this.label1);
            this.groupBox2.Controls.Add(this.tbHostname);
            this.groupBox2.Controls.Add(this.btFind);
            this.groupBox2.Controls.Add(this.tbIP);
            this.groupBox2.Controls.Add(this.label3);
            this.groupBox2.Controls.Add(this.tbMAC);
            this.groupBox2.Controls.Add(this.label2);
            this.groupBox2.Location = new System.Drawing.Point(12, 56);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(224, 131);
            this.groupBox2.TabIndex = 14;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "Configuration";
            // 
            // notifyIcon
            // 
            this.notifyIcon.ContextMenuStrip = this.notifyContextMenu;
            this.notifyIcon.Icon = ((System.Drawing.Icon)(resources.GetObject("notifyIcon.Icon")));
            this.notifyIcon.Text = "MPHSClient";
            this.notifyIcon.Visible = true;
            this.notifyIcon.DoubleClick += new System.EventHandler(this.notifyIcon_DoubleClick);
            // 
            // notifyContextMenu
            // 
            this.notifyContextMenu.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.itemShare,
            this.toolStripSeparator1,
            this.itemRestore,
            this.itemExit});
            this.notifyContextMenu.Name = "notifyContextMenu";
            this.notifyContextMenu.Size = new System.Drawing.Size(183, 76);
            // 
            // itemShare
            // 
            this.itemShare.Name = "itemShare";
            this.itemShare.Size = new System.Drawing.Size(182, 22);
            this.itemShare.Text = "Browse Sharedfolder";
            this.itemShare.Click += new System.EventHandler(this.browseSharedfolderToolStripMenuItem_Click);
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(179, 6);
            // 
            // itemRestore
            // 
            this.itemRestore.Name = "itemRestore";
            this.itemRestore.Size = new System.Drawing.Size(182, 22);
            this.itemRestore.Text = "Restore";
            this.itemRestore.Click += new System.EventHandler(this.itemRestore_Click);
            // 
            // itemExit
            // 
            this.itemExit.Name = "itemExit";
            this.itemExit.Size = new System.Drawing.Size(182, 22);
            this.itemExit.Text = "Exit";
            this.itemExit.Click += new System.EventHandler(this.itemExit_Click);
            // 
            // btToSysTray
            // 
            this.btToSysTray.Location = new System.Drawing.Point(12, 303);
            this.btToSysTray.Name = "btToSysTray";
            this.btToSysTray.Size = new System.Drawing.Size(224, 23);
            this.btToSysTray.TabIndex = 15;
            this.btToSysTray.Text = "Back to Systray";
            this.btToSysTray.UseVisualStyleBackColor = true;
            this.btToSysTray.Click += new System.EventHandler(this.btToSysTray_Click);
            // 
            // label6
            // 
            this.label6.AutoSize = true;
            this.label6.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label6.Location = new System.Drawing.Point(8, 9);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(103, 20);
            this.label6.TabIndex = 16;
            this.label6.Text = "Mediaportal";
            // 
            // label7
            // 
            this.label7.AutoSize = true;
            this.label7.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label7.Location = new System.Drawing.Point(8, 32);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(164, 20);
            this.label7.TabIndex = 17;
            this.label7.Text = "Home Server Client";
            // 
            // Main
            // 
            this.BackColor = System.Drawing.SystemColors.Control;
            this.ClientSize = new System.Drawing.Size(248, 330);
            this.Controls.Add(this.label7);
            this.Controls.Add(this.label6);
            this.Controls.Add(this.groupBox2);
            this.Controls.Add(this.lbVersion);
            this.Controls.Add(this.btToSysTray);
            this.Controls.Add(this.groupBox1);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MaximizeBox = false;
            this.Name = "Main";
            this.Text = "MPHSClient Configuration";
            this.Shown += new System.EventHandler(this.Main_Shown);
            this.Resize += new System.EventHandler(this.Main_Resize);
            this.groupBox1.ResumeLayout(false);
            this.groupBox1.PerformLayout();
            this.groupBox2.ResumeLayout(false);
            this.groupBox2.PerformLayout();
            this.notifyContextMenu.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

        }

        private void itemExit_Click(object sender, EventArgs e)
        {
            base.Close();
        }

        private void itemRestore_Click(object sender, EventArgs e)
        {
            base.Show();
        }

        private void Main_Resize(object sender, EventArgs e)
        {
            if (base.WindowState == FormWindowState.Minimized)
            {
                base.Hide();
            }
            if (base.WindowState == FormWindowState.Maximized)
            {
                base.WindowState = FormWindowState.Normal;
            }
        }

        private void Main_Shown(object sender, EventArgs e)
        {
            if (this.firstShow)
            {
                base.Hide();
                this.firstShow = false;
            }
        }

        private void NetworkChange_NetworkAvailabilityChanged(object sender, NetworkAvailabilityEventArgs e)
        {
            if (e.IsAvailable)
            {
                this.timerHeartBeat.Enabled = false;
                this.timerWOL.Enabled = true;
                this.notifyContextMenu.Items["itemShare"].Enabled = true;
            }
            else
            {
                this.timerWOL.Enabled = false;
                this.timerHeartBeat.Enabled = false;
                this.notifyContextMenu.Items["itemShare"].Enabled = false;
            }
        }

        private void notifyIcon_DoubleClick(object sender, EventArgs e)
        {
            base.Show();
            base.WindowState = FormWindowState.Normal;
        }

        private void timerHeartBeat_Elapsed(object sender, ElapsedEventArgs e)
        {
            if (this._configValid && Info.isNetworkAvaible())
            {
                if (!Info.isComputerAvaible(this.tbHostname.Text))
                {
                    this.timerWOL.Enabled = true;
                    this.timerHeartBeat.Enabled = false;
                }
                else
                {
                    HeartBeat.Send(this.tbHostname.Text, Application.ProductName + " " + Application.ProductVersion);
                }
            }
        }

        private void timerWOL_Elapsed(object sender, ElapsedEventArgs e)
        {
            if (this._configValid && Info.isNetworkAvaible())
            {
                WOL.sendMagicPacket(this.tbMAC.Text);
                this.timerHeartBeat.Enabled = true;
                this.timerWOL.Enabled = false;
            }
        }
    }
}
