﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Net;
using System.Net.Sockets;
using System.Net.NetworkInformation;
using System.Text.RegularExpressions;
using System.Globalization;

namespace NetworkHandler
{

    public static class Info
    {


        // Methods
        public static string GetMACAdress(IPAddress ip)
        {
            try
            {
                byte[] pMacAddr = new byte[6];
                int length = pMacAddr.Length;
                SendARP((int)ip.Address, 0, pMacAddr, ref length);
                return BitConverter.ToString(pMacAddr, 0, 6).Replace("-", ":");
            }
            catch (Exception)
            {
                return string.Empty;
            }
        }

        public static IPAddress HostnameToIPAddress(string hostname)
        {
            try
            {
                return Dns.GetHostEntry(hostname).AddressList[0];
            }
            catch (Exception)
            {
                return IPAddress.None;
            }
        }

        public static bool isComputerAvaible(string hostName)
        {
            try
            {
                Ping ping = new Ping();
                return (ping.Send(hostName, 100).Status == IPStatus.Success);
            }
            catch (Exception)
            {
                return false;
            }
        }

        public static bool isNetworkAvaible()
        {
            return NetworkInterface.GetIsNetworkAvailable();
        }

        [DllImport("iphlpapi.dll", ExactSpelling = true)]
        private static extern int SendARP(int DestIP, int SrcIP, [Out] byte[] pMacAddr, ref int PhyAddrLen);

    }







}
