﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Net;
using System.Net.Sockets;
using System.Net.NetworkInformation;
using System.Text.RegularExpressions;
using System.Globalization;

namespace NetworkHandler
{

    public static class HeartBeat
    {
        // Methods
        public static bool Send(string hostName, string msg)
        {
            byte[] bytes = new byte[0x100];
            try
            {
                Socket socket = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
                //IPAddress remoteAdress = Dns.GetHostByName(hostName).AddressList[0];
                IPAddress remoteAdress = Dns.GetHostEntry(hostName).AddressList[0];
                IPEndPoint remoteEP = new IPEndPoint(remoteAdress, 0xfaa);
                bytes = Encoding.ASCII.GetBytes(msg);
                socket.SendTo(bytes, 0, bytes.Length, SocketFlags.None, remoteEP);
                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }

    }


    public static class WOL
    {
        // Methods
        public static bool isMAC(string mac)
        {
            string pattern = @"(([a-f]|[0-9]|[A-F]){2}\:){5}([a-f]|[0-9]|[A-F]){2}\b";
            return Regex.IsMatch(mac, pattern);
        }

        public static bool sendMagicPacket(string MACAddress)
        {
            if (isMAC(MACAddress))
            {
                byte[] buffer = new byte[] { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };
                byte[] buffer2 = StringToByteArray(MACAddress);
                byte[] array = new byte[0x66];
                buffer.CopyTo(array, 0);
                for (int i = 1; i <= 0x10; i++)
                {
                    buffer2.CopyTo(array, (int)(i * 6));
                }
                UdpClient client = new UdpClient();
                try
                {
                    client.Connect(IPAddress.Broadcast, 0x9c40);
                    client.Send(array, array.Length);
                    return true;
                }
                catch (Exception)
                {
                    return false;
                }
            }
            return false;
        }

        private static byte[] StringToByteArray(string MACAddress)
        {
            string[] strArray = MACAddress.Split(new char[] { ':' });
            byte[] buffer = new byte[6];
            for (int i = 0; i < strArray.Length; i++)
            {
                buffer[i] = byte.Parse(strArray[i], NumberStyles.HexNumber);
            }
            return buffer;
        }
    }

 


}
